/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.tracker;

import com.tds.common.tracker.TdsTracker;
import com.tds.common.tracker.TdsTrackerConfig;
import com.tds.common.tracker.model.ActionModel;
import com.tds.common.tracker.model.LoginModel;
import com.tds.common.tracker.model.NetworkStateModel;
import com.tds.common.tracker.model.PageModel;
import com.tds.common.tracker.model.UserModel;
import java.util.HashMap;
import java.util.Map;

public class TdsTrackerManager {
    private int trackerType;
    private TrackerEvent trackerEvent;

    public static void registerTracker(TdsTrackerConfig tdsTrackerConfig) {
        TdsTracker.initTdsTracker(tdsTrackerConfig);
    }

    public static TdsTrackerManager getInstance() {
        return Holder.INSTANCE;
    }

    public TdsTrackerManager withTrackerType(int trackerType) {
        this.trackerType = trackerType;
        return this;
    }

    public TdsTrackerManager withTrackerEvent(TrackerEvent builder) {
        this.trackerEvent = builder;
        return this;
    }

    public void track() {
        try {
            TdsTracker.get(this.trackerType).track(this.convert());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public Map<String, String> convert() throws Exception {
        HashMap<String, String> trackDataMap = new HashMap<String, String>();
        trackDataMap.put("time", String.valueOf(System.currentTimeMillis() / 1000L));
        trackDataMap.putAll(this.trackerEvent.build());
        return trackDataMap;
    }

    public static class TrackerEvent {
        private PageModel pageModel = null;
        private ActionModel actionModel = null;
        private NetworkStateModel networkStateModel = null;
        private LoginModel loginModel = null;
        private UserModel meModel = null;

        public TrackerEvent withMeModel(UserModel meModel) {
            this.meModel = meModel;
            return this;
        }

        public TrackerEvent withLoginModel(LoginModel loginModel) {
            this.loginModel = loginModel;
            return this;
        }

        public TrackerEvent withPageModel(PageModel pageModel) {
            this.pageModel = pageModel;
            return this;
        }

        public TrackerEvent withActionModel(ActionModel actionModel) {
            this.actionModel = actionModel;
            return this;
        }

        public TrackerEvent withNetworkStateModel(NetworkStateModel networkStateModel) {
            this.networkStateModel = networkStateModel;
            return this;
        }

        public Map<String, String> build() throws Exception {
            HashMap<String, String> result = new HashMap<String, String>();
            if (this.meModel != null) {
                result.putAll(this.meModel.convert());
            }
            if (this.actionModel != null) {
                result.putAll(this.actionModel.convert());
            }
            if (this.pageModel != null) {
                result.putAll(this.pageModel.convert());
            }
            if (this.loginModel != null) {
                result.putAll(this.loginModel.convert());
            }
            if (this.networkStateModel != null) {
                result.putAll(this.networkStateModel.convert());
            }
            return result;
        }
    }

    public static class Holder {
        public static TdsTrackerManager INSTANCE = new TdsTrackerManager();
    }
}

