/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.utils;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.text.format.Formatter;
import com.tds.common.utils.CommonUtils;
import java.util.Locale;

public class DeviceUtils {
    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getCurLanguageDisplayName() {
        Locale locale = CommonUtils.getCurrentLocale();
        return locale.getLanguage() + "-" + locale.getCountry();
    }

    public static String getAndroidId(Context context) {
        try {
            return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getDeviceTotalRam(Context context) {
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            if (manager == null) {
                return null;
            }
            manager.getMemoryInfo(info);
            return Formatter.formatFileSize((Context)context, (long)info.totalMem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDeviceTotalRom(Context context) {
        try {
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            long total = Build.VERSION.SDK_INT >= 18 ? statFs.getBlockCountLong() * statFs.getBlockSizeLong() : (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            return Formatter.formatFileSize((Context)context, (long)total);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRemainingRamSize(Context context) {
        String result = "";
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(info);
            long availMem = info.availMem;
            result = String.valueOf(availMem);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return result;
    }

    public static String getRemainingRomSize() {
        String result = "";
        try {
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            long availableCounts = statFs.getAvailableBlocksLong();
            long size = statFs.getBlockSizeLong();
            long availROMSize = availableCounts * size;
            result = String.valueOf(availROMSize);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return result;
    }

    public static String getPlatform() {
        return "Android";
    }

    public static String getCpuInfo() {
        return Build.CPU_ABI;
    }

    public static int getPackageVersionCode(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getPackageVersion(Context context) {
        String version = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            version = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    public static boolean isAppExist(Context context, String pkgName) {
        ApplicationInfo info;
        try {
            info = context.getPackageManager().getApplicationInfo(pkgName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            info = null;
        }
        return info != null;
    }
}

