/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.image;

import android.content.Context;
import com.tds.common.io.DiskLruCache;
import com.tds.common.widgets.image.ImageUtil;
import java.io.File;
import java.io.IOException;

class DiskCache {
    private final DiskLruCache diskLruCache;

    DiskCache(Context context) {
        this.diskLruCache = this.openCache(context);
    }

    private DiskLruCache openCache(Context context) {
        File cacheDir = new File(context.getCacheDir(), "tds-image");
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        long diskCacheSize = ImageUtil.calculateDiskCacheSize(cacheDir);
        try {
            return DiskLruCache.open(cacheDir, 0, 1, diskCacheSize);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    File get(String key) throws IOException {
        DiskLruCache.Value value = this.diskLruCache.get(key);
        if (value != null) {
            return value.getFile(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String key, Writer writer) throws IOException {
        DiskLruCache.Editor editor = this.diskLruCache.edit(key);
        try {
            File file = editor.getFile(0);
            if (writer.write(file)) {
                editor.commit();
            }
        }
        finally {
            editor.abortUnlessCommitted();
        }
    }

    public static interface Writer {
        public boolean write(File var1) throws IOException;
    }
}

