/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.image;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.os.StatFs;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class ImageUtil {
    private static final int MIN_DISK_CACHE_SIZE = 0x3200000;
    private static final int MAX_DISK_CACHE_SIZE = 524288000;

    ImageUtil() {
    }

    public static int getBitmapBytes(Bitmap bitmap) {
        int result;
        int n = result = Build.VERSION.SDK_INT >= 19 ? bitmap.getAllocationByteCount() : bitmap.getByteCount();
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + bitmap);
        }
        return result;
    }

    static long calculateDiskCacheSize(File dir) {
        long size = 0x3200000L;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long blockCount = statFs.getBlockCountLong();
            long blockSize = statFs.getBlockSizeLong();
            long available = blockCount * blockSize;
            size = available / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Math.max(Math.min(size, 524288000L), 0x3200000L);
    }

    static int calculateMemoryCacheSize(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        boolean largeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClass = largeHeap ? am.getLargeMemoryClass() : am.getMemoryClass();
        return (int)(0x100000L * (long)memoryClass / 4L);
    }

    static boolean isMain() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    static void checkMain() {
        if (!ImageUtil.isMain()) {
            throw new IllegalStateException("method must called on main thread");
        }
    }

    static String getMd5(String in) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] bytes = digest.digest(in.getBytes());
        BigInteger bigInt = new BigInteger(1, bytes);
        return bigInt.toString(16);
    }
}

