/*
 * Decompiled with CFR 0.152.
 */
package jxp.android.support.v4.provider;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import java.io.File;
import jxp.android.support.v4.provider.DocumentsContractApi19;
import jxp.android.support.v4.provider.DocumentsContractApi21;
import jxp.android.support.v4.provider.RawDocumentFile;
import jxp.android.support.v4.provider.SingleDocumentFile;
import jxp.android.support.v4.provider.TreeDocumentFile;

public abstract class DocumentFile {
    static final String TAG = "DocumentFile";
    private final DocumentFile mParent;

    DocumentFile(DocumentFile parent) {
        this.mParent = parent;
    }

    public static DocumentFile fromFile(File file) {
        return new RawDocumentFile(null, file);
    }

    public static DocumentFile fromSingleUri(Context context, Uri singleUri) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return new SingleDocumentFile(null, context, singleUri);
        }
        return null;
    }

    public static DocumentFile fromTreeUri(Context context, Uri treeUri) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 21) {
            return new TreeDocumentFile(null, context, DocumentsContractApi21.prepareTreeUri(treeUri));
        }
        return null;
    }

    public static boolean isDocumentUri(Context context, Uri uri) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return DocumentsContractApi19.isDocumentUri(context, uri);
        }
        return false;
    }

    public abstract DocumentFile createFile(String var1, String var2);

    public abstract DocumentFile createDirectory(String var1);

    public abstract Uri getUri();

    public abstract String getName();

    public abstract String getType();

    public DocumentFile getParentFile() {
        return this.mParent;
    }

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract long lastModified();

    public abstract long length();

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract boolean delete();

    public abstract boolean exists();

    public abstract DocumentFile[] listFiles();

    public DocumentFile findFile(String displayName) {
        for (DocumentFile doc : this.listFiles()) {
            if (!displayName.equals(doc.getName())) continue;
            return doc;
        }
        return null;
    }

    public abstract boolean renameTo(String var1);
}

