/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.sdk.douyou.Constant;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.activity.H5PayActivity;
import com.sdk.douyou.adapter.DouyouActivityCallbackAdapter;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.listen.ZfbPaymentInterface;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.ResourceUtil;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouHttpUtil;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentDialog
extends Dialog {
    private Context mContext;
    private OrderInfoBean orderInfo;
    private ZfbPaymentInterface zfbCallback;
    private TextView tvProduct;
    private TextView tvMoney;
    private LinearLayout dy_dialog_youhuijuan_ll;
    private TextView dy_dialog_youhuijuan_deletion;
    private TextView douyou_pay_true_money_tv;
    private String is_use_coupon = "0";
    private String coupon_id = "0";
    private boolean isStartUp = false;
    private int resumeTime = 1;
    private Spinner douyou_pay_coupon_spinner;
    private String[] items;
    private int payType = 0;
    private RelativeLayout rl_goods;
    private DouyouActivityCallbackAdapter douyouActivityCallbackAdapter = null;

    public PaymentDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.mContext = context;
    }

    public void setOrderInfo(OrderInfoBean orderInfo) {
        this.orderInfo = orderInfo;
    }

    public void setPayType(int payType) {
        this.payType = payType;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
        this.setContentView(ResourceUtil.getLayoutId(this.mContext, "payment_dialog"));
        this.findViewById(ResourceUtil.getId(this.mContext, "payment_close")).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PaymentDialog.this.dismiss();
            }
        });
        this.dy_dialog_youhuijuan_ll = (LinearLayout)this.findViewById(ResourceUtil.getId(this.mContext, "dy_dialog_youhuijuan_ll"));
        this.items = new String[]{"\u8bf7\u9009\u62e9", "\u4e0d\u4f7f\u7528", "10\u5143\u6863\u4f4d0.1\u6298\u5238", "10\u5143\u6863\u4f4d0.2\u6298\u5238", "10\u5143\u6863\u4f4d0.3\u6298\u5238"};
        this.douyou_pay_coupon_spinner = (Spinner)this.findViewById(ResourceUtil.getId(this.mContext, "douyou_pay_coupon_spinner"));
        DouYouCouponAdapter adapter = new DouYouCouponAdapter(this.items, this.mContext);
        this.douyou_pay_coupon_spinner.setAdapter((SpinnerAdapter)adapter);
        this.douyou_pay_coupon_spinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new DouYouSelectedListener());
        this.dy_dialog_youhuijuan_deletion = (TextView)this.findViewById(ResourceUtil.getId(this.mContext, "dy_dialog_youhuijuan_deletion"));
        this.tvProduct = (TextView)this.findViewById(ResourceUtil.getId(this.mContext, "tv_productName"));
        this.tvMoney = (TextView)this.findViewById(ResourceUtil.getId(this.mContext, "tv_orderMoney"));
        this.douyou_pay_true_money_tv = (TextView)this.findViewById(ResourceUtil.getId(this.mContext, "douyou_pay_true_money_tv"));
        this.rl_goods = (RelativeLayout)this.findViewById(ResourceUtil.getId(this.mContext, "rl_goods"));
        if (this.payType == 0 && Constant.platform_currency_status == 1) {
            this.rl_goods.setVisibility(0);
            this.rl_goods.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PaymentDialog.this.douyouGoods();
                }
            });
        }
        final RelativeLayout rl_wx = (RelativeLayout)this.findViewById(ResourceUtil.getId(this.mContext, "rl_wx"));
        final RelativeLayout rl_zfb = (RelativeLayout)this.findViewById(ResourceUtil.getId(this.mContext, "rl_zfb"));
        rl_wx.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                rl_wx.setClickable(false);
                rl_zfb.setClickable(false);
                PaymentDialog.this.wechatPayment(PaymentDialog.this.is_use_coupon, PaymentDialog.this.coupon_id);
            }
        });
        rl_zfb.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                rl_wx.setClickable(false);
                rl_zfb.setClickable(false);
                PaymentDialog.this.zfbPayment(PaymentDialog.this.is_use_coupon, PaymentDialog.this.coupon_id);
            }
        });
        this.douyouActivityCallbackAdapter = new DouyouActivityCallbackAdapter(){

            @Override
            public void onResume() {
                if (PaymentDialog.this.isStartUp) {
                    if (PaymentDialog.this.resumeTime == 1) {
                        DouYou.getInstance().CheckOrder(PaymentDialog.this.orderInfo);
                        PaymentDialog.this.resumeTime = 0;
                    }
                    DouYou.getInstance().removeActivityCallback(PaymentDialog.this.douyouActivityCallbackAdapter);
                    PaymentDialog.this.dismiss();
                }
            }
        };
        DouYou.getInstance().setActivityCallback(this.douyouActivityCallbackAdapter);
    }

    private void douyouGoods() {
    }

    public void onStart() {
        super.onStart();
        this.tvProduct.post(new Runnable(){

            @Override
            public void run() {
                PaymentDialog.this.tvProduct.setText((CharSequence)PaymentDialog.this.orderInfo.getProductName());
            }
        });
        this.tvMoney.post(new Runnable(){

            @Override
            public void run() {
                PaymentDialog.this.tvMoney.setText((CharSequence)("\u00a5 " + PaymentDialog.this.orderInfo.getCpOrderMoney() + "\u5143"));
            }
        });
        this.dy_dialog_youhuijuan_deletion.post(new Runnable(){

            @Override
            public void run() {
                PaymentDialog.this.dy_dialog_youhuijuan_deletion.setText((CharSequence)("\u00a5 " + PaymentDialog.this.orderInfo.getDiscount_money() + "\u5143"));
            }
        });
        this.douyou_pay_true_money_tv.post(new Runnable(){

            @Override
            public void run() {
                PaymentDialog.this.douyou_pay_true_money_tv.setText((CharSequence)("\u00a5 " + PaymentDialog.this.orderInfo.getTrue_money() + "\u5143"));
            }
        });
    }

    private void zfbPayment(String is_use_coupon, String coupon_id) {
        String payUrl = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("source", "1");
        map.put("ad_id", Constant.adId);
        map.put("order_id", this.orderInfo.getXxx());
        map.put("token", DouYou.getInstance().loginSuccessBean.getToken());
        map.put("members_id", String.valueOf(DouYou.getInstance().loginSuccessBean.getMembers_id()));
        map.put("time_stamp", String.valueOf(System.currentTimeMillis()));
        payUrl = "https://api.aargame.com/" + BaLeApi.getInstance().aliPay + "?" + DouYouHttpUtil.getBody(map);
        LogUtil.debug(payUrl);
        Intent intent = new Intent(this.mContext, H5PayActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("url", payUrl);
        intent.putExtras(bundle);
        this.mContext.startActivity(intent);
        this.isStartUp = true;
        this.orderInfo.setCheckTimes(3);
        DouYou.getInstance().setOrders(this.orderInfo);
    }

    private void wechatPayment(String is_use_coupon, String coupon_id) {
        boolean weixinAvilible = true;
        if (weixinAvilible) {
            BaLeApi.getInstance().wxPay(this.orderInfo.getXxx(), new DouYouPostAsyncTask.HttpGetDataListener(){

                @Override
                public void getData(String returnData) {
                    try {
                        JSONObject objdata = new JSONObject(returnData);
                        String url = objdata.optString("pay_url");
                        LogUtil.debug(url);
                        if (!url.equals("")) {
                            Intent payIntent = Intent.parseUri((String)url, (int)1);
                            PaymentDialog.this.mContext.startActivity(payIntent);
                            PaymentDialog.this.isStartUp = true;
                            PaymentDialog.this.orderInfo.setCheckTimes(3);
                            DouYou.getInstance().setOrders(PaymentDialog.this.orderInfo);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        PaymentDialog.this.dismiss();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Toast.makeText((Context)PaymentDialog.this.mContext, (CharSequence)"\u8bf7\u5148\u5b89\u88c5\u5fae\u4fe1", (int)0).show();
                        PaymentDialog.this.dismiss();
                    }
                }

                @Override
                public void Fail(String error) {
                    PaymentDialog.this.dismiss();
                }
            });
        } else {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u8bf7\u5148\u5b89\u88c5\u5fae\u4fe1", (int)0).show();
            this.dismiss();
        }
    }

    public void setZfbCallback(ZfbPaymentInterface callback) {
        this.zfbCallback = callback;
    }

    private void goodsPayment(int payType) {
    }

    class DouYouCouponAdapter
    extends BaseAdapter {
        private String[] _myDataList;
        private Context _context;

        public DouYouCouponAdapter(String[] myDataList, Context context) {
            this._myDataList = myDataList;
            this._context = context;
        }

        public int getCount() {
            return this._myDataList.length;
        }

        public Object getItem(int position) {
            return this._myDataList[position];
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder = null;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this._context).inflate(ResourceUtil.getLayoutId(this._context, "douyou_custom_spinner_layout"), parent, false);
                holder = new ViewHolder();
                holder.douyou_couponlist_icon = (ImageView)convertView.findViewById(ResourceUtil.getId(this._context, "douyou_couponlist_icon"));
                holder.douyou_couponlist_txt = (TextView)convertView.findViewById(ResourceUtil.getId(this._context, "douyou_couponlist_txt"));
                holder.douyou_couponlist_tip = (TextView)convertView.findViewById(ResourceUtil.getId(this._context, "douyou_couponlist_tip"));
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            if (position == 0) {
                holder.douyou_couponlist_icon.setVisibility(0);
                holder.douyou_couponlist_txt.setText((CharSequence)this._myDataList[position]);
                holder.douyou_couponlist_tip.setVisibility(0);
            } else {
                holder.douyou_couponlist_icon.setVisibility(8);
                holder.douyou_couponlist_txt.setText((CharSequence)this._myDataList[position]);
                holder.douyou_couponlist_tip.setVisibility(8);
                if (holder.douyou_couponlist_icon.getVisibility() == 8) {
                    holder.douyou_couponlist_icon.setBackground(PaymentDialog.this.mContext.getDrawable(ResourceUtil.getDrawableId(PaymentDialog.this.mContext, "account_up")));
                }
            }
            return convertView;
        }

        class ViewHolder {
            ImageView douyou_couponlist_icon;
            TextView douyou_couponlist_txt;
            TextView douyou_couponlist_tip;

            ViewHolder() {
            }
        }
    }

    class DouYouSelectedListener
    implements AdapterView.OnItemSelectedListener {
        DouYouSelectedListener() {
        }

        public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
            view.findViewById(ResourceUtil.getId(PaymentDialog.this.mContext, "douyou_couponlist_tip")).setVisibility(0);
            view.findViewById(ResourceUtil.getId(PaymentDialog.this.mContext, "douyou_couponlist_icon")).setVisibility(0);
            view.findViewById(ResourceUtil.getId(PaymentDialog.this.mContext, "douyou_couponlist_icon")).setBackground(PaymentDialog.this.mContext.getDrawable(ResourceUtil.getDrawableId(PaymentDialog.this.mContext, "account_down")));
            LogUtil.debug("onItemSelected\uff1a" + PaymentDialog.this.items[i]);
        }

        public void onNothingSelected(AdapterView<?> adapterView) {
            LogUtil.debug("onNothingSelected\uff1a" + adapterView.getCount());
        }
    }
}

