/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.shanyan;

import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.widget.Toast;

public class ShanYanAbScreenUtils {
    private static Handler mainHandler;

    private ShanYanAbScreenUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int getScreenHeight(Context context, boolean isDp) {
        int screenHeight = 0;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        int height = dm.heightPixels;
        if (!isDp) {
            return height;
        }
        float density = dm.density;
        screenHeight = (int)((float)height / density);
        return screenHeight;
    }

    public static int getScreenWidth(Context context, boolean isDp) {
        int screenWidth = 0;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display defaultDisplay = wm.getDefaultDisplay();
        Point point = new Point();
        defaultDisplay.getSize(point);
        int winWidth = point.x > point.y ? point.y : point.x;
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        if (!isDp) {
            return winWidth;
        }
        float density = dm.density;
        screenWidth = (int)((float)winWidth / density);
        return screenWidth;
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static void showToast(final Context context, final String msg) {
        mainHandler = new Handler(Looper.getMainLooper());
        ShanYanAbScreenUtils.execute(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)context, (CharSequence)msg, (int)0).show();
            }
        });
    }

    private static void execute(Runnable runnable) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            mainHandler.post(runnable);
        }
    }
}

