/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.aggregation;

import com.bytedance.applog.aggregation.IMetricsCache;
import com.bytedance.applog.aggregation.IMetricsTracker;
import com.bytedance.applog.aggregation.IWorker;
import com.bytedance.applog.aggregation.Metrics;
import com.bytedance.applog.aggregation.UtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007H\u0002J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0002J\u001c\u0010#\u001a\u00020$2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/bytedance/applog/aggregation/MetricsTrackerImpl;", "Lcom/bytedance/applog/aggregation/IMetricsTracker;", "metricsName", "", "types", "", "dimensions", "", "interval", "", "cache", "Lcom/bytedance/applog/aggregation/IMetricsCache;", "worker", "Lcom/bytedance/applog/aggregation/IWorker;", "(Ljava/lang/String;ILjava/util/List;Ljava/util/List;Lcom/bytedance/applog/aggregation/IMetricsCache;Lcom/bytedance/applog/aggregation/IWorker;)V", "getCache", "()Lcom/bytedance/applog/aggregation/IMetricsCache;", "getDimensions", "()Ljava/util/List;", "getInterval", "getMetricsName", "()Ljava/lang/String;", "getTypes", "()I", "getWorker", "()Lcom/bytedance/applog/aggregation/IWorker;", "calculateMetricsInterval", "value", "", "getOrCreateMetrics", "Lcom/bytedance/applog/aggregation/Metrics;", "groupId", "params", "Lorg/json/JSONObject;", "metricsInterval", "track", "", "aggregation_release"})
public final class MetricsTrackerImpl
implements IMetricsTracker {
    @NotNull
    private final String metricsName;
    private final int types;
    @Nullable
    private final List<String> dimensions;
    @Nullable
    private final List<Number> interval;
    @NotNull
    private final IMetricsCache cache;
    @NotNull
    private final IWorker worker;

    @Override
    public void track(@Nullable Object value, @Nullable JSONObject params) {
        this.worker.post((Function0<Unit>)((Function0)new Function0<Unit>(this, value, params){
            final /* synthetic */ MetricsTrackerImpl this$0;
            final /* synthetic */ Object $value;
            final /* synthetic */ JSONObject $params;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                boolean isNew;
                String string;
                String metricsInterval = MetricsTrackerImpl.access$calculateMetricsInterval(this.this$0, this.$value, this.this$0.getInterval());
                List<String> list = this.this$0.getDimensions();
                if (list != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        JSONObject jSONObject = this.$params;
                        Object object = jSONObject != null ? jSONObject.opt((String)it) : null;
                        collection.add(object);
                    }
                    string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
                } else {
                    string = null;
                }
                String dimsId = string;
                String groupId = this.this$0.getMetricsName() + '|' + this.this$0.getTypes() + '|' + metricsInterval + '|' + dimsId;
                Metrics metrics = this.this$0.getCache().get(groupId);
                boolean bl = isNew = metrics == null;
                if (metrics == null) {
                    JSONObject jSONObject = this.$params;
                    metrics = new Metrics(this.this$0.getMetricsName(), groupId, this.this$0.getTypes(), System.currentTimeMillis(), (JSONObject)(jSONObject != null ? UtilsKt.copy(jSONObject) : null), metricsInterval);
                }
                metrics.append(this.$value);
                if (isNew) {
                    this.this$0.getCache().insert(groupId, metrics);
                } else {
                    this.this$0.getCache().update(groupId, metrics);
                }
            }
            {
                this.this$0 = metricsTrackerImpl;
                this.$value = object;
                this.$params = jSONObject;
                super(0);
            }
        }));
    }

    private final Metrics getOrCreateMetrics(String groupId, JSONObject params, String metricsInterval) {
        Metrics metrics = this.cache.get(groupId);
        if (metrics == null) {
            JSONObject jSONObject = params;
            metrics = new Metrics(this.metricsName, groupId, this.types, System.currentTimeMillis(), (JSONObject)(jSONObject != null ? UtilsKt.copy(jSONObject) : null), metricsInterval);
        }
        return metrics;
    }

    private final String calculateMetricsInterval(Object value, List<? extends Number> interval) {
        String metricsInterval = null;
        if ((this.types & 0x10) > 0) {
            List<? extends Number> list = interval;
            if (list != null) {
                Collection collection = list;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    if (value instanceof Number) {
                        String intervalCap = "+";
                        String intervalFloor = "";
                        double doubleV = ((Number)value).doubleValue();
                        for (Number number : interval) {
                            boolean bl2;
                            Object[] objectArray;
                            String string;
                            StringCompanionObject stringCompanionObject;
                            double compareV = number.doubleValue();
                            if (doubleV < compareV) {
                                stringCompanionObject = StringCompanionObject.INSTANCE;
                                string = "%.0f";
                                objectArray = new Object[]{compareV};
                                bl2 = false;
                                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                                intervalCap = string2;
                                break;
                            }
                            stringCompanionObject = StringCompanionObject.INSTANCE;
                            string = "%.0f";
                            objectArray = new Object[]{compareV};
                            bl2 = false;
                            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                        }
                        metricsInterval = '(' + intervalFloor + ',' + intervalCap + ')';
                    }
                }
            }
        }
        return metricsInterval;
    }

    @NotNull
    public final String getMetricsName() {
        return this.metricsName;
    }

    public final int getTypes() {
        return this.types;
    }

    @Nullable
    public final List<String> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    public final List<Number> getInterval() {
        return this.interval;
    }

    @NotNull
    public final IMetricsCache getCache() {
        return this.cache;
    }

    @NotNull
    public final IWorker getWorker() {
        return this.worker;
    }

    public MetricsTrackerImpl(@NotNull String metricsName, int types, @Nullable List<String> dimensions, @Nullable List<? extends Number> interval, @NotNull IMetricsCache cache, @NotNull IWorker worker) {
        Intrinsics.checkParameterIsNotNull((Object)metricsName, (String)"metricsName");
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        Intrinsics.checkParameterIsNotNull((Object)worker, (String)"worker");
        this.metricsName = metricsName;
        this.types = types;
        this.dimensions = dimensions;
        this.interval = interval;
        this.cache = cache;
        this.worker = worker;
    }

    public static final /* synthetic */ String access$calculateMetricsInterval(MetricsTrackerImpl $this, Object value, List interval) {
        return $this.calculateMetricsInterval(value, interval);
    }
}

