/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.widget.ListViewAutoScrollHelper;
import android.support.v7.appcompat.R;
import android.support.v7.graphics.drawable.DrawableWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.lang.reflect.Field;

class DropDownListView
extends ListView {
    public static final int INVALID_POSITION = -1;
    public static final int NO_POSITION = -1;
    private final Rect mSelectorRect = new Rect();
    private int mSelectionLeftPadding = 0;
    private int mSelectionTopPadding = 0;
    private int mSelectionRightPadding = 0;
    private int mSelectionBottomPadding = 0;
    private int mMotionPosition;
    private Field mIsChildViewEnabled;
    private GateKeeperDrawable mSelector;
    private boolean mListSelectionHidden;
    private boolean mHijackFocus;
    private boolean mDrawsInPressedState;
    private ViewPropertyAnimatorCompat mClickAnimation;
    private ListViewAutoScrollHelper mScrollHelper;
    private ResolveHoverRunnable mResolveHoverRunnable;

    DropDownListView(Context context, boolean hijackFocus) {
        super(context, null, R.attr.dropDownListViewStyle);
        this.mHijackFocus = hijackFocus;
        this.setCacheColorHint(0);
        try {
            this.mIsChildViewEnabled = AbsListView.class.getDeclaredField("mIsChildViewEnabled");
            this.mIsChildViewEnabled.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public boolean isInTouchMode() {
        return this.mHijackFocus && this.mListSelectionHidden || super.isInTouchMode();
    }

    public boolean hasWindowFocus() {
        return this.mHijackFocus || super.hasWindowFocus();
    }

    public boolean isFocused() {
        return this.mHijackFocus || super.isFocused();
    }

    public boolean hasFocus() {
        return this.mHijackFocus || super.hasFocus();
    }

    public void setSelector(Drawable sel) {
        this.mSelector = sel != null ? new GateKeeperDrawable(sel) : null;
        super.setSelector((Drawable)this.mSelector);
        Rect padding = new Rect();
        if (sel != null) {
            sel.getPadding(padding);
        }
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
    }

    protected void drawableStateChanged() {
        if (this.mResolveHoverRunnable != null) {
            return;
        }
        super.drawableStateChanged();
        this.setSelectorEnabled(true);
        this.updateSelectorStateCompat();
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean drawSelectorOnTop = false;
        this.drawSelectorCompat(canvas);
        super.dispatchDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mMotionPosition = this.pointToPosition((int)ev.getX(), (int)ev.getY());
            }
        }
        if (this.mResolveHoverRunnable != null) {
            this.mResolveHoverRunnable.cancel();
        }
        return super.onTouchEvent(ev);
    }

    public int lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.getAdapter();
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        int count = adapter.getCount();
        if (!this.getAdapter().areAllItemsEnabled()) {
            if (lookDown) {
                for (position = Math.max(0, position); position < count && !adapter.isEnabled(position); ++position) {
                }
            } else {
                for (position = Math.min(position, count - 1); position >= 0 && !adapter.isEnabled(position); --position) {
                }
            }
            if (position < 0 || position >= count) {
                return -1;
            }
            return position;
        }
        if (position < 0 || position >= count) {
            return -1;
        }
        return position;
    }

    public int measureHeightOfChildrenCompat(int widthMeasureSpec, int startPosition, int endPosition, int maxHeight, int disallowPartialChildPosition) {
        int paddingTop = this.getListPaddingTop();
        int paddingBottom = this.getListPaddingBottom();
        int paddingLeft = this.getListPaddingLeft();
        int paddingRight = this.getListPaddingRight();
        int reportedDividerHeight = this.getDividerHeight();
        Drawable divider = this.getDivider();
        ListAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return paddingTop + paddingBottom;
        }
        int returnedHeight = paddingTop + paddingBottom;
        int dividerHeight = reportedDividerHeight > 0 && divider != null ? reportedDividerHeight : 0;
        int prevHeightWithoutPartialChild = 0;
        View child = null;
        int viewType = 0;
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            ViewGroup.LayoutParams childLp;
            int newType = adapter.getItemViewType(i);
            if (newType != viewType) {
                child = null;
                viewType = newType;
            }
            if ((childLp = (child = adapter.getView(i, child, (ViewGroup)this)).getLayoutParams()) == null) {
                childLp = this.generateDefaultLayoutParams();
                child.setLayoutParams(childLp);
            }
            int heightMeasureSpec = childLp.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)childLp.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            child.measure(widthMeasureSpec, heightMeasureSpec);
            child.forceLayout();
            if (i > 0) {
                returnedHeight += dividerHeight;
            }
            if ((returnedHeight += child.getMeasuredHeight()) >= maxHeight) {
                return disallowPartialChildPosition >= 0 && i > disallowPartialChildPosition && prevHeightWithoutPartialChild > 0 && returnedHeight != maxHeight ? prevHeightWithoutPartialChild : maxHeight;
            }
            if (disallowPartialChildPosition < 0 || i < disallowPartialChildPosition) continue;
            prevHeightWithoutPartialChild = returnedHeight;
        }
        return returnedHeight;
    }

    private void setSelectorEnabled(boolean enabled) {
        if (this.mSelector != null) {
            this.mSelector.setEnabled(enabled);
        }
    }

    public boolean onHoverEvent(@NonNull MotionEvent ev) {
        if (Build.VERSION.SDK_INT < 26) {
            return super.onHoverEvent(ev);
        }
        int action = ev.getActionMasked();
        if (action == 10 && this.mResolveHoverRunnable == null) {
            this.mResolveHoverRunnable = new ResolveHoverRunnable();
            this.mResolveHoverRunnable.post();
        }
        boolean handled = super.onHoverEvent(ev);
        if (action == 9 || action == 7) {
            int position = this.pointToPosition((int)ev.getX(), (int)ev.getY());
            if (position != -1 && position != this.getSelectedItemPosition()) {
                View hoveredItem = this.getChildAt(position - this.getFirstVisiblePosition());
                if (hoveredItem.isEnabled()) {
                    this.setSelectionFromTop(position, hoveredItem.getTop() - this.getTop());
                }
                this.updateSelectorStateCompat();
            }
        } else {
            this.setSelection(-1);
        }
        return handled;
    }

    protected void onDetachedFromWindow() {
        this.mResolveHoverRunnable = null;
        super.onDetachedFromWindow();
    }

    public boolean onForwardedEvent(MotionEvent event, int activePointerId) {
        boolean handledEvent = true;
        boolean clearPressedItem = false;
        int actionMasked = event.getActionMasked();
        switch (actionMasked) {
            case 3: {
                handledEvent = false;
                break;
            }
            case 1: {
                handledEvent = false;
            }
            case 2: {
                int y;
                int activeIndex = event.findPointerIndex(activePointerId);
                if (activeIndex < 0) {
                    handledEvent = false;
                    break;
                }
                int x = (int)event.getX(activeIndex);
                int position = this.pointToPosition(x, y = (int)event.getY(activeIndex));
                if (position == -1) {
                    clearPressedItem = true;
                    break;
                }
                View child = this.getChildAt(position - this.getFirstVisiblePosition());
                this.setPressedItem(child, position, x, y);
                handledEvent = true;
                if (actionMasked != 1) break;
                this.clickPressedItem(child, position);
            }
        }
        if (!handledEvent || clearPressedItem) {
            this.clearPressedItem();
        }
        if (handledEvent) {
            if (this.mScrollHelper == null) {
                this.mScrollHelper = new ListViewAutoScrollHelper(this);
            }
            this.mScrollHelper.setEnabled(true);
            this.mScrollHelper.onTouch((View)this, event);
        } else if (this.mScrollHelper != null) {
            this.mScrollHelper.setEnabled(false);
        }
        return handledEvent;
    }

    private void clickPressedItem(View child, int position) {
        long id2 = this.getItemIdAtPosition(position);
        this.performItemClick(child, position, id2);
    }

    void setListSelectionHidden(boolean hideListSelection) {
        this.mListSelectionHidden = hideListSelection;
    }

    private void updateSelectorStateCompat() {
        Drawable selector = this.getSelector();
        if (selector != null && this.touchModeDrawsInPressedStateCompat() && this.isPressed()) {
            selector.setState(this.getDrawableState());
        }
    }

    private void drawSelectorCompat(Canvas canvas) {
        Drawable selector;
        if (!this.mSelectorRect.isEmpty() && (selector = this.getSelector()) != null) {
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    private void positionSelectorLikeTouchCompat(int position, View sel, float x, float y) {
        this.positionSelectorLikeFocusCompat(position, sel);
        Drawable selector = this.getSelector();
        if (selector != null && position != -1) {
            DrawableCompat.setHotspot(selector, x, y);
        }
    }

    private void positionSelectorLikeFocusCompat(int position, View sel) {
        boolean manageState;
        Drawable selector = this.getSelector();
        boolean bl = manageState = selector != null && position != -1;
        if (manageState) {
            selector.setVisible(false, false);
        }
        this.positionSelectorCompat(position, sel);
        if (manageState) {
            Rect bounds = this.mSelectorRect;
            float x = bounds.exactCenterX();
            float y = bounds.exactCenterY();
            selector.setVisible(this.getVisibility() == 0, false);
            DrawableCompat.setHotspot(selector, x, y);
        }
    }

    private void positionSelectorCompat(int position, View sel) {
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        selectorRect.left -= this.mSelectionLeftPadding;
        selectorRect.top -= this.mSelectionTopPadding;
        selectorRect.right += this.mSelectionRightPadding;
        selectorRect.bottom += this.mSelectionBottomPadding;
        try {
            boolean isChildViewEnabled = this.mIsChildViewEnabled.getBoolean((Object)this);
            if (sel.isEnabled() != isChildViewEnabled) {
                this.mIsChildViewEnabled.set((Object)this, !isChildViewEnabled);
                if (position != -1) {
                    this.refreshDrawableState();
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void clearPressedItem() {
        this.mDrawsInPressedState = false;
        this.setPressed(false);
        this.drawableStateChanged();
        View motionView = this.getChildAt(this.mMotionPosition - this.getFirstVisiblePosition());
        if (motionView != null) {
            motionView.setPressed(false);
        }
        if (this.mClickAnimation != null) {
            this.mClickAnimation.cancel();
            this.mClickAnimation = null;
        }
    }

    private void setPressedItem(View child, int position, float x, float y) {
        View motionView;
        this.mDrawsInPressedState = true;
        if (Build.VERSION.SDK_INT >= 21) {
            this.drawableHotspotChanged(x, y);
        }
        if (!this.isPressed()) {
            this.setPressed(true);
        }
        this.layoutChildren();
        if (this.mMotionPosition != -1 && (motionView = this.getChildAt(this.mMotionPosition - this.getFirstVisiblePosition())) != null && motionView != child && motionView.isPressed()) {
            motionView.setPressed(false);
        }
        this.mMotionPosition = position;
        float childX = x - (float)child.getLeft();
        float childY = y - (float)child.getTop();
        if (Build.VERSION.SDK_INT >= 21) {
            child.drawableHotspotChanged(childX, childY);
        }
        if (!child.isPressed()) {
            child.setPressed(true);
        }
        this.positionSelectorLikeTouchCompat(position, child, x, y);
        this.setSelectorEnabled(false);
        this.refreshDrawableState();
    }

    private boolean touchModeDrawsInPressedStateCompat() {
        return this.mDrawsInPressedState;
    }

    private class ResolveHoverRunnable
    implements Runnable {
        private ResolveHoverRunnable() {
        }

        @Override
        public void run() {
            DropDownListView.this.mResolveHoverRunnable = null;
            DropDownListView.this.drawableStateChanged();
        }

        public void cancel() {
            DropDownListView.this.mResolveHoverRunnable = null;
            DropDownListView.this.removeCallbacks(this);
        }

        public void post() {
            DropDownListView.this.post(this);
        }
    }

    private static class GateKeeperDrawable
    extends DrawableWrapper {
        private boolean mEnabled = true;

        GateKeeperDrawable(Drawable drawable2) {
            super(drawable2);
        }

        void setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }

        @Override
        public boolean setState(int[] stateSet) {
            if (this.mEnabled) {
                return super.setState(stateSet);
            }
            return false;
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.mEnabled) {
                super.draw(canvas);
            }
        }

        @Override
        public void setHotspot(float x, float y) {
            if (this.mEnabled) {
                super.setHotspot(x, y);
            }
        }

        @Override
        public void setHotspotBounds(int left, int top, int right, int bottom) {
            if (this.mEnabled) {
                super.setHotspotBounds(left, top, right, bottom);
            }
        }

        @Override
        public boolean setVisible(boolean visible, boolean restart) {
            if (this.mEnabled) {
                return super.setVisible(visible, restart);
            }
            return false;
        }
    }
}

