/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tapsdk.antiaddiction.AntiAddictionCallback;
import com.tapsdk.antiaddiction.AntiAddictionKit;
import com.tapsdk.antiaddiction.AntiAddictionLoginCallback;
import com.tapsdk.antiaddiction.Callback;
import com.tapsdk.antiaddiction.Config;
import com.tapsdk.antiaddiction.IAntiAddiction;
import com.tapsdk.antiaddiction.Region;
import com.tapsdk.antiaddiction.config.AntiAddictionFunctionConfig;
import com.tapsdk.antiaddiction.entities.CheckPlayResult;
import com.tapsdk.antiaddiction.entities.StandAloneConfig;
import com.tapsdk.antiaddiction.entities.TwoTuple;
import com.tapsdk.antiaddiction.entities.UserInfo;
import com.tapsdk.antiaddiction.entities.request.PlayLogRequestParams;
import com.tapsdk.antiaddiction.entities.response.CheckPayResult;
import com.tapsdk.antiaddiction.entities.response.IdentifyState;
import com.tapsdk.antiaddiction.entities.response.SubmitPayResult;
import com.tapsdk.antiaddiction.enums.AccountLimitTipEnum;
import com.tapsdk.antiaddiction.models.IdentifyModel;
import com.tapsdk.antiaddiction.models.PaymentModel;
import com.tapsdk.antiaddiction.models.PlayLogModel;
import com.tapsdk.antiaddiction.models.ServerTimeModel;
import com.tapsdk.antiaddiction.models.TimingModel;
import com.tapsdk.antiaddiction.models.UserModel;
import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.reactor.Subscription;
import com.tapsdk.antiaddiction.reactor.functions.Action1;
import com.tapsdk.antiaddiction.reactor.functions.Func1;
import com.tapsdk.antiaddiction.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tapsdk.antiaddiction.reactor.schedulers.Schedulers;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddiction.skynet.NetServerErrorChecker;
import com.tapsdk.antiaddiction.skynet.Skynet;
import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tapsdk.antiaddiction.skynet.logging.HttpLoggingInterceptor;
import com.tapsdk.antiaddiction.skynet.okhttp3.HttpUrl;
import com.tapsdk.antiaddiction.skynet.okhttp3.Interceptor;
import com.tapsdk.antiaddiction.skynet.okhttp3.OkHttpClient;
import com.tapsdk.antiaddiction.skynet.okhttp3.Request;
import com.tapsdk.antiaddiction.skynet.retrofit2.Response;
import com.tapsdk.antiaddiction.skynet.retrofit2.Retrofit;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.gson.GsonConverterFactory;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddiction.utils.FileUtils;
import com.tapsdk.antiaddiction.utils.NetworkUtils;
import com.tapsdk.antiaddiction.utils.TimeUtil;
import com.tds.common.TapCommon;
import com.tds.common.entities.TapConfig;
import com.tds.common.net.exception.ServerException;
import com.tds.common.net.util.HostReplaceUtil;
import com.tds.gson.Gson;
import com.tds.gson.GsonBuilder;
import com.tds.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AntiAddictionImpl
implements IAntiAddiction {
    private boolean initialized = false;
    private Context applicationContext;
    private String gameIdentifier;
    private Config config;
    private AntiAddictionFunctionConfig antiAddictionFunctionConfig;
    private AntiAddictionCallback antiAddictionCallback;
    private final Handler mainLooperHandler = new Handler(Looper.getMainLooper());
    private boolean canPlay = false;
    private final UserModel userModel = new UserModel();
    private final IdentifyModel identifyModel = new IdentifyModel();
    private TimingModel timingModel;
    private final PaymentModel paymentModel = new PaymentModel();
    private volatile Subscription loginSubscription = null;
    private final boolean useMock = false;
    public static boolean serverDown = false;
    private String unityVersion = "";
    private final OkHttpClient staticResourcesHttpClient = new OkHttpClient();
    private final Gson gson = new GsonBuilder().create();
    public static Boolean enableStandAloneMode = null;
    static Set<String> dnotCheckUrlSet = new HashSet<String>();

    @Override
    public void setUnityVersion(String version) {
        this.unityVersion = version;
    }

    private static String getMockResponse(Context context, Interceptor.Chain chain) {
        HttpUrl httpUrl = chain.request().url();
        String path = httpUrl.url().toString();
        AntiAddictionLogger.d("getMockResponse " + path);
        if (path.contains("/configfile")) {
            return FileUtils.getJsonFromAssetsFile(context, "common_config.json");
        }
        if (path.contains("/real-name")) {
            HashSet<String> set = new HashSet<String>(Arrays.asList("9991", "9992", "9993"));
            for (String id : set) {
                if (!path.contains(id)) continue;
                return FileUtils.getJsonFromAssetsFile(context, "mock_realname_" + id + ".json");
            }
        }
        return "";
    }

    private boolean shouldCheckUrl(String url) {
        for (String part : dnotCheckUrlSet) {
            if (!url.contains(part)) continue;
            return false;
        }
        return true;
    }

    private Request buildAntiAddictionRequest(Interceptor.Chain chain, UserInfo currentUser) {
        String version = "3.16.5";
        String os = "Android";
        StringBuilder uaBuilder = new StringBuilder();
        uaBuilder.append("Version=").append(version);
        uaBuilder.append("&").append("Platform=").append(os);
        if (!TextUtils.isEmpty((CharSequence)this.unityVersion)) {
            uaBuilder.append("&").append("Unity-SDK-Version=").append(this.unityVersion);
        }
        return chain.request().newBuilder().header("Authorization", currentUser.accessToken).header("UA", uaBuilder.toString()).build();
    }

    private void initSkynet(Context context) {
        OkHttpClient.Builder antiAddictionOkhttpBuilder = new OkHttpClient.Builder();
        HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor();
        logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        Interceptor authInterceptor = new Interceptor(){

            @Override
            public com.tapsdk.antiaddiction.skynet.okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
                UserInfo currentUser = AntiAddictionImpl.this.userModel.getCurrentUser();
                if (null == currentUser || TextUtils.isEmpty((CharSequence)currentUser.accessToken)) {
                    return chain.proceed(chain.request());
                }
                Request request = AntiAddictionImpl.this.buildAntiAddictionRequest(chain, currentUser);
                com.tapsdk.antiaddiction.skynet.okhttp3.Response response = null;
                try {
                    response = chain.proceed(request);
                }
                catch (Exception e) {
                    AntiAddictionLogger.e("<-- HTTP FAILED: " + e);
                }
                HttpUrl httpUrl = chain.request().url();
                String path = httpUrl.url().toString();
                if (AntiAddictionImpl.this.shouldCheckUrl(path)) {
                    int retryTimes = 3;
                    while (--retryTimes > 0 && (response == null && NetworkUtils.isNetworkAvailable(AntiAddictionImpl.this.applicationContext) || response != null && response.code() >= 500)) {
                        Request newRequest = AntiAddictionImpl.this.buildAntiAddictionRequest(chain, currentUser);
                        try {
                            response = chain.proceed(newRequest);
                        }
                        catch (Exception e) {
                            AntiAddictionLogger.e("<-- HTTP FAILED: " + e);
                        }
                    }
                    if (!serverDown) {
                        boolean bl = serverDown = retryTimes == 0 && response == null && NetworkUtils.isNetworkAvailable(AntiAddictionImpl.this.applicationContext) || response != null && response.code() >= 500;
                    }
                    if (serverDown && retryTimes == 0) {
                        throw new AntiServerException(500, "Server down", 500);
                    }
                }
                return response;
            }
        };
        antiAddictionOkhttpBuilder.addInterceptor(authInterceptor);
        antiAddictionOkhttpBuilder.addInterceptor(logInterceptor);
        String antiAddictionServerUrl = HostReplaceUtil.getInstance().getReplacedHost("https://tds-tapsdk.cn.tapapis.com");
        String identityVerifiedServerUrl = HostReplaceUtil.getInstance().getReplacedHost("https://tds-tapsdk.cn.tapapis.com");
        Retrofit antiAddictionRetrofit = new Retrofit.Builder().baseUrl(antiAddictionServerUrl).client(antiAddictionOkhttpBuilder.build()).addConverterFactory(GsonConverterFactory.create(Collections.singletonList(new NetServerErrorChecker()))).addCallAdapterFactory(RxJavaCallAdapterFactory.create()).build();
        Skynet.getInstance().registerRetrofit(Skynet.RETROFIT_FOR_ANTI_ADDICTION, antiAddictionRetrofit);
        OkHttpClient.Builder identifyOkhttpBuilder = new OkHttpClient.Builder();
        Interceptor identifyRetryInterceptor = new Interceptor(){

            @Override
            public com.tapsdk.antiaddiction.skynet.okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                com.tapsdk.antiaddiction.skynet.okhttp3.Response response = null;
                try {
                    response = chain.proceed(request);
                }
                catch (Exception e) {
                    AntiAddictionLogger.e("<-- HTTP FAILED: " + e);
                }
                HttpUrl httpUrl = chain.request().url();
                String path = httpUrl.url().toString();
                if (AntiAddictionImpl.this.shouldCheckUrl(path)) {
                    int retryTimes = 3;
                    while (--retryTimes > 0 && (response == null && NetworkUtils.isNetworkAvailable(AntiAddictionImpl.this.applicationContext) || response != null && response.code() >= 500)) {
                        Request newRequest = request.newBuilder().build();
                        try {
                            response = chain.proceed(newRequest);
                        }
                        catch (Exception e) {
                            AntiAddictionLogger.e(e.toString());
                        }
                    }
                    if (!serverDown) {
                        boolean bl = serverDown = retryTimes == 0 && response == null && NetworkUtils.isNetworkAvailable(AntiAddictionImpl.this.applicationContext) || response != null && response.code() >= 500;
                    }
                    if (serverDown && retryTimes == 0) {
                        throw new AntiServerException(500, "Server down", 500);
                    }
                }
                return response;
            }
        };
        identifyOkhttpBuilder.addInterceptor(identifyRetryInterceptor);
        identifyOkhttpBuilder.addInterceptor(logInterceptor);
        Retrofit identifyRetrofit = new Retrofit.Builder().baseUrl(identityVerifiedServerUrl).client(identifyOkhttpBuilder.build()).addConverterFactory(GsonConverterFactory.create(Collections.singletonList(new NetServerErrorChecker()))).addCallAdapterFactory(RxJavaCallAdapterFactory.create()).build();
        Skynet.getInstance().registerRetrofit(Skynet.RETROFIT_FOR_IDENTIFY, identifyRetrofit);
    }

    @Override
    public synchronized void init(Context context, Config config, AntiAddictionCallback callback) {
        if (this.initialized) {
            return;
        }
        TapConfig tapConfig = new TapConfig.Builder().withClientId(config.clientId).withRegionType(config.region == Region.China ? 0 : 1).build();
        TapCommon.init((TapConfig)tapConfig);
        AntiAddictionFunctionConfig antiAddictionFunctionConfig = new AntiAddictionFunctionConfig.Builder().showSwitchAccount(config.showSwitchAccount).build();
        this.initCommonParams(context, config.clientId, antiAddictionFunctionConfig, callback);
        this.config = config;
        this.initialized = true;
    }

    @Override
    public synchronized void init(Context context, String gameIdentifier, AntiAddictionFunctionConfig antiAddictionFunctionConfig, AntiAddictionCallback antiAddictionCallback) {
        if (this.initialized) {
            return;
        }
        TapConfig tapConfig = new TapConfig.Builder().withClientId(gameIdentifier).withRegionType(0).build();
        TapCommon.init((TapConfig)tapConfig);
        this.initCommonParams(context, gameIdentifier, antiAddictionFunctionConfig, antiAddictionCallback);
        this.initialized = true;
    }

    private void initCommonParams(Context context, String gameIdentifier, AntiAddictionFunctionConfig addictionFunctionConfig, AntiAddictionCallback antiAddictionCallback) {
        this.applicationContext = context.getApplicationContext();
        this.gameIdentifier = gameIdentifier;
        this.antiAddictionFunctionConfig = addictionFunctionConfig;
        this.antiAddictionCallback = antiAddictionCallback;
        this.timingModel = new TimingModel(this.userModel, this.applicationContext, gameIdentifier, new TimingModel.TimingMessageListener(){

            @Override
            public void onMessage(int type, Map<String, Object> extras) {
                AntiAddictionImpl.this.notifyAntiAddictionMessage(type, extras);
                AntiAddictionImpl.this.canPlay = false;
            }
        });
        this.initSkynet(context);
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    private Observable<IdentifyState> identifyStateObservable(String userIdentifier, final String accessToken, final int ageLimit) {
        if (accessToken != null && !accessToken.isEmpty()) {
            return Observable.create(new Observable.OnSubscribe<IdentifyState>(){

                @Override
                public void call(Subscriber<? super IdentifyState> subscriber) {
                    IdentifyState identifyState = new IdentifyState();
                    identifyState.identifyState = 0;
                    identifyState.ageLimit = ageLimit;
                    identifyState.antiAddictionToken = accessToken;
                    subscriber.onNext(identifyState);
                    subscriber.onCompleted();
                }
            });
        }
        return this.identifyModel.inquireIdentifyState(this.gameIdentifier, userIdentifier);
    }

    private TwoTuple<Boolean, CheckPlayResult> localCheckPlayable(UserInfo currentUser) {
        AntiAddictionLogger.d("check sync Local play time");
        try {
            CheckPlayResult result = this.timingModel.syncLocalPlayLog();
            this.userModel.getCurrentUser().resetRemainTime(result.remainTime);
            AntiAddictionLogger.d("player left time:" + result.remainTime);
            if (currentUser.ageLimit == 18) {
                AntiAddictionLogger.d("player's type is adult");
                return TwoTuple.create(false, null);
            }
            AntiAddictionLogger.d("player's type is others");
            return TwoTuple.create(true, result);
        }
        catch (Exception e) {
            AntiAddictionLogger.e(e.toString());
            return TwoTuple.create(false, null);
        }
    }

    @Override
    public boolean isStandalone() {
        return (enableStandAloneMode == null || enableStandAloneMode != false) && serverDown;
    }

    @Override
    public void login(final String userIdentifier, final String accessToken, final int ageLimit, final AntiAddictionLoginCallback loginCallback) {
        if (this.loginSubscription != null && !this.loginSubscription.isUnsubscribed()) {
            AntiAddictionLogger.w("login in progress, call it later");
            return;
        }
        if (!"standalone_anti_addiction_token".equals(accessToken)) {
            AntiAddictionSettings.getInstance().cacheUserInfo(this.applicationContext, userIdentifier, accessToken, ageLimit);
        }
        this.logoutWithNoNotification();
        this.loginSubscription = this.identifyStateObservable(userIdentifier, accessToken, ageLimit).map(new Func1<IdentifyState, IdentifyState>(){

            @Override
            public IdentifyState call(IdentifyState identifyState) {
                AntiAddictionLogger.d("fetch identificationInfo");
                TwoTuple<String, Integer> cacheUserInfo = AntiAddictionSettings.getInstance().getCachedUserInfo(AntiAddictionImpl.this.applicationContext, userIdentifier);
                if (cacheUserInfo == null || "standalone_anti_addiction_token".equals(cacheUserInfo.firstParam)) {
                    AntiAddictionSettings.getInstance().cacheUserInfo(AntiAddictionImpl.this.applicationContext, userIdentifier, accessToken, ageLimit);
                }
                AntiAddictionImpl.this.userModel.setIdentifyState(identifyState);
                return identifyState;
            }
        }).map(new Func1<IdentifyState, UserInfo>(){

            @Override
            public UserInfo call(IdentifyState identifyState) {
                UserInfo userInfo = new UserInfo();
                userInfo.accessToken = identifyState.antiAddictionToken;
                userInfo.userId = userIdentifier;
                userInfo.ageLimit = identifyState.ageLimit;
                userInfo.clientId = AntiAddictionImpl.this.gameIdentifier;
                return userInfo;
            }
        }).map(new Func1<UserInfo, TwoTuple<Boolean, CheckPlayResult>>(){

            @Override
            public TwoTuple<Boolean, CheckPlayResult> call(UserInfo userInfo) {
                AntiAddictionLogger.d("check user state");
                AntiAddictionImpl.this.userModel.setCurrentUser(userInfo);
                Context context = AntiAddictionImpl.this.applicationContext.getApplicationContext();
                long serverTimeInSecond = ServerTimeModel.getServerTimeSync();
                AntiAddictionLogger.d("------sync server time------");
                if (serverTimeInSecond == -1L) {
                    AntiAddictionLogger.d("fetch server time fail");
                    serverTimeInSecond = System.currentTimeMillis() / 1000L;
                } else {
                    AntiAddictionLogger.d("fetch server time success:" + serverTimeInSecond);
                }
                AntiAddictionImpl.this.timingModel.setRecentServerTimeInSecond(serverTimeInSecond);
                AntiAddictionLogger.d("------get player left time------");
                PlayLogRequestParams playLogRequestParams = PlayLogModel.getPlayLog(context, userInfo, AntiAddictionImpl.this.gameIdentifier, serverTimeInSecond, serverTimeInSecond, serverTimeInSecond, serverTimeInSecond, serverTimeInSecond);
                Response<CheckPlayResult> response = PlayLogModel.checkUserStateSync(playLogRequestParams, !AntiAddictionImpl.this.isStandalone() && AntiAddictionSettings.getInstance().uploadUserAction(), userInfo.clientId, userInfo.userId);
                UserInfo currentUser = AntiAddictionImpl.this.userModel.getCurrentUser();
                if (response.code() == 200) {
                    AntiAddictionImpl.this.userModel.getCurrentUser().resetRemainTime(response.body().remainTime);
                    AntiAddictionSettings.getInstance().clearHistoricalData(context, ((AntiAddictionImpl)AntiAddictionImpl.this).userModel.getCurrentUser().userId);
                    AntiAddictionLogger.d("player left time:" + response.body().remainTime);
                    if (currentUser.ageLimit == 18) {
                        AntiAddictionLogger.d("player's type is adult");
                        return TwoTuple.create(false, null);
                    }
                    AntiAddictionLogger.d("player's type is others");
                    return TwoTuple.create(true, response.body());
                }
                if (response.code() == 401) {
                    AntiAddictionLogger.d("player's token is expired");
                    AntiAddictionKit.logout();
                    throw new RuntimeException((Throwable)new ServerException(401, "token expired", ""));
                }
                if (response.code() >= 500) {
                    return AntiAddictionImpl.this.localCheckPlayable(currentUser);
                }
                return AntiAddictionImpl.this.localCheckPlayable(currentUser);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<TwoTuple<Boolean, CheckPlayResult>>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                AntiAddictionLogger.e("login error");
                try {
                    if (e instanceof RuntimeException && e.getCause() != null && e.getCause() instanceof ServerException) {
                        ServerException serverException = (ServerException)e.getCause();
                        if (serverException.statusCode == 401) {
                            return;
                        }
                    }
                }
                catch (Exception serverException) {
                    // empty catch block
                }
                UserInfo userInfo = AntiAddictionImpl.this.userModel.getCurrentUser();
                if (userInfo != null && userInfo.ageLimit == 18) {
                    AntiAddictionImpl.this.notifyAntiAddictionMessage(500, null);
                } else {
                    loginCallback.onError(e);
                }
            }

            @Override
            public void onNext(TwoTuple<Boolean, CheckPlayResult> result) {
                UserInfo currentUser = AntiAddictionImpl.this.userModel.getCurrentUser();
                if (currentUser == null) {
                    AntiAddictionImpl.this.notifyAntiAddictionMessage(500, null);
                    return;
                }
                if (((Boolean)result.firstParam).booleanValue()) {
                    if (currentUser.ageLimit < 0) {
                        AntiAddictionImpl.this.processGuest((CheckPlayResult)result.secondParam, currentUser);
                    } else {
                        AntiAddictionImpl.this.processNonage((CheckPlayResult)result.secondParam);
                    }
                } else {
                    AntiAddictionImpl.this.notifyAntiAddictionMessage(500, null);
                }
                loginCallback.onSuccess();
            }
        });
    }

    private void processGuest(CheckPlayResult result, UserInfo userInfo) {
        TwoTuple<String, String> tipContent;
        AccountLimitTipEnum limitTipEnum;
        AntiAddictionLogger.d("processGuest:" + userInfo.userId);
        AntiAddictionSettings settings = AntiAddictionSettings.getInstance();
        int strictType = 0;
        if (result.remainTime == 0) {
            limitTipEnum = AccountLimitTipEnum.STATE_ENTER_LIMIT;
            if (result.restrictType == 1) {
                tipContent = settings.getPromptInfo(userInfo.ageLimit, 10);
                if (tipContent == null) {
                    tipContent = settings.getPromptInfo(userInfo.ageLimit, 9);
                }
            } else {
                tipContent = settings.getPromptInfo(userInfo.ageLimit, 9);
            }
            strictType = result.restrictType;
            if (this.antiAddictionFunctionConfig.onLineTimeLimitEnabled()) {
                int type = strictType == 1 ? 1030 : 1050;
                this.notifyAntiAddictionMessage(type, AntiAddictionSettings.getInstance().generateAlertMessage((String)tipContent.firstParam, TimeUtil.getRestTime((String)tipContent.secondParam, result.remainTime), AccountLimitTipEnum.STATE_ENTER_LIMIT, strictType));
            } else {
                this.notifyAntiAddictionMessage(500, null);
            }
        } else if (result.costTime == 0) {
            limitTipEnum = AccountLimitTipEnum.STATE_ENTER_NO_LIMIT;
            tipContent = settings.getPromptInfo(userInfo.ageLimit, 7);
            this.notifyAntiAddictionMessage(500, null);
        } else {
            limitTipEnum = AccountLimitTipEnum.STATE_ENTER_NO_LIMIT;
            tipContent = settings.getPromptInfo(userInfo.ageLimit, 8);
            this.notifyAntiAddictionMessage(500, null);
        }
        String description = TimeUtil.getRestTime((String)tipContent.secondParam, result.remainTime);
        this.notifyAntiAddictionMessage(1095, AntiAddictionSettings.getInstance().generateAlertMessage((String)tipContent.firstParam, description, limitTipEnum, strictType));
    }

    private void processNonage(CheckPlayResult result) {
        if (result.restrictType != 0) {
            AccountLimitTipEnum limitTipEnum;
            boolean loginSuccess = false;
            if (result.restrictType == 1) {
                if (result.remainTime <= 0) {
                    limitTipEnum = AccountLimitTipEnum.STATE_CHILD_ENTER_STRICT;
                    this.notifyAntiAddictionMessage(1030, AntiAddictionSettings.getInstance().generateAlertMessage(result.title, result.description, limitTipEnum, result.restrictType));
                } else {
                    limitTipEnum = AccountLimitTipEnum.STATE_CHILD_ENTER_NO_LIMIT;
                    loginSuccess = true;
                    this.notifyAntiAddictionMessage(500, null);
                }
            } else if (result.remainTime <= 0) {
                limitTipEnum = AccountLimitTipEnum.STATE_CHILD_ENTER_STRICT;
                this.notifyAntiAddictionMessage(1050, AntiAddictionSettings.getInstance().generateAlertMessage(result.title, result.description, limitTipEnum, result.restrictType));
            } else {
                limitTipEnum = AccountLimitTipEnum.STATE_CHILD_ENTER_NO_LIMIT;
                loginSuccess = true;
                this.notifyAntiAddictionMessage(500, null);
            }
            if (loginSuccess) {
                this.notifyAntiAddictionMessage(1095, AntiAddictionSettings.getInstance().generateAlertMessage(result.title, result.description, limitTipEnum, result.restrictType));
            }
        } else {
            this.notifyAntiAddictionMessage(500, null);
        }
    }

    public void notifyAntiAddictionMessage(final int type, final Map<String, Object> extras) {
        switch (type) {
            case 500: {
                this.canPlay = true;
                break;
            }
            case 1000: 
            case 1030: 
            case 1050: {
                this.canPlay = false;
                break;
            }
            case 9001: {
                this.logout();
                break;
            }
        }
        this.mainLooperHandler.post(new Runnable(){

            @Override
            public void run() {
                AntiAddictionImpl.this.antiAddictionCallback.onCallback(type, extras);
            }
        });
    }

    @Override
    public void logout() {
        serverDown = false;
        this.notifyAntiAddictionMessage(1000, null);
        this.userModel.logout();
        this.canPlay = false;
    }

    private void logoutWithNoNotification() {
        this.userModel.logout();
        this.canPlay = false;
    }

    @Override
    public void enterGame() {
        if (!this.antiAddictionFunctionConfig.onLineTimeLimitEnabled() || this.userModel.getCurrentUser() == null || !this.initialized || !this.canPlay || !AntiAddictionSettings.getInstance().uploadUserAction() && this.userModel.getCurrentUser().ageLimit == 18 || this.timingModel.inTiming) {
            return;
        }
        this.timingModel.bind();
    }

    @Override
    public void leaveGame() {
        if (this.userModel.getCurrentUser() == null || !this.initialized || !this.canPlay) {
            return;
        }
        this.timingModel.unbind();
    }

    @Override
    public void checkPayLimit(long amount, final Callback<CheckPayResult> callback) {
        if (!this.antiAddictionFunctionConfig.paymentLimitEnabled() || this.userModel.getCurrentUser() == null || !this.initialized) {
            return;
        }
        if ("standalone_anti_addiction_token".equals(this.currentToken())) {
            callback.onError(new Throwable("\u5f53\u524d\u670d\u52a1\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u652f\u4ed8\u3002"));
            return;
        }
        this.paymentModel.checkPay(amount, this.gameIdentifier, this.userModel.getCurrentUser().clientId, this.userModel.getCurrentUser().userId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Action1<CheckPayResult>(){

            @Override
            public void call(CheckPayResult checkPayResult) {
                callback.onSuccess(checkPayResult);
            }
        }, new Action1<Throwable>(){

            @Override
            public void call(Throwable throwable) {
                if (throwable instanceof AntiServerException && ((AntiServerException)throwable).code == 16) {
                    AntiAddictionImpl.this.notifyAntiAddictionMessage(9001, null);
                }
                callback.onError(throwable);
            }
        });
    }

    @Override
    public void submitPayResult(long amount, final Callback<SubmitPayResult> callback) {
        if (!this.antiAddictionFunctionConfig.paymentLimitEnabled() || this.userModel.getCurrentUser() == null || !this.initialized) {
            return;
        }
        if ("standalone_anti_addiction_token".equals(this.currentToken())) {
            callback.onError(new Exception("\u5f53\u524d\u670d\u52a1\u5f02\u5e38\uff0c\u65e0\u6cd5\u63d0\u4ea4\u652f\u4ed8\u7ed3\u679c"));
            return;
        }
        this.paymentModel.paySuccess(amount, this.gameIdentifier, this.userModel.getCurrentUser().clientId, this.userModel.getCurrentUser().userId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Action1<SubmitPayResult>(){

            @Override
            public void call(SubmitPayResult submitPayResult) {
                callback.onSuccess(submitPayResult);
            }
        }, new Action1<Throwable>(){

            @Override
            public void call(Throwable throwable) {
                callback.onError(throwable);
            }
        });
    }

    @Override
    public void authIdentityManually(String clientId, String userId, String name, String idCard, final Callback<IdentifyState> callback) {
        this.identifyModel.identifyUserManually(clientId, userId, name, idCard).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<IdentifyState>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                callback.onError(e);
            }

            @Override
            public void onNext(IdentifyState identifyState) {
                callback.onSuccess(identifyState);
            }
        });
    }

    @Override
    public void authIdentityFromTapTap(String clientId, String userId, String code, int fromTapTap, final Callback<IdentifyState> callback) {
        this.identifyModel.identifyUserFromTapTap(clientId, userId, code, fromTapTap).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<IdentifyState>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                callback.onError(e);
            }

            @Override
            public void onNext(IdentifyState identifyState) {
                callback.onSuccess(identifyState);
            }
        });
    }

    @Override
    public void fetchUserIdentifyState(String clientId, String userId, final Callback<IdentifyState> callback) {
        this.identifyModel.inquireIdentifyState(clientId, userId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<IdentifyState>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                callback.onError(e);
            }

            @Override
            public void onNext(IdentifyState identifyState) {
                callback.onSuccess(identifyState);
            }
        });
    }

    public Observable<Boolean> checkStandaloneSwitchAsync() {
        return Observable.create(new Observable.OnSubscribe<Boolean>(){

            @Override
            public void call(Subscriber<? super Boolean> subscriber) {
                subscriber.onNext(AntiAddictionImpl.this.checkStandAloneSwitchSync());
                subscriber.onCompleted();
            }
        });
    }

    public Boolean checkStandAloneSwitchSync() {
        AntiAddictionLogger.d("Fetch standAlone-switch start");
        if (enableStandAloneMode != null) {
            return enableStandAloneMode;
        }
        try {
            Request request = new Request.Builder().url("https://tds-public-config-sh.oss-cn-shanghai.aliyuncs.com/antiaddiction-settings.json").build();
            com.tapsdk.antiaddiction.skynet.okhttp3.Response response = this.staticResourcesHttpClient.newCall(request).execute();
            if (response.code() == 200 || response.code() == 201) {
                StandAloneConfig config = (StandAloneConfig)this.gson.fromJson(response.body().string(), new TypeToken<StandAloneConfig>(){}.getType());
                enableStandAloneMode = config.standAloneMode == 1;
                return enableStandAloneMode;
            }
        }
        catch (Exception e) {
            AntiAddictionLogger.d("Fetch standAlone-switch fail");
        }
        return true;
    }

    @Override
    public void checkStandaloneCacheAndFetchUserIdentifyState(final String clientId, final String userId, final Callback<IdentifyState> callback) {
        Observable.create(new Observable.OnSubscribe<String>(){

            @Override
            public void call(Subscriber<? super String> subscriber) {
                String authInputInfo = AntiAddictionSettings.getInstance().getAuthInputInfo(AntiAddictionImpl.this.applicationContext, userId);
                subscriber.onNext(authInputInfo);
                subscriber.onCompleted();
            }
        }).flatMap(new Func1<String, Observable<IdentifyState>>(){

            @Override
            public Observable<IdentifyState> call(String cacheData) {
                if (!TextUtils.isEmpty((CharSequence)cacheData)) {
                    return AntiAddictionImpl.this.identifyModel.identifyUserByCacheData(clientId, userId, cacheData);
                }
                return AntiAddictionImpl.this.identifyModel.inquireIdentifyState(clientId, userId);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<IdentifyState>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(final Throwable re) {
                if (re instanceof AntiServerException) {
                    int statusCode = ((AntiServerException)re).statusCode;
                    if (statusCode < 500 && statusCode != -1) {
                        AntiAddictionSettings.getInstance().clearAuthInputInfo(AntiAddictionImpl.this.applicationContext, userId);
                    }
                    AntiAddictionImpl.this.checkStandaloneSwitchAsync().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<Boolean>(){

                        @Override
                        public void onCompleted() {
                        }

                        @Override
                        public void onError(Throwable e) {
                            AntiAddictionLogger.e("rootCause:" + re.toString() + "\ne:" + e.toString());
                            callback.onError(re);
                        }

                        @Override
                        public void onNext(Boolean startStandAloneMode) {
                            if (!AntiAddictionImpl.this.isStandalone()) {
                                callback.onError(new AntiServerException(1, "fetch real-name info fail && standalone switch closed", 500));
                                return;
                            }
                            TwoTuple<String, Integer> cachedUser = AntiAddictionSettings.getInstance().getCachedUserInfo(AntiAddictionImpl.this.applicationContext, userId);
                            IdentifyState identifyState = new IdentifyState();
                            if (cachedUser != null && !TextUtils.isEmpty((CharSequence)((CharSequence)cachedUser.firstParam)) && (Integer)cachedUser.secondParam >= 0) {
                                identifyState.antiAddictionToken = (String)cachedUser.firstParam;
                                identifyState.identifyState = 0;
                                identifyState.ageLimit = (Integer)cachedUser.secondParam;
                            } else {
                                identifyState.antiAddictionToken = "standalone_anti_addiction_token";
                                identifyState.identifyState = 2;
                                identifyState.hasAuthRecord = false;
                            }
                            callback.onSuccess(identifyState);
                        }
                    });
                } else {
                    callback.onError(re);
                }
            }

            @Override
            public void onNext(IdentifyState identifyState) {
                AntiAddictionSettings.getInstance().clearAuthInputInfo(AntiAddictionImpl.this.applicationContext, userId);
                callback.onSuccess(identifyState);
            }
        });
    }

    @Override
    public String currentToken() {
        UserInfo userInfo = this.userModel.getCurrentUser();
        if (userInfo != null) {
            return userInfo.accessToken;
        }
        return "";
    }

    @Override
    public int currentAgeLimit() {
        UserInfo userInfo = this.userModel.getCurrentUser();
        if (userInfo != null) {
            return userInfo.ageLimit;
        }
        return -1;
    }

    @Override
    public int currentUserRemainTime() {
        UserInfo userInfo = this.userModel.getCurrentUser();
        if (userInfo != null) {
            return userInfo.remainTime;
        }
        return 0;
    }

    @Override
    public boolean canPlay() {
        return this.canPlay;
    }

    @Override
    public void switchAccount() {
        this.notifyAntiAddictionMessage(1001, null);
    }

    @Override
    public boolean showSwitchAccount() {
        if (this.antiAddictionFunctionConfig == null) {
            return false;
        }
        return this.antiAddictionFunctionConfig.showSwitchButton;
    }

    @Override
    public void checkIfStartStandAloneMode(final Callback<Boolean> callback) {
        this.checkStandaloneSwitchAsync().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<Boolean>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                callback.onSuccess(serverDown);
            }

            @Override
            public void onNext(Boolean startStandAloneMode) {
                callback.onSuccess(startStandAloneMode != false && serverDown);
            }
        });
    }

    static {
        dnotCheckUrlSet.addAll(Arrays.asList("server-time", "configuration", "payable", "payments"));
    }
}

