/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.models;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tapsdk.antiaddiction.AntiAddictionKit;
import com.tapsdk.antiaddiction.entities.CheckPlayResult;
import com.tapsdk.antiaddiction.entities.ChildProtectedConfig;
import com.tapsdk.antiaddiction.entities.ThreeTuple;
import com.tapsdk.antiaddiction.entities.TwoTuple;
import com.tapsdk.antiaddiction.entities.UserInfo;
import com.tapsdk.antiaddiction.entities.request.PlayLogRequestParams;
import com.tapsdk.antiaddiction.enums.AccountLimitTipEnum;
import com.tapsdk.antiaddiction.models.PlayLogModel;
import com.tapsdk.antiaddiction.models.ServerTimeModel;
import com.tapsdk.antiaddiction.models.UserModel;
import com.tapsdk.antiaddiction.models.internal.TimingHandler;
import com.tapsdk.antiaddiction.reactor.functions.Action1;
import com.tapsdk.antiaddiction.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddiction.skynet.retrofit2.Response;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddiction.utils.TimeUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TimingModel {
    private final UserModel userModel;
    private final Context context;
    private final String game;
    private final Handler mainLooperHandler = new Handler(Looper.getMainLooper());
    private long lastProcessTimeInSecond = -1L;
    private long recentServerTimeInSecond = -1L;
    private boolean isCountDown1 = false;
    private boolean isCountDown2 = false;
    private int countDownRemainTime = 0;
    private int remainTime = 0;
    public boolean inTiming = false;
    private final TimingMessageListener timingMessageListener;
    private HandlerThread mHandlerThread = null;
    private TimingHandler mHandler = null;
    private final TimingHandler.InteractiveOperation interactiveOperation = new TimingHandler.InteractiveOperation(){

        @Override
        public void countTime() {
            if (TimingModel.this.userModel == null) {
                return;
            }
            if (TimingModel.this.recentServerTimeInSecond == -1L) {
                TimingModel.this.recentServerTimeInSecond = ServerTimeModel.getServerTimeSync();
            }
            try {
                CheckPlayResult result = TimingModel.this.syncTime();
                if (result.restrictType != 0) {
                    TimingModel.this.setTimerForPrompt(result);
                }
            }
            catch (Throwable e) {
                AntiAddictionLogger.printStackTrace(e);
            }
        }

        @Override
        public boolean countDown(String title, String description, int restrictType) {
            int localCountDownRemainTime = TimingModel.this.countDownRemainTime--;
            if (localCountDownRemainTime == 900 || localCountDownRemainTime <= 60) {
                Message msg;
                if (localCountDownRemainTime > 60) {
                    msg = TimingModel.this.mHandler.obtainMessage();
                    msg.what = 2;
                    TimingModel.this.mHandler.sendMessage(msg);
                } else {
                    int updateTime = localCountDownRemainTime;
                    int accum = 1;
                    while (updateTime > 10) {
                        Message msg2 = TimingModel.this.mHandler.obtainMessage();
                        msg2.what = 2;
                        TimingModel.this.mHandler.sendMessageDelayed(msg2, accum * 10 * 1000);
                        updateTime -= 10;
                        ++accum;
                    }
                }
                if (localCountDownRemainTime <= 60) {
                    msg = TimingModel.this.mHandler.obtainMessage();
                    msg.what = 4;
                    msg.obj = restrictType;
                    AntiAddictionLogger.d("remain time:" + TimingModel.this.remainTime);
                    AntiAddictionLogger.d("count down time:" + localCountDownRemainTime);
                    TimingModel.this.mHandler.sendMessageDelayed(msg, localCountDownRemainTime * 1000 + 800);
                }
                return true;
            }
            return false;
        }

        @Override
        public void updateServerTime() {
            try {
                TimingModel.this.syncTime();
            }
            catch (Throwable throwable) {
                AntiAddictionLogger.printStackTrace(throwable);
            }
        }

        @Override
        public void stopCountDownTimerAndUpdateServerTime() {
            try {
                TimingModel.this.syncTime();
            }
            catch (Throwable throwable) {
                AntiAddictionLogger.printStackTrace(throwable);
            }
            TimingModel.this.unbind();
        }

        @Override
        public void childTimeRunOut(final int strictType) throws Throwable {
            TwoTuple<String, String> tuple;
            CheckPlayResult result = TimingModel.this.syncTime();
            if (result.remainTime != 0) {
                AntiAddictionLogger.w("childTimeRunOut wrong ?:" + result.remainTime);
            }
            UserInfo userInfo = TimingModel.this.userModel.getCurrentUser().clone();
            if (strictType == 1) {
                tuple = AntiAddictionSettings.getInstance().getPromptInfo(userInfo.ageLimit, 5);
                if (TextUtils.isEmpty((CharSequence)((CharSequence)tuple.firstParam))) {
                    tuple = AntiAddictionSettings.getInstance().getPromptInfo(0, 5);
                }
            } else {
                tuple = AntiAddictionSettings.getInstance().getPromptInfo(userInfo.ageLimit, 6);
            }
            int costTime = TimeUtil.getAntiAddictionTime(userInfo.ageLimit, AntiAddictionSettings.getInstance().getCommonConfig().childProtectedConfig, TimingModel.this.recentServerTimeInSecond * 1000L);
            final String title = (String)tuple.firstParam;
            final String description = TimeUtil.getRestTime((String)tuple.secondParam, costTime);
            TimingModel.this.mainLooperHandler.post(new Runnable(){

                @Override
                public void run() {
                    int msgType = strictType == 2 ? 1050 : 1030;
                    TimingModel.this.timingMessageListener.onMessage(msgType, AntiAddictionSettings.getInstance().generateAlertMessage(title, description, AccountLimitTipEnum.STATE_COUNT_DOWN_POPUP, strictType));
                }
            });
            TimingModel.this.unbind();
        }

        @Override
        public void logout() {
            try {
                TimingModel.this.syncTime();
            }
            catch (Throwable throwable) {
                AntiAddictionLogger.printStackTrace(throwable);
            }
            TimingModel.this.unbind();
            TimingModel.this.userModel.logout();
        }
    };

    public TimingModel(UserModel userModel, Context context, String game, TimingMessageListener timingMessageListener) {
        this.userModel = userModel;
        this.context = context;
        this.game = game;
        this.timingMessageListener = timingMessageListener;
        this.initLoginStatusChangedListener();
    }

    private void initLoginStatusChangedListener() {
        this.userModel.getUserLoginStatusChangedObservable().observeOn(AndroidSchedulers.mainThread()).subscribe(new Action1<Boolean>(){

            @Override
            public void call(Boolean logged) {
                if (!logged.booleanValue()) {
                    TimingModel.this.unbind();
                }
            }
        }, new Action1<Throwable>(){

            @Override
            public void call(Throwable throwable) {
            }
        });
    }

    public void bind() {
        this.unbind();
        AntiAddictionLogger.d("bind");
        this.mainLooperHandler.post(new Runnable(){

            @Override
            public void run() {
                if (TimingModel.this.userModel == null || TimingModel.this.userModel.getCurrentUser() == null) {
                    return;
                }
                TimingModel.this.mHandlerThread = new HandlerThread("AntiAddictionMonitor", 10);
                TimingModel.this.mHandlerThread.start();
                TimingModel.this.mHandler = new TimingHandler(TimingModel.this.mHandlerThread.getLooper(), TimingModel.this.interactiveOperation);
                Message msg = TimingModel.this.mHandler.obtainMessage();
                msg.what = 0;
                TimingModel.this.mHandler.sendMessage(msg);
                TimingModel.this.inTiming = true;
            }
        });
    }

    public void unbind() {
        AntiAddictionLogger.d("unbind");
        this.mainLooperHandler.post(new Runnable(){

            @Override
            public void run() {
                TimingModel.this.reset();
                if (TimingModel.this.mHandlerThread != null) {
                    TimingModel.this.mHandlerThread.quit();
                    TimingModel.this.mHandlerThread = null;
                }
                if (TimingModel.this.mHandler != null) {
                    TimingModel.this.mHandler.removeCallbacksAndMessages(null);
                    TimingModel.this.mHandler = null;
                }
                TimingModel.this.inTiming = false;
            }
        });
    }

    public void setRecentServerTimeInSecond(long serverTimeInSeconds) {
        this.recentServerTimeInSecond = serverTimeInSeconds;
    }

    private Response<CheckPlayResult> sendGameTimeToServerSync() throws Throwable {
        long serverEndSeconds;
        long serverStartSeconds;
        long localEndSeconds;
        long localStartSeconds;
        if (this.userModel == null || this.userModel.getCurrentUser() == null) {
            throw new Exception("sendGameTimeToServerSync exception");
        }
        UserInfo userInfo = this.userModel.getCurrentUser().clone();
        AntiAddictionLogger.d("-------sendGameTimeToServerSync-------");
        long curTimeInSecond = SystemClock.elapsedRealtime() / 1000L;
        AntiAddictionLogger.d("elapsedRealTimeInSecond:" + curTimeInSecond + " lastProcessGameTimeInSeconds:" + this.lastProcessTimeInSecond);
        long diffInSeconds = 0L;
        if (this.lastProcessTimeInSecond == -1L) {
            localStartSeconds = this.recentServerTimeInSecond;
            localEndSeconds = this.recentServerTimeInSecond;
            serverStartSeconds = this.recentServerTimeInSecond;
            serverEndSeconds = this.recentServerTimeInSecond;
        } else {
            diffInSeconds = curTimeInSecond - this.lastProcessTimeInSecond;
            localStartSeconds = this.recentServerTimeInSecond;
            localEndSeconds = this.recentServerTimeInSecond + diffInSeconds;
            serverStartSeconds = this.recentServerTimeInSecond;
            serverEndSeconds = this.recentServerTimeInSecond + diffInSeconds;
        }
        PlayLogRequestParams playLogRequestParams = PlayLogModel.getPlayLog(this.context, userInfo, this.game, serverStartSeconds, serverEndSeconds, localStartSeconds, localEndSeconds, this.recentServerTimeInSecond);
        Response<CheckPlayResult> response = PlayLogModel.uploadPlayLogSync(playLogRequestParams, false, !AntiAddictionKit.isStandalone() && AntiAddictionSettings.getInstance().uploadUserAction() && AntiAddictionSettings.getInstance().uploadUserAction(), userInfo.clientId, userInfo.userId);
        if (response.code() == 200) {
            this.lastProcessTimeInSecond = curTimeInSecond;
            this.setRecentServerTimeInSecond(this.recentServerTimeInSecond + diffInSeconds);
        } else if (response.code() == 401) {
            this.timingMessageListener.onMessage(9001, null);
        }
        AntiAddictionLogger.d("after update elapsedRealtime:" + this.recentServerTimeInSecond);
        AntiAddictionLogger.d("after update serverTime:" + TimeUtil.getFullTime(this.recentServerTimeInSecond * 1000L));
        return response;
    }

    private CheckPlayResult syncTime() throws Throwable {
        if (this.userModel == null || this.userModel.getCurrentUser() == null) {
            throw new Exception("syncTime exception");
        }
        UserInfo userInfo = this.userModel.getCurrentUser();
        Response<CheckPlayResult> response = this.sendGameTimeToServerSync();
        CheckPlayResult result = response.body();
        if (AntiAddictionKit.isStandalone()) {
            result = this.handleLocalPlayLog(userInfo);
        } else if (result != null) {
            AntiAddictionSettings.getInstance().clearHistoricalData(this.context, userInfo.userId);
        } else {
            result = this.handleLocalPlayLog(userInfo);
        }
        this.remainTime = result.remainTime;
        AntiAddictionLogger.d("local left time:" + this.remainTime);
        this.userModel.getCurrentUser().resetRemainTime(this.remainTime);
        return result;
    }

    private void reset() {
        if (this.recentServerTimeInSecond != -1L && this.lastProcessTimeInSecond != -1L) {
            this.setRecentServerTimeInSecond(this.recentServerTimeInSecond + (SystemClock.elapsedRealtime() / 1000L - this.lastProcessTimeInSecond));
            AntiAddictionLogger.d("reset:" + TimeUtil.getFullTime(this.recentServerTimeInSecond * 1000L));
        }
        this.lastProcessTimeInSecond = -1L;
        this.isCountDown1 = false;
        this.isCountDown2 = false;
    }

    public CheckPlayResult syncLocalPlayLog() throws Exception {
        long serverEndSeconds;
        long serverStartSeconds;
        long localEndSeconds;
        long localStartSeconds;
        if (this.userModel == null || this.userModel.getCurrentUser() == null) {
            throw new Exception("sendGameTimeToServerSync exception");
        }
        UserInfo userInfo = this.userModel.getCurrentUser();
        AntiAddictionLogger.d("-------sendGameTimeToServerSync-------");
        long curTimeInSecond = SystemClock.elapsedRealtime() / 1000L;
        AntiAddictionLogger.d("elapsedRealTimeInSecond:" + curTimeInSecond + " lastProcessGameTimeInSeconds:" + this.lastProcessTimeInSecond);
        long diffInSeconds = 0L;
        if (this.lastProcessTimeInSecond == -1L) {
            localStartSeconds = this.recentServerTimeInSecond;
            localEndSeconds = this.recentServerTimeInSecond;
            serverStartSeconds = this.recentServerTimeInSecond;
            serverEndSeconds = this.recentServerTimeInSecond;
        } else {
            diffInSeconds = curTimeInSecond - this.lastProcessTimeInSecond;
            localStartSeconds = this.recentServerTimeInSecond;
            localEndSeconds = this.recentServerTimeInSecond + diffInSeconds;
            serverStartSeconds = this.recentServerTimeInSecond;
            serverEndSeconds = this.recentServerTimeInSecond + diffInSeconds;
        }
        PlayLogRequestParams playLogRequestParams = PlayLogModel.getPlayLog(this.context, userInfo, this.game, serverStartSeconds, serverEndSeconds, localStartSeconds, localEndSeconds, this.recentServerTimeInSecond);
        ChildProtectedConfig config = AntiAddictionSettings.getInstance().getCommonConfig().childProtectedConfig;
        if (userInfo.ageLimit == 18) {
            this.remainTime = Integer.MAX_VALUE;
        } else {
            int n = this.remainTime = TimeUtil.isHoliday(new Date().getTime()) ? config.childHolidayTime : config.childCommonTime;
        }
        if (playLogRequestParams.playLogs != null && playLogRequestParams.playLogs.localTimes != null) {
            for (int i = 0; i < playLogRequestParams.playLogs.localTimes.size(); ++i) {
                List<Long> intervalList = playLogRequestParams.playLogs.localTimes.get(i);
                this.remainTime = (int)((long)this.remainTime - (intervalList.get(1) - intervalList.get(0) > 0L ? intervalList.get(1) - intervalList.get(0) : 0L));
            }
        }
        this.userModel.getCurrentUser().resetRemainTime(this.remainTime);
        return this.handleLocalPlayLog(userInfo);
    }

    private CheckPlayResult handleLocalPlayLog(UserInfo userInfo) {
        long serverEndSeconds;
        long serverStartSeconds;
        long localEndSeconds;
        long localStartSeconds;
        long curTimeInSecond = SystemClock.elapsedRealtime() / 1000L;
        if (this.lastProcessTimeInSecond == -1L) {
            localStartSeconds = this.recentServerTimeInSecond;
            localEndSeconds = this.recentServerTimeInSecond;
            serverStartSeconds = this.recentServerTimeInSecond;
            serverEndSeconds = this.recentServerTimeInSecond;
        } else {
            long diffInSecond = curTimeInSecond - this.lastProcessTimeInSecond;
            AntiAddictionLogger.d("diffInSecond:" + diffInSecond);
            localStartSeconds = this.recentServerTimeInSecond;
            localEndSeconds = this.recentServerTimeInSecond + diffInSecond;
            serverStartSeconds = this.recentServerTimeInSecond;
            serverEndSeconds = this.recentServerTimeInSecond + diffInSecond;
        }
        this.saveLostTimestamp(userInfo, serverStartSeconds, serverEndSeconds, localStartSeconds, localEndSeconds);
        this.lastProcessTimeInSecond = curTimeInSecond;
        this.setRecentServerTimeInSecond(serverEndSeconds);
        if (this.userModel != null) {
            this.userModel.getCurrentUser().updateRemainTime((int)(localEndSeconds - localStartSeconds));
        }
        return this.generateLocalPlayLogResult(userInfo);
    }

    private CheckPlayResult generateLocalPlayLogResult(UserInfo userInfo) {
        CheckPlayResult result = new CheckPlayResult();
        if (userInfo.ageLimit == 18) {
            result.restrictType = 0;
            return result;
        }
        AntiAddictionLogger.d("generateLocalPlayLogResult [serverTime]:" + TimeUtil.getFullTime(this.recentServerTimeInSecond * 1000L));
        ChildProtectedConfig config = AntiAddictionSettings.getInstance().getCommonConfig().childProtectedConfig;
        int toNightTime = TimeUtil.getTimeToNightStrict(config.nightStrictStart, config.nightStrictEnd, this.recentServerTimeInSecond * 1000L);
        int toLimitTime = userInfo.remainTime;
        int remainTime = Math.min(Math.max(toLimitTime, 0), Math.max(toNightTime, 0));
        AntiAddictionLogger.d("toNightTime:" + toNightTime + " toLimitTime:" + toLimitTime);
        if (this.userModel != null) {
            this.userModel.getCurrentUser().resetRemainTime(remainTime);
        }
        result.restrictType = toNightTime <= toLimitTime ? 1 : 2;
        AntiAddictionLogger.d("restrict type:" + result.restrictType);
        result.remainTime = remainTime;
        if (remainTime <= 0) {
            int type = userInfo.ageLimit < 0 ? 6 : (toNightTime <= 0 ? 5 : 6);
            int costTime = userInfo.ageLimit < 0 ? config.noIdentifyTime : (TimeUtil.isHoliday(new Date().getTime()) ? config.childHolidayTime : config.childCommonTime);
            TwoTuple<String, String> tipInfo = AntiAddictionSettings.getInstance().getPromptInfo(userInfo.ageLimit, type);
            result.title = (String)tipInfo.firstParam;
            result.description = TimeUtil.getRestTime((String)tipInfo.secondParam, costTime);
        } else {
            int type = 7;
            TwoTuple<String, String> tipInfo = AntiAddictionSettings.getInstance().getPromptInfo(userInfo.ageLimit, type);
            result.title = (String)tipInfo.firstParam;
            result.description = TimeUtil.getRestTime((String)tipInfo.secondParam, remainTime);
        }
        return result;
    }

    private void saveLostTimestamp(UserInfo userInfo, long start, long end, long localStart, long localEnd) {
        AntiAddictionSettings.getInstance().saveLatestData(this.context, userInfo.userId, start, end, localStart, localEnd);
    }

    private void setTimerForPrompt(CheckPlayResult result) {
        int seconds = result.remainTime;
        if (seconds >= 900 && seconds <= 1020) {
            this.countDownRemainTime = seconds;
            if (!this.isCountDown1) {
                Message msg = this.mHandler.obtainMessage();
                msg.what = 1;
                msg.obj = ThreeTuple.create(result.title, result.description, result.restrictType);
                this.mHandler.sendMessage(msg);
                this.isCountDown1 = true;
            }
        } else if (seconds >= 0 && seconds <= 180) {
            this.countDownRemainTime = seconds;
            if (!this.isCountDown2 && this.mHandler != null) {
                Message msg = this.mHandler.obtainMessage();
                msg.what = 1;
                msg.obj = ThreeTuple.create(result.title, result.description, result.restrictType);
                this.mHandler.sendMessage(msg);
                this.isCountDown2 = true;
            }
        }
    }

    public static interface TimingMessageListener {
        public void onMessage(int var1, Map<String, Object> var2);
    }
}

