/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.gson;

import com.tapsdk.antiaddiction.skynet.okhttp3.ResponseBody;
import com.tapsdk.antiaddiction.skynet.retrofit2.Converter;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.RespInterceptor;
import com.tds.gson.Gson;
import com.tds.gson.JsonIOException;
import com.tds.gson.JsonObject;
import com.tds.gson.TypeAdapter;
import com.tds.gson.stream.JsonReader;
import com.tds.gson.stream.JsonToken;
import java.io.IOException;
import java.util.List;

final class GsonResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private final Gson gson;
    private final TypeAdapter<T> adapter;
    private final List<? extends RespInterceptor> interceptorList;

    GsonResponseBodyConverter(Gson gson, TypeAdapter<T> adapter, List<? extends RespInterceptor> interceptors) {
        this.gson = gson;
        this.adapter = adapter;
        this.interceptorList = interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public T convert(ResponseBody value) throws IOException {
        JsonReader jsonReader = this.gson.newJsonReader(value.charStream());
        try {
            JsonObject jsonElement = (JsonObject)this.gson.fromJson(jsonReader, JsonObject.class);
            for (RespInterceptor object : this.interceptorList) {
                object.invoke(jsonElement, -1);
            }
            Object result = jsonElement.has("data") ? this.adapter.fromJsonTree(jsonElement.get("data")) : this.adapter.read(jsonReader);
            if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            Object object = result;
            return (T)object;
        }
        finally {
            value.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T convert(ResponseBody value, int code) throws IOException {
        JsonReader jsonReader = this.gson.newJsonReader(value.charStream());
        try {
            JsonObject jsonElement = (JsonObject)this.gson.fromJson(jsonReader, JsonObject.class);
            for (RespInterceptor object : this.interceptorList) {
                object.invoke(jsonElement, code);
            }
            Object result = jsonElement.has("data") ? this.adapter.fromJsonTree(jsonElement.get("data")) : this.adapter.read(jsonReader);
            if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            Object object = result;
            return (T)object;
        }
        finally {
            value.close();
        }
    }
}

