/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava;

import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.skynet.retrofit2.Call;
import com.tapsdk.antiaddiction.skynet.retrofit2.Callback;
import com.tapsdk.antiaddiction.skynet.retrofit2.Response;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.CallArbiter;

public class CallEnqueueOnSubscribe<T>
implements Observable.OnSubscribe<Response<T>> {
    private final Call<T> originalCall;

    CallEnqueueOnSubscribe(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    @Override
    public void call(Subscriber<? super Response<T>> subscriber) {
        Call<T> call = this.originalCall.clone();
        final CallArbiter<T> arbiter = new CallArbiter<T>(call, subscriber);
        subscriber.setProducer(arbiter);
        call.enqueue(new Callback<T>(){

            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                arbiter.emitResponse(response);
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                arbiter.emitError(t);
            }
        });
    }
}

