/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.utils;

import com.tapsdk.antiaddiction.entities.CommonConfig;
import com.tapsdk.antiaddiction.entities.HealthPromptGroup;
import com.tapsdk.antiaddiction.entities.Prompt;
import com.tapsdk.antiaddiction.entities.UIConfig;
import java.util.List;

public enum UIConfigHelper {
    INSTANCE;

    public Prompt tapAuthorizationTipsPrompt;
    public Prompt tapAuthorizationInfoPrompt;
    public Prompt noTapAuthorizationInfoPrompt;
    public Prompt gameRealNameTipsPrompt;
    public Prompt duringCertificationPrompt;
    public Prompt hasAuthRecordTipsPrompt;

    public void init(CommonConfig commonConfig) {
        List<Prompt> promptList;
        if (commonConfig == null) {
            return;
        }
        UIConfig uiConfig = commonConfig.uiConfig;
        if (uiConfig == null) {
            return;
        }
        List<HealthPromptGroup> healthPromptGroupList = uiConfig.healthPromptGroups;
        if (healthPromptGroupList != null && healthPromptGroupList.size() > 0) {
            this.initHealthReminderConfig(healthPromptGroupList);
        }
        if ((promptList = uiConfig.authIdentifyPromptList) != null && promptList.size() > 0) {
            this.initAuthIdentifyConfig(promptList);
        }
    }

    private void initHealthReminderConfig(List<HealthPromptGroup> healthPromptGroupList) {
    }

    private void initAuthIdentifyConfig(List<Prompt> promptList) {
        for (Prompt prompt : promptList) {
            if (prompt.type == 0) {
                this.tapAuthorizationTipsPrompt = prompt;
                continue;
            }
            if (prompt.type == 1) {
                this.tapAuthorizationInfoPrompt = prompt;
                continue;
            }
            if (prompt.type == 2) {
                this.noTapAuthorizationInfoPrompt = prompt;
                continue;
            }
            if (prompt.type == 3) {
                this.gameRealNameTipsPrompt = prompt;
                continue;
            }
            if (prompt.type == 4) {
                this.duringCertificationPrompt = prompt;
                continue;
            }
            if (prompt.type != 5) continue;
            this.hasAuthRecordTipsPrompt = prompt;
        }
    }
}

