/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.bridge.utils;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.tds.common.bridge.Bridge;
import com.tds.common.bridge.BridgeCallback;
import com.tds.common.bridge.BridgeHolder;
import com.tds.common.bridge.IBridgeService;
import com.tds.common.bridge.annotation.BridgeParam;
import com.tds.common.bridge.annotation.BridgeService;
import com.tds.common.bridge.command.Command;
import com.tds.common.bridge.exception.EngineBridgeException;
import com.tds.common.bridge.exception.EngineBridgeExceptionStatus;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BridgeReflect {
    public static boolean checkServiceLegal(Class<?> clz) {
        if (!clz.isInterface()) {
            return false;
        }
        if (clz.getAnnotation(BridgeService.class) == null) {
            return false;
        }
        return IBridgeService.class.isAssignableFrom(clz);
    }

    public static Class<? extends IBridgeService> getLegalService(Class<?> clz) {
        Class<?>[] interfaceClz;
        for (Class<?> superClz : interfaceClz = clz.getInterfaces()) {
            if (!BridgeReflect.checkServiceLegal(superClz)) continue;
            return superClz;
        }
        throw new EngineBridgeException(EngineBridgeExceptionStatus.COMMAND_SERVICE_ERROR.getMessage());
    }

    public static void checkCommand(Command command) {
        if (TextUtils.isEmpty((CharSequence)command.service) || TextUtils.isEmpty((CharSequence)command.method)) {
            throw new EngineBridgeException(EngineBridgeExceptionStatus.COMMAND_PARSE_ERROR.getMessage());
        }
    }

    public static Class<? extends IBridgeService> getRegisterService(Command command) {
        boolean isServiceRegister;
        Class<? extends IBridgeService> serviceClz = BridgeHolder.INSTANCE.getBridgeService(command.service).getKey();
        BridgeService serviceName = serviceClz.getAnnotation(BridgeService.class);
        boolean bl = isServiceRegister = serviceName != null && serviceName.value().equals(command.service);
        if (isServiceRegister) {
            return serviceClz;
        }
        throw new EngineBridgeException(EngineBridgeExceptionStatus.COMMAND_SERVICE_ERROR.getMessage());
    }

    public static Object[] constructorCommandArgs(Method method, Command command, BridgeCallback callback) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        int originParamsCount = 0;
        try {
            JSONObject jsonObject;
            if (TextUtils.isEmpty((CharSequence)command.args)) {
                jsonObject = new JSONObject();
            } else {
                jsonObject = new JSONObject(command.args);
                originParamsCount = jsonObject.length();
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> paramsClz = parameterTypes[i];
                if (paramsClz == Activity.class) {
                    args[i] = Bridge.getInstance().getActivity();
                    ++originParamsCount;
                    continue;
                }
                if (paramsClz == BridgeCallback.class) {
                    args[i] = callback;
                    ++originParamsCount;
                    continue;
                }
                args[i] = BridgeReflect.findParams(jsonObject, method);
            }
            if (!BridgeReflect.checkParamsMatchMethod(jsonObject) || originParamsCount != args.length) {
                return new Object[0];
            }
        }
        catch (IllegalArgumentException | JSONException e) {
            e.printStackTrace();
        }
        return args;
    }

    public static boolean checkParamsMatchMethod(JSONObject jsonObject) {
        return jsonObject.length() == 0;
    }

    public static Object findParams(JSONObject jsonObject, Method method) throws JSONException {
        Annotation[][] parameterAnnotations;
        Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                BridgeParam annotationParams;
                if (!(annotation instanceof BridgeParam) || !jsonObject.has((annotationParams = (BridgeParam)annotation).value())) continue;
                Object args = jsonObject.get(annotationParams.value());
                jsonObject.remove(annotationParams.value());
                if (args == JSONObject.NULL) {
                    Log.d((String)"Command", (String)(" method " + method.getDeclaringClass().getName() + "." + method.getName() + " param " + annotationParams.value() + " convert jsonNull to null"));
                    args = null;
                }
                if (args instanceof JSONArray) {
                    return BridgeReflect.filterArray((JSONArray)args, annotationParams.arrayClz());
                }
                return args;
            }
        }
        return null;
    }

    private static Object[] filterArray(JSONArray jsonArray, Class<?> clz) throws JSONException {
        int len = jsonArray.length();
        if (clz == Boolean.TYPE) {
            Object[] result = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                Array.setBoolean(result, i, jsonArray.getBoolean(i));
            }
            return result;
        }
        if (clz == Integer.TYPE) {
            Object[] result = new Integer[len];
            for (int i = 0; i < len; ++i) {
                Array.setInt(result, i, jsonArray.getInt(i));
            }
            return result;
        }
        if (clz == Long.TYPE) {
            Object[] result = new Long[len];
            for (int i = 0; i < len; ++i) {
                Array.setLong(result, i, jsonArray.getLong(i));
            }
            return result;
        }
        if (clz == Float.TYPE) {
            Object[] result = new Float[len];
            for (int i = 0; i < len; ++i) {
                Array.setFloat(result, i, (float)jsonArray.getDouble(i));
            }
            return result;
        }
        if (clz == Double.TYPE) {
            Object[] result = new Double[len];
            for (int i = 0; i < len; ++i) {
                Array.setDouble(result, i, jsonArray.getDouble(i));
            }
            return result;
        }
        if (clz == String.class) {
            Object[] result = new String[len];
            for (int i = 0; i < len; ++i) {
                result[i] = jsonArray.getString(i);
            }
            return result;
        }
        throw new EngineBridgeException(EngineBridgeExceptionStatus.COMMAND_ARGS_ERROR.getExpandMessage("\u6570\u7ec4\u7c7b\u578b\u7684\u53c2\u6570\u5fc5\u987b\u4e3a\u57fa\u7840\u6570\u636e\u7c7b\u578b!"));
    }
}

