/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.browser;

import android.content.Context;
import android.content.MutableContextWrapper;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.URLUtil;
import android.webkit.WebView;
import com.tds.common.TapCommon;
import com.tds.common.browser.CachedWebView;
import com.tds.common.browser.GarbageCollectionHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PreLoader {
    private static String TAG = "Preload";
    private static final String EMPTY_WEBVIEW = "empty_webview";
    private static final int CACHED_WEBVIEW_MAX_NUM = 1;
    private static long cachedExpiredTime = 60000L;
    private static final Map<String, CachedWebView> cachedWebViewMap = new ConcurrentHashMap<String, CachedWebView>();
    private static final Map<CachedWebView, String> cachedUrlMap = new ConcurrentHashMap<CachedWebView, String>();
    private HandlerThread handlerThread;
    private Handler handler;

    private PreLoader() {
    }

    public void setCachedTime(long time) {
        cachedExpiredTime = time;
    }

    public static PreLoader getInstance() {
        return Holder.INSTANCE;
    }

    public void preload() {
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                if (cachedWebViewMap.size() < 1) {
                    CachedWebView cachedWebView = PreLoader.this.prepareWebView();
                    cachedWebViewMap.put(PreLoader.EMPTY_WEBVIEW, cachedWebView);
                    cachedUrlMap.put(cachedWebView, PreLoader.EMPTY_WEBVIEW);
                }
                return false;
            }
        });
    }

    public void preload(final String url) {
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                if (cachedWebViewMap.size() < 1) {
                    CachedWebView cachedWebView = PreLoader.this.prepareWebView(url);
                    cachedWebViewMap.put(url, cachedWebView);
                    cachedUrlMap.put(cachedWebView, url);
                }
                return false;
            }
        });
    }

    private CachedWebView prepareWebView() {
        return this.prepareWebView("");
    }

    private CachedWebView prepareWebView(String url) {
        if (!URLUtil.isNetworkUrl((String)url) || URLUtil.isJavaScriptUrl((String)url)) {
            url = "";
        }
        if (TapCommon.getTapConfig() == null || TapCommon.getTapConfig().appContext == null) {
            throw new IllegalArgumentException(TAG + " createWebView params appContext can't be null");
        }
        CachedWebView cachedWebView = new CachedWebView((Context)new MutableContextWrapper(TapCommon.getTapConfig().appContext));
        if (url != null && url.length() > 0) {
            cachedWebView.preload(url);
        }
        return cachedWebView;
    }

    public CachedWebView attachCachedView(ViewGroup parent, Context context) {
        return this.attachCachedView(parent, context, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedWebView attachCachedView(ViewGroup parent, Context context, String url) {
        Class<PreLoader> clazz = PreLoader.class;
        synchronized (PreLoader.class) {
            CachedWebView cachedWebView = this.getWebView(context, url);
            if (cachedWebView != null && cachedWebView.getParent() != null) {
                this.detachCachedView(cachedWebView);
            }
            parent.addView((View)cachedWebView);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cachedWebView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachCachedView(WebView cachedWebView) {
        Class<PreLoader> clazz = PreLoader.class;
        synchronized (PreLoader.class) {
            if (cachedWebView.getParent() != null) {
                ((ViewGroup)cachedWebView.getParent()).removeView((View)cachedWebView);
            }
            this.removeCachedWebView(cachedWebView);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private CachedWebView getWebView(Context context) {
        return this.getWebView(context, "");
    }

    private CachedWebView getWebView(Context context, String url) {
        if (cachedWebViewMap.isEmpty() || url.isEmpty() && !cachedWebViewMap.containsKey(EMPTY_WEBVIEW) || !cachedWebViewMap.containsKey(url)) {
            CachedWebView web = this.prepareWebView(url);
            MutableContextWrapper contextWrapper = (MutableContextWrapper)web.getContext();
            contextWrapper.setBaseContext(context);
            String key = url.isEmpty() ? EMPTY_WEBVIEW : url;
            cachedWebViewMap.put(key, web);
            cachedUrlMap.put(web, key);
            return web;
        }
        CachedWebView webView = url.length() == 0 ? cachedWebViewMap.get(EMPTY_WEBVIEW) : cachedWebViewMap.get(url);
        if (webView == null) {
            return null;
        }
        MutableContextWrapper contextWrapper = (MutableContextWrapper)webView.getContext();
        contextWrapper.setBaseContext(context);
        return webView;
    }

    private void bindGarbageCollector() {
        this.unBindGarbageCollector();
        this.handlerThread = new HandlerThread("cachedWebViewCollectionThread", 10);
        this.handlerThread.start();
        this.handler = new GarbageCollectionHandler(this.handlerThread.getLooper(), new GarbageCollectionHandler.AttachFilter(){

            @Override
            public boolean attached(View view) {
                return view != null && view.isAttachedToWindow();
            }
        }, new GarbageCollectionHandler.RecycleCallback(){

            @Override
            public void onRecycle(View view) {
                if (!(view instanceof CachedWebView)) {
                    return;
                }
                if (cachedWebViewMap.size() == 0) {
                    PreLoader.this.unBindGarbageCollector();
                }
            }
        }, cachedExpiredTime);
    }

    public void removeCachedWebView(WebView cachedWebView) {
        if (!(cachedWebView instanceof CachedWebView)) {
            return;
        }
        if (cachedUrlMap.size() > 0 && cachedUrlMap.containsKey(cachedWebView)) {
            String cachedUrl = cachedUrlMap.remove(cachedWebView);
            if (cachedUrl != null) {
                cachedWebViewMap.remove(cachedUrl);
            }
            cachedWebView.removeAllViews();
            cachedWebView.setTag(null);
            cachedWebView.clearHistory();
            cachedWebView.destroy();
        }
    }

    private void unBindGarbageCollector() {
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        if (this.handlerThread != null) {
            this.handlerThread.quitSafely();
        }
        this.handler = null;
        this.handlerThread = null;
    }

    private static class Holder {
        private static final PreLoader INSTANCE = new PreLoader();

        private Holder() {
        }
    }
}

