/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.isc;

import com.tds.common.isc.IscException;
import com.tds.common.isc.IscMethod;
import com.tds.common.isc.Method;
import java.lang.reflect.Modifier;

public class Service {
    private final Class<?> clazz;

    Service(Class<?> clazz) {
        this.clazz = clazz;
    }

    public boolean hasMethod(String name) {
        try {
            return this.method(name) != null;
        }
        catch (IscException e) {
            return false;
        }
    }

    public Method method(String name) throws IscException {
        try {
            java.lang.reflect.Method method = this.findStaticMethod(name);
            if (method == null) {
                throw new IscException(this.clazz.getName() + " does not contain public static method annotated with @IscMethod " + name);
            }
            return new Method(method);
        }
        catch (Throwable e) {
            if (e instanceof IscException) {
                throw e;
            }
            throw new IscException(e);
        }
    }

    public <T> T directCall(String name, Object ... params) throws IscException {
        try {
            Method method = this.method(name);
            return method.call(params);
        }
        catch (Throwable e) {
            if (e instanceof IscException) {
                throw e;
            }
            throw new IscException(e);
        }
    }

    private java.lang.reflect.Method findStaticMethod(String iscMethodName) {
        for (java.lang.reflect.Method method : this.clazz.getDeclaredMethods()) {
            IscMethod annotation;
            if (!this.isPublicStaticMethod(method) || (annotation = method.getAnnotation(IscMethod.class)) == null || !iscMethodName.equals(annotation.value())) continue;
            return method;
        }
        return null;
    }

    private boolean isPublicStaticMethod(java.lang.reflect.Method method) {
        int m = method.getModifiers();
        return Modifier.isPublic(m) && Modifier.isStatic(m);
    }
}

