/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.log.entities;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.tds.common.localize.LocalizeManager;
import com.tds.common.utils.DeviceUtils;
import com.tds.common.utils.GUIDHelper;
import java.util.HashMap;
import java.util.Map;

public class LogConfig {
    private static final int DEFAULT_GROUP_SIZE = 5;
    public final String sdkName;
    public final String source;
    public final boolean enableUpload;
    public final String platform;
    public final String osVersion;
    public final int sdkVersionCode;
    public final String sdkVersionName;
    public final String lang;
    public final String deviceId;
    public final int groupSize;
    private final String gamePackage;
    private final int gameVersionCode;
    private final String gameVersionName;
    public final Map<String, String> tagsMap;

    public LogConfig(Builder builder) {
        this.sdkName = builder.sdkName;
        this.source = builder.source;
        this.enableUpload = builder.enableUpload;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.sdkVersionCode = builder.sdkVersionCode;
        this.sdkVersionName = builder.sdkVersionName;
        this.lang = builder.lang;
        this.deviceId = builder.deviceId;
        this.groupSize = builder.groupSize;
        this.gamePackage = builder.gamePackage;
        this.gameVersionCode = builder.gameVersionCode;
        this.gameVersionName = builder.gameVersionName;
        this.tagsMap = new HashMap<String, String>();
        this.tagsMap.put("PLATFORM", this.platform);
        if (!TextUtils.isEmpty((CharSequence)this.osVersion)) {
            this.tagsMap.put("OS_VERSION", this.osVersion);
        }
        if (!TextUtils.isEmpty((CharSequence)this.lang)) {
            this.tagsMap.put("LANG", this.lang);
        }
        if (!TextUtils.isEmpty((CharSequence)this.deviceId)) {
            this.tagsMap.put("DEVIE_ID", this.deviceId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.gamePackage)) {
            this.tagsMap.put("GAME_ID", this.gamePackage);
        }
        if (this.gameVersionCode != Integer.MIN_VALUE) {
            this.tagsMap.put("GAME_VERSION_CODE", String.valueOf(this.gameVersionCode));
        }
        if (!TextUtils.isEmpty((CharSequence)this.gameVersionName)) {
            this.tagsMap.put("GAME_VERSION_NAME", this.gameVersionName);
        }
    }

    public String toString() {
        return "LogConfig{topic='" + this.sdkName + '\'' + ", enableUpload=" + this.enableUpload + ", platform='" + this.platform + '\'' + ", osVersion='" + this.osVersion + '\'' + ", sdkVersionCode=" + this.sdkVersionCode + ", sdkVersionName='" + this.sdkVersionName + '\'' + ", lang='" + this.lang + '\'' + ", deviceId='" + this.deviceId + '\'' + '}';
    }

    public static class Builder {
        private String sdkName = "";
        private String source = "source";
        private boolean enableUpload = false;
        private String platform = "";
        private String osVersion = "";
        private int sdkVersionCode = Integer.MIN_VALUE;
        private String sdkVersionName = "";
        private String lang = "";
        private String deviceId = "";
        private int groupSize = 5;
        private String gamePackage = "";
        private int gameVersionCode = Integer.MIN_VALUE;
        private String gameVersionName = "";

        public Builder withTopic(String topic) {
            this.sdkName = topic;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder withEnableUpload(boolean enableUpload) {
            this.enableUpload = enableUpload;
            return this;
        }

        public Builder withSdkVersionCode(int versionCode) {
            this.sdkVersionCode = versionCode;
            return this;
        }

        public Builder withSdkVersionName(String versionName) {
            this.sdkVersionName = versionName;
            return this;
        }

        public Builder withGroupSize(int groupSize) {
            this.groupSize = groupSize;
            return this;
        }

        public LogConfig build(Context context) {
            if (TextUtils.isEmpty((CharSequence)this.sdkName)) {
                throw new RuntimeException("topic not init");
            }
            if (context != null) {
                if (this.sdkVersionCode == Integer.MIN_VALUE) {
                    throw new RuntimeException("sdkVersionCode not init");
                }
                if (TextUtils.isEmpty((CharSequence)this.sdkVersionName)) {
                    throw new RuntimeException("sdkVersionName not init");
                }
                GUIDHelper.INSTANCE.init(context.getApplicationContext());
                this.deviceId = GUIDHelper.INSTANCE.getUID();
                this.osVersion = DeviceUtils.getOSVersion();
                this.platform = DeviceUtils.getPlatform();
                this.lang = LocalizeManager.getPreferredLanguageString();
                this.gamePackage = context.getPackageName();
                try {
                    PackageInfo packageInfo = context.getPackageManager().getPackageInfo(this.gamePackage, 0);
                    this.gameVersionName = packageInfo.versionName;
                    this.gameVersionCode = packageInfo.versionCode;
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            return new LogConfig(this);
        }
    }
}

