/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net;

import android.text.TextUtils;
import com.tds.common.io.IoUtil;
import com.tds.common.net.EventListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public final class TdsHttp {
    private static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static Client.Builder newClientBuilder() {
        return new Client.Builder();
    }

    public static Request.Builder newRequestBuilder() {
        return new Request.Builder();
    }

    static final class RealInterceptorChain
    implements Interceptor.Chain {
        private final List<Interceptor> interceptors;
        private final int index;
        private final Request request;
        private final Call call;
        private final int connectTimeout;
        private final int readTimeout;
        private final int writeTimeout;

        RealInterceptorChain(List<Interceptor> interceptors, int index, Request request, Call call, int connectTimeout, int readTimeout, int writeTimeout) {
            this.interceptors = interceptors;
            this.index = index;
            this.request = request;
            this.call = call;
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
            this.writeTimeout = writeTimeout;
        }

        @Override
        public Request request() {
            return this.request;
        }

        @Override
        public Response proceed(Request request) throws IOException {
            if (this.index >= this.interceptors.size()) {
                throw new AssertionError();
            }
            RealInterceptorChain next = new RealInterceptorChain(this.interceptors, this.index + 1, request, this.call, this.connectTimeout, this.readTimeout, this.writeTimeout);
            Interceptor interceptor = this.interceptors.get(this.index);
            Response response = interceptor.intercept(next);
            if (response == null) {
                throw new NullPointerException(interceptor + " returned null");
            }
            if (response.body == null) {
                throw new IllegalStateException(interceptor + " returned a response with no body");
            }
            return response;
        }

        @Override
        public Call call() {
            return this.call;
        }

        @Override
        public int connectTimeoutMillis() {
            return this.connectTimeout;
        }

        @Override
        public Interceptor.Chain withConnectTimeout(int timeout, TimeUnit unit) {
            int millis = (int)unit.toMillis(timeout);
            return new RealInterceptorChain(this.interceptors, this.index, this.request, this.call, millis, this.readTimeout, this.writeTimeout);
        }

        @Override
        public int readTimeoutMillis() {
            return this.readTimeout;
        }

        @Override
        public Interceptor.Chain withReadTimeout(int timeout, TimeUnit unit) {
            int millis = (int)unit.toMillis(timeout);
            return new RealInterceptorChain(this.interceptors, this.index, this.request, this.call, this.connectTimeout, millis, this.writeTimeout);
        }

        @Override
        public int writeTimeoutMillis() {
            return this.writeTimeout;
        }

        @Override
        public Interceptor.Chain withWriteTimeout(int timeout, TimeUnit unit) {
            int millis = (int)unit.toMillis(timeout);
            return new RealInterceptorChain(this.interceptors, this.index, this.request, this.call, this.connectTimeout, this.readTimeout, millis);
        }
    }

    static final class CallServerInterceptor
    implements Interceptor {
        CallServerInterceptor() {
        }

        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            HttpURLConnection connection = CallServerInterceptor.open(request.url, chain.call().client);
            connection.setConnectTimeout(chain.connectTimeoutMillis());
            connection.setReadTimeout(chain.readTimeoutMillis());
            this.writeRequest(connection, request);
            int code = connection.getResponseCode();
            String message = connection.getResponseMessage();
            Map<String, List<String>> headers = connection.getHeaderFields();
            ResponseBody body = ResponseBody.create(connection);
            return new Response.Builder().request(request).code(code).message(message).headers(headers).body(body).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeRequest(HttpURLConnection connection, Request request) throws IOException {
            connection.setRequestMethod(request.method);
            for (Map.Entry<String, String> entry : request.headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (request.body != null) {
                long contentLength;
                String contentType = request.body.contentType();
                if (contentType != null) {
                    connection.setRequestProperty("Content-Type", contentType);
                }
                if ((contentLength = request.body.contentLength()) > 0L) {
                    connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
                }
                connection.setDoOutput(true);
                long len = request.body.contentLength();
                if (len > 0L) {
                    connection.setFixedLengthStreamingMode((int)len);
                } else {
                    connection.setChunkedStreamingMode(0);
                }
                OutputStream out = null;
                try {
                    out = connection.getOutputStream();
                    request.body.writeTo(out);
                }
                finally {
                    IoUtil.closeQuietly(out);
                }
            }
        }

        private static HttpURLConnection open(String url, Client client) throws IOException {
            HttpURLConnection conn = client.proxy != null ? (HttpURLConnection)new URL(url).openConnection(client.proxy) : (HttpURLConnection)new URL(url).openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection sConn = (HttpsURLConnection)conn;
                if (!client.trustAllCerts) {
                    if (client.sslSocketFactory != null) {
                        sConn.setSSLSocketFactory(client.sslSocketFactory);
                    }
                    if (client.hostnameVerifier != null) {
                        sConn.setHostnameVerifier(client.hostnameVerifier);
                    }
                }
            }
            return conn;
        }
    }

    public static interface Interceptor {
        public Response intercept(Chain var1) throws IOException;

        public static interface Chain {
            public Request request();

            public Response proceed(Request var1) throws IOException;

            public Call call();

            public int connectTimeoutMillis();

            public Chain withConnectTimeout(int var1, TimeUnit var2);

            public int readTimeoutMillis();

            public Chain withReadTimeout(int var1, TimeUnit var2);

            public int writeTimeoutMillis();

            public Chain withWriteTimeout(int var1, TimeUnit var2);
        }
    }

    public static class Call {
        final Client client;
        final Request originalRequest;

        public Request getOriginalRequest() {
            return this.originalRequest;
        }

        Call(Client client, Request originalRequest) {
            this.client = client;
            this.originalRequest = originalRequest;
        }

        public Response execute() throws IOException {
            ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(this.client.interceptors);
            interceptors.add(new CallServerInterceptor());
            RealInterceptorChain chain = new RealInterceptorChain(interceptors, 0, this.originalRequest, this, this.client.connectTimeout, this.client.readTimeout, this.client.writeTimeout);
            return chain.proceed(this.originalRequest);
        }
    }

    public static abstract class ResponseBody
    implements Closeable {
        private String cacheResponse;

        public abstract String contentType();

        public long contentLength() {
            return -1L;
        }

        public abstract InputStream byteStream() throws IOException;

        public final String string() throws IOException {
            try {
                if (this.cacheResponse != null && this.cacheResponse.length() > 0) {
                    String string = this.cacheResponse;
                    return string;
                }
                String string = this.cacheResponse = IoUtil.readString(this.byteStream());
                return string;
            }
            finally {
                this.close();
            }
        }

        @Override
        public void close() throws IOException {
            IoUtil.closeQuietly(this.byteStream());
        }

        public static ResponseBody create(final HttpURLConnection connection) {
            TdsHttp.requireNonNull(connection);
            return new ResponseBody(){

                @Override
                public String contentType() {
                    return connection.getContentType();
                }

                @Override
                public long contentLength() {
                    return connection.getContentLength();
                }

                @Override
                public InputStream byteStream() throws IOException {
                    String encoding;
                    InputStream inputStream = connection.getErrorStream();
                    if (inputStream == null) {
                        inputStream = connection.getInputStream();
                    }
                    if (!TextUtils.isEmpty((CharSequence)(encoding = connection.getHeaderField("Content-Encoding"))) && encoding != null && encoding.toLowerCase().contains("gzip")) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    return inputStream;
                }

                @Override
                public void close() throws IOException {
                    try {
                        IoUtil.closeQuietly(connection.getErrorStream());
                        IoUtil.closeQuietly(connection.getInputStream());
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        connection.disconnect();
                    }
                }
            };
        }
    }

    public static class Response
    implements Closeable {
        final Request request;
        final int code;
        final String message;
        final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        final ResponseBody body;

        public Response(Builder builder) {
            this.request = builder.request;
            this.code = builder.code;
            this.message = builder.message;
            this.headers.putAll(builder.headers);
            this.body = builder.body;
        }

        public int code() {
            return this.code;
        }

        public String message() {
            return this.message;
        }

        public ResponseBody body() {
            return this.body;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public boolean isSuccessful() {
            return this.code >= 200 && this.code < 300;
        }

        @Override
        public void close() throws IOException {
            if (this.body != null) {
                this.body.close();
            }
        }

        public static class Builder {
            Request request;
            int code = -1;
            String message;
            final Map<String, List<String>> headers = new HashMap<String, List<String>>();
            ResponseBody body;

            public Builder request(Request request) {
                this.request = request;
                return this;
            }

            public Builder code(int code) {
                this.code = code;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder header(String name, String value) {
                this.headers.put(name, Collections.singletonList(value));
                return this;
            }

            public Builder headers(Map<String, List<String>> headers) {
                this.headers.putAll(headers);
                return this;
            }

            public Builder removeHeader(String name) {
                this.headers.remove(name);
                return this;
            }

            public Builder body(ResponseBody body) {
                this.body = body;
                return this;
            }

            public Response build() {
                return new Response(this);
            }
        }
    }

    static class CountBytesOutputStream
    extends OutputStream {
        long length = 0L;

        CountBytesOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.length;
        }
    }

    public static class FormBody
    extends RequestBody {
        private final List<String> encodedNames;
        private final List<String> encodedValues;
        private long contentLength = -1L;

        FormBody(List<String> encodedNames, List<String> encodedValues) {
            this.encodedNames = new ArrayList<String>(encodedNames);
            this.encodedValues = new ArrayList<String>(encodedValues);
        }

        @Override
        public String contentType() {
            return "application/x-www-form-urlencoded";
        }

        @Override
        public long contentLength() throws IOException {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.writeOrCountBytes(null);
            return this.contentLength;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.writeOrCountBytes(out);
        }

        private long writeOrCountBytes(OutputStream out) throws IOException {
            boolean countBytes;
            boolean bl = countBytes = out == null;
            if (countBytes) {
                out = new CountBytesOutputStream();
            }
            OutputStreamWriter writer = new OutputStreamWriter(out);
            int size = this.encodedNames.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    ((Writer)writer).append("&");
                }
                ((Writer)writer).append(this.encodedNames.get(i));
                ((Writer)writer).append("=");
                ((Writer)writer).append(this.encodedValues.get(i));
            }
            ((Writer)writer).flush();
            if (countBytes) {
                return ((CountBytesOutputStream)out).length;
            }
            return 0L;
        }

        public static final class Builder {
            private final List<String> names = new ArrayList<String>();
            private final List<String> values = new ArrayList<String>();
            private final String charset = "UTF-8";

            public Builder add(String name, String value) {
                TdsHttp.requireNonNull(name);
                TdsHttp.requireNonNull(value);
                this.names.add(this.encode(name));
                this.values.add(this.encode(value));
                return this;
            }

            public Builder addEncoded(String name, String value) {
                TdsHttp.requireNonNull(name);
                TdsHttp.requireNonNull(value);
                this.names.add(name);
                this.values.add(value);
                return this;
            }

            public FormBody build() {
                return new FormBody(this.names, this.values);
            }

            private String encode(String s) {
                try {
                    return URLEncoder.encode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    return s;
                }
            }
        }
    }

    public static class MultipartBody
    extends RequestBody {
        static final String DASHDASH = "--";
        static final String CRLF = "\r\n";
        final String boundary;
        final String type;
        final List<Part> parts;
        private long contentLength = -1L;

        MultipartBody(Builder builder) {
            this.boundary = builder.boundary;
            this.type = builder.type;
            this.parts = Collections.unmodifiableList(new ArrayList<Part>(builder.parts));
        }

        @Override
        public String contentType() {
            return this.type;
        }

        @Override
        public long contentLength() throws IOException {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.writeOrCountBytes(null);
            return this.contentLength;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.writeOrCountBytes(out);
        }

        private long writeOrCountBytes(OutputStream out) throws IOException {
            boolean countBytes;
            boolean bl = countBytes = out == null;
            if (countBytes) {
                out = new CountBytesOutputStream();
            }
            OutputStreamWriter writer = new OutputStreamWriter(out);
            int count = this.parts.size();
            for (int i = 0; i < count; ++i) {
                Part part = this.parts.get(i);
                List<String> headers = part.headers;
                RequestBody body = part.body;
                ((Writer)writer).append(DASHDASH).append(this.boundary).append(CRLF);
                for (String line : headers) {
                    ((Writer)writer).append(line).append(CRLF);
                }
                if (countBytes && body.contentLength() == -1L) {
                    return -1L;
                }
                ((Writer)writer).append(CRLF).flush();
                body.writeTo(out);
                ((Writer)writer).append(CRLF);
            }
            ((Writer)writer).append(DASHDASH).append(this.boundary).append(DASHDASH).append(CRLF).flush();
            if (countBytes) {
                return ((CountBytesOutputStream)out).length;
            }
            return 0L;
        }

        public static final class Builder {
            final String boundary = "----" + System.currentTimeMillis();
            final String type = "multipart/form-data; boundary=" + this.boundary;
            final List<Part> parts = new ArrayList<Part>();

            Builder addPart(Part part) {
                this.parts.add(part);
                return this;
            }

            public Builder addFormDataPart(Map<String, String> fields) {
                for (Map.Entry<String, String> entry : fields.entrySet()) {
                    this.addFormDataPart(entry.getKey(), entry.getValue());
                }
                return this;
            }

            public Builder addFormDataPart(String name, String value) {
                List<String> headers = Arrays.asList("Content-Disposition: form-data; name=\"" + name + "\"", "Content-Type: text/plain; charset=UTF-8");
                RequestBody body = RequestBody.create(null, value);
                return this.addPart(new Part(headers, body));
            }

            public Builder addFormDataPart(String name, File file) {
                RequestBody body = RequestBody.create(null, file);
                return this.addFormDataPart(name, file.getName(), body);
            }

            public Builder addFormDataPart(String name, String filename, RequestBody body) {
                List<String> headers = Arrays.asList("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + filename + "\"", "Content-Type: " + URLConnection.guessContentTypeFromName(filename), "Content-Transfer-Encoding: binary");
                return this.addPart(new Part(headers, body));
            }

            public MultipartBody build() {
                return new MultipartBody(this);
            }
        }

        public static final class Part {
            final List<String> headers;
            final RequestBody body;

            Part(List<String> headers, RequestBody body) {
                this.headers = headers;
                this.body = body;
            }
        }
    }

    public static abstract class RequestBody {
        public abstract String contentType();

        public long contentLength() throws IOException {
            return -1L;
        }

        public abstract void writeTo(OutputStream var1) throws IOException;

        public static RequestBody createJsonBody(String content) {
            return RequestBody.create("application/json", content);
        }

        public static RequestBody createProtoBuffBody(byte[] bytes) {
            return RequestBody.create("application/x-protobuf", bytes);
        }

        public static RequestBody create(String contentType, String content) {
            return RequestBody.create(contentType, content.getBytes());
        }

        public static RequestBody create(final String contentType, final byte[] content) {
            return new RequestBody(){

                @Override
                public String contentType() {
                    return contentType;
                }

                @Override
                public long contentLength() throws IOException {
                    return content.length;
                }

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    out.write(content);
                }
            };
        }

        public static RequestBody create(final String contentType, final File file) {
            TdsHttp.requireNonNull(file);
            return new RequestBody(){

                @Override
                public String contentType() {
                    return contentType;
                }

                @Override
                public long contentLength() throws IOException {
                    return file.length();
                }

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    IoUtil.copy(file, out);
                }
            };
        }
    }

    public static class Request {
        public final String method;
        public final String url;
        public final Map<String, String> headers = new HashMap<String, String>();
        public final RequestBody body;

        public Request(Builder builder) {
            this.method = builder.method;
            this.url = builder.url;
            this.headers.putAll(builder.headers);
            this.body = builder.body;
        }

        public String method() {
            return this.method;
        }

        public String url() {
            return this.url;
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        public static class Builder {
            String method = "GET";
            String url;
            final Map<String, String> headers = new HashMap<String, String>();
            RequestBody body;

            public Builder url(String url) {
                TdsHttp.requireNonNull(url);
                this.url = url;
                return this;
            }

            public Builder addHeaders(Map<String, String> headers) {
                this.headers.putAll(headers);
                return this;
            }

            public Builder header(String name, String value) {
                this.headers.put(name, value);
                return this;
            }

            public Builder removeHeader(String name) {
                this.headers.remove(name);
                return this;
            }

            public Builder get() {
                return this.method("GET", null);
            }

            public Builder head() {
                return this.method("HEAD", null);
            }

            public Builder post(RequestBody body) {
                return this.method("POST", body);
            }

            public Builder delete() {
                return this.delete(null);
            }

            public Builder delete(RequestBody body) {
                return this.method("DELETE", body);
            }

            public Builder method(String method, RequestBody body) {
                this.method = method;
                this.body = body;
                return this;
            }

            public Request build() {
                return new Request(this);
            }
        }
    }

    public static class Client {
        final List<Interceptor> interceptors;
        final int connectTimeout;
        final int readTimeout;
        final int writeTimeout;
        final SSLSocketFactory sslSocketFactory;
        final HostnameVerifier hostnameVerifier;
        final boolean trustAllCerts;
        final Proxy proxy;
        final EventListener eventListener;

        public EventListener getEventListener() {
            return this.eventListener;
        }

        Client(Builder builder) {
            this.interceptors = Collections.unmodifiableList(new ArrayList<Interceptor>(builder.interceptors));
            this.connectTimeout = builder.connectTimeout;
            this.readTimeout = builder.readTimeout;
            this.writeTimeout = builder.writeTimeout;
            this.sslSocketFactory = builder.sslSocketFactory;
            this.hostnameVerifier = builder.hostnameVerifier;
            this.trustAllCerts = builder.trustAllCerts;
            this.proxy = builder.proxy;
            this.eventListener = builder.eventListener;
        }

        public Call newCall(Request request) {
            return new Call(this, request);
        }

        public static class Builder {
            final List<Interceptor> interceptors = new ArrayList<Interceptor>();
            int connectTimeout = 5000;
            int readTimeout = 5000;
            int writeTimeout = 5000;
            SSLSocketFactory sslSocketFactory;
            HostnameVerifier hostnameVerifier;
            boolean trustAllCerts = true;
            Proxy proxy = null;
            EventListener eventListener = null;

            public Builder addInterceptor(Interceptor interceptor) {
                TdsHttp.requireNonNull(interceptor);
                this.interceptors.add(interceptor);
                return this;
            }

            public Builder connectTimeout(long timeout, TimeUnit unit) {
                this.connectTimeout = (int)unit.toMillis(timeout);
                return this;
            }

            public Builder readTimeout(long timeout, TimeUnit unit) {
                this.readTimeout = (int)unit.toMillis(timeout);
                return this;
            }

            public Builder writeTimeout(long timeout, TimeUnit unit) {
                this.writeTimeout = (int)unit.toMillis(timeout);
                return this;
            }

            public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
                this.sslSocketFactory = sslSocketFactory;
                return this;
            }

            public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
                this.hostnameVerifier = hostnameVerifier;
                return this;
            }

            public Builder trustAllCerts(boolean trustAllCerts) {
                this.trustAllCerts = trustAllCerts;
                return this;
            }

            public Builder proxy(Proxy proxy) {
                this.proxy = proxy;
                return this;
            }

            public Builder addEventListener(EventListener eventListener) {
                this.eventListener = eventListener;
                return this;
            }

            public Client build() {
                return new Client(this);
            }
        }
    }
}

