/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.notch;

import android.os.Build;
import android.view.Window;
import com.tds.common.notch.core.INotchSupport;
import com.tds.common.notch.helper.DeviceBrandTools;
import com.tds.common.notch.helper.NotchStatusBarUtils;
import com.tds.common.notch.phone.CommonScreen;
import com.tds.common.notch.phone.HuaWeiNotchScreen;
import com.tds.common.notch.phone.MiuiNotchScreen;
import com.tds.common.notch.phone.OppoNotchScreen;
import com.tds.common.notch.phone.PVersionNotchScreen;
import com.tds.common.notch.phone.VivoNotchScreen;

public class NotchTools
implements INotchSupport {
    private static NotchTools sFullScreenTolls;
    private static final int CURRENT_SDK;
    private static final int VERSION_P = 28;
    private INotchSupport notchScreenSupport = null;
    private boolean mHasJudge;
    private boolean mIsNotchScreen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotchTools getFullScreenTools() {
        if (sFullScreenTolls != null) return sFullScreenTolls;
        Class<NotchTools> clazz = NotchTools.class;
        synchronized (NotchTools.class) {
            if (sFullScreenTolls != null) return sFullScreenTolls;
            sFullScreenTolls = new NotchTools();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFullScreenTolls;
        }
    }

    private NotchTools() {
    }

    @Override
    public boolean isNotchScreen(Window window) {
        if (!this.mHasJudge) {
            if (this.notchScreenSupport == null) {
                this.checkScreenSupportInit(window);
            }
            if (this.notchScreenSupport == null) {
                this.mHasJudge = true;
                this.mIsNotchScreen = false;
            } else {
                this.mIsNotchScreen = this.notchScreenSupport.isNotchScreen(window);
            }
        }
        return this.mIsNotchScreen;
    }

    @Override
    public int getNotchHeight(Window window) {
        if (this.notchScreenSupport == null) {
            this.checkScreenSupportInit(window);
        }
        if (this.notchScreenSupport == null) {
            return 0;
        }
        return this.notchScreenSupport.getNotchHeight(window);
    }

    @Override
    public int getStatusHeight(Window window) {
        return NotchStatusBarUtils.getStatusBarHeight(window.getContext());
    }

    private void checkScreenSupportInit(Window window) {
        if (this.notchScreenSupport != null) {
            return;
        }
        if (CURRENT_SDK < 26) {
            this.notchScreenSupport = new CommonScreen();
            return;
        }
        if (CURRENT_SDK <= 28) {
            DeviceBrandTools deviceBrandTools = DeviceBrandTools.getInstance();
            this.notchScreenSupport = deviceBrandTools.isHuaWei() ? new HuaWeiNotchScreen() : (deviceBrandTools.isMiui() ? new MiuiNotchScreen() : (deviceBrandTools.isVivo() ? new VivoNotchScreen() : (deviceBrandTools.isOppo() ? new OppoNotchScreen() : new CommonScreen())));
            return;
        }
        this.notchScreenSupport = new PVersionNotchScreen();
    }

    static {
        CURRENT_SDK = Build.VERSION.SDK_INT;
    }
}

