/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.oauth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.tds.common.R;
import com.tds.common.TapCommon;
import com.tds.common.notch.NotchTools;
import com.tds.common.oauth.AuthorizationPresenter;
import com.tds.common.oauth.AuthorizeModel;
import com.tds.common.oauth.AuthorizeResultCallBack;
import com.tds.common.oauth.exception.AuthorizeException;
import com.tds.common.oauth.models.AuthorizeFlow;
import com.tds.common.oauth.models.AuthorizeResponse;
import com.tds.common.oauth.views.AuthorizeWebContainer;
import com.tds.common.utils.UIUtils;
import org.json.JSONException;

public class TapTapEntryActivity
extends Activity
implements AuthorizationPresenter.AuthorizationView {
    public static int AUTHORIZATION_REQUEST_CODE = 100;
    public static final String AUTHORIZE_PERMISSIONS_EXTRA_PARAM = "permissions";
    public static final String AUTHORIZE_SOURCE_EXTRA_PARAM = "source";
    private AuthorizationPresenter presenter;
    private boolean authFromWeb = false;
    AuthorizeWebContainer authorizeWebContainer;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!TapCommon.isTapCommonInitialized()) {
            this.finish();
            return;
        }
        this.setContentView(R.layout.tds_common_activity_oauth_entry);
        if (TapCommon.getTapConfig() == null || TapCommon.getTapConfig().clientId == null || TapCommon.getTapConfig().clientId.length() == 0) {
            if (AuthorizeModel.authorizationCallback != null) {
                AuthorizeModel.authorizationCallback.onError(new AuthorizeException("illegal parameters"));
            }
            this.finish();
            return;
        }
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            if (Build.VERSION.SDK_INT >= 28) {
                layoutParams.layoutInDisplayCutoutMode = 1;
                View decorView = window.getDecorView();
                decorView.setSystemUiVisibility(1280);
            }
            window.setAttributes(layoutParams);
        }
        this.presenter = new AuthorizationPresenter((Context)this, this);
        String[] permissions = this.getIntent().getStringArrayExtra(AUTHORIZE_PERMISSIONS_EXTRA_PARAM);
        String source = this.getIntent().getStringExtra(AUTHORIZE_SOURCE_EXTRA_PARAM);
        try {
            this.presenter.authorization(permissions, source);
        }
        catch (Exception e) {
            this.attachAuthorizeWebView();
        }
    }

    private void attachAuthorizeWebView() {
        this.authFromWeb = true;
        this.authorizeWebContainer = new AuthorizeWebContainer();
        String[] permissions = this.getIntent().getStringArrayExtra(AUTHORIZE_PERMISSIONS_EXTRA_PARAM);
        String source = this.getIntent().getStringExtra(AUTHORIZE_SOURCE_EXTRA_PARAM);
        Bundle bundle = new Bundle();
        bundle.putParcelable("request", (Parcelable)this.presenter.makeLoginRequest(permissions, source));
        this.authorizeWebContainer.setArguments(bundle);
        this.authorizeWebContainer.attachActivity(this, (ViewGroup)this.findViewById(R.id.taptap_sdk_container));
        this.authorizeWebContainer.setLoginCallback(new AuthorizeWebContainer.IWebLoginCallback(){

            @Override
            public void onResponse(AuthorizeResponse response) {
                TapTapEntryActivity.this.parseResponse(response);
                TapTapEntryActivity.this.finish();
            }
        });
    }

    private void detachAuthorizeWebView() {
        this.authFromWeb = false;
    }

    protected void onResume() {
        super.onResume();
        this.setLayout(this.getResources().getConfiguration());
    }

    public void onBackPressed() {
        if (this.authFromWeb) {
            this.finish();
            return;
        }
        super.onBackPressed();
    }

    public void setLayout(Configuration configuration) {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        View root = this.findViewById(R.id.taptap_sdk_container);
        boolean hasNotch = NotchTools.getFullScreenTools().isNotchScreen(this.getWindow());
        if (configuration.orientation == 2) {
            root.setPadding(0, 0, 0, 0);
        } else {
            root.setPadding(0, hasNotch ? UIUtils.dp2px((Context)this, 30.0f) : 0, 0, 0);
        }
    }

    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        this.setLayout(config);
        if (this.authFromWeb) {
            this.authorizeWebContainer.onConfigurationChanged(config);
        }
    }

    private void parseResponse(AuthorizeResponse response) {
        if (AuthorizeModel.authorizationCallback == null) {
            return;
        }
        if (response.cancel) {
            AuthorizeModel.authorizationCallback.onCancel();
        } else if (!this.presenter.checkState(response.state)) {
            AuthorizeModel.authorizationCallback.onError(new AuthorizeException("state not equal"));
        } else if (!TextUtils.isEmpty((CharSequence)response.errorMessage)) {
            if (TextUtils.equals((CharSequence)response.errorMessage, (CharSequence)"access_denied")) {
                AuthorizeModel.authorizationCallback.onCancel();
            } else {
                AuthorizeModel.authorizationCallback.onError(new AuthorizeException(response.errorMessage));
            }
        } else if (response.token == null && response.code == null) {
            AuthorizeModel.authorizationCallback.onError(new AuthorizeException("token is null"));
        } else if ("1".equals(response.loginVersion)) {
            AuthorizeFlow.exchangeTokenByCode(TapCommon.getTapConfig(), response.code, this.presenter.getProcessAuthorizeRequest().getCodeVerifier(), response.state, new AuthorizeResultCallBack(){

                @Override
                public void onAuthorizeResult(AuthorizeResponse response) {
                    if (!TextUtils.isEmpty((CharSequence)response.errorMessage)) {
                        if (TextUtils.equals((CharSequence)response.errorMessage, (CharSequence)"access_denied")) {
                            AuthorizeModel.authorizationCallback.onCancel();
                        } else {
                            AuthorizeModel.authorizationCallback.onError(new AuthorizeException(response.errorMessage));
                        }
                    } else {
                        TapTapEntryActivity.this.loginWithToken(response);
                    }
                }
            });
        } else {
            this.loginWithToken(response);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.authFromWeb) {
            return;
        }
        if (AuthorizeModel.authorizationCallback == null) {
            return;
        }
        if (resultCode == -1) {
            try {
                this.parseResponse(AuthorizeResponse.getResultFromIntent(data));
                this.finish();
            }
            catch (JSONException jsonException) {
                jsonException.printStackTrace();
            }
        } else if (resultCode == 0) {
            AuthorizeModel.authorizationCallback.onCancel();
        } else {
            AuthorizeModel.authorizationCallback.onError(new AuthorizeException("unknown exception"));
        }
    }

    private void loginWithToken(AuthorizeResponse response) {
        if (AuthorizeModel.authorizationCallback == null) {
            return;
        }
        AuthorizeModel.authorizationCallback.onSuccess(response.token);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.detach();
        }
        this.detachAuthorizeWebView();
    }

    @Override
    public void realAuthorization(Intent intent) {
        this.startActivityForResult(intent, AUTHORIZATION_REQUEST_CODE);
    }
}

