/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.rxandroid.schedulers;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tds.common.reactor.Subscription;
import com.tds.common.reactor.exceptions.OnErrorNotImplementedException;
import com.tds.common.reactor.functions.Action0;
import com.tds.common.reactor.plugins.RxJavaPlugins;
import com.tds.common.reactor.rxandroid.plugins.RxAndroidPlugins;
import com.tds.common.reactor.rxandroid.plugins.RxAndroidSchedulersHook;
import com.tds.common.reactor.schedulers.Scheduler;
import com.tds.common.reactor.subscriptions.Subscriptions;
import java.util.concurrent.TimeUnit;

public class LooperScheduler
extends Scheduler {
    private final Handler handler;

    LooperScheduler(Looper looper) {
        this.handler = new Handler(looper);
    }

    LooperScheduler(Handler handler) {
        this.handler = handler;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new HandlerWorker(this.handler);
    }

    static final class ScheduledAction
    implements Runnable,
    Subscription {
        private final Action0 action;
        private final Handler handler;
        private volatile boolean unsubscribed;

        ScheduledAction(Action0 action, Handler handler) {
            this.action = action;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                this.action.call();
            }
            catch (Throwable e) {
                IllegalStateException ie = e instanceof OnErrorNotImplementedException ? new IllegalStateException("Exception thrown on Scheduler.Worker thread. Add `onError` handling.", e) : new IllegalStateException("Fatal Exception thrown on Scheduler.Worker thread.", e);
                RxJavaPlugins.getInstance().getErrorHandler().handleError(ie);
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, ie);
            }
        }

        @Override
        public void unsubscribe() {
            this.unsubscribed = true;
            this.handler.removeCallbacks((Runnable)this);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }
    }

    static class HandlerWorker
    extends Scheduler.Worker {
        private final Handler handler;
        private final RxAndroidSchedulersHook hook;
        private volatile boolean unsubscribed;

        HandlerWorker(Handler handler) {
            this.handler = handler;
            this.hook = RxAndroidPlugins.getInstance().getSchedulersHook();
        }

        @Override
        public void unsubscribe() {
            this.unsubscribed = true;
            this.handler.removeCallbacksAndMessages((Object)this);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (this.unsubscribed) {
                return Subscriptions.unsubscribed();
            }
            action = this.hook.onSchedule(action);
            ScheduledAction scheduledAction = new ScheduledAction(action, this.handler);
            Message message = Message.obtain((Handler)this.handler, (Runnable)scheduledAction);
            message.obj = this;
            this.handler.sendMessageDelayed(message, unit.toMillis(delayTime));
            if (this.unsubscribed) {
                this.handler.removeCallbacks((Runnable)scheduledAction);
                return Subscriptions.unsubscribed();
            }
            return scheduledAction;
        }

        @Override
        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }
    }
}

