/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.tracker.model;

import android.text.TextUtils;
import com.tds.common.tracker.model.BaseTrackModel;
import java.util.HashMap;
import java.util.Map;

public class NetworkStateModel
implements BaseTrackModel {
    public static final String PARAM_SESSION_ID = "session_id";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_CODE = "code";
    public static final String PARAM_DELAY = "delay";
    private String sessionId;
    private String host;
    private int code = -1;
    private long delay = -1L;

    public NetworkStateModel withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public NetworkStateModel withHost(String host) {
        this.host = host;
        return this;
    }

    public NetworkStateModel withHttpCode(int code) {
        this.code = code;
        return this;
    }

    public NetworkStateModel withDelay(long delay) {
        this.delay = delay;
        return this;
    }

    @Override
    public Map<String, String> convert() {
        HashMap<String, String> netWorkStateMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.sessionId)) {
            netWorkStateMap.put(PARAM_SESSION_ID, this.sessionId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.host)) {
            netWorkStateMap.put(PARAM_HOST, this.host);
        }
        if (this.code != -1) {
            netWorkStateMap.put(PARAM_CODE, String.valueOf(this.code));
        }
        if (this.delay != -1L) {
            netWorkStateMap.put(PARAM_DELAY, String.valueOf(this.delay));
        }
        return netWorkStateMap;
    }
}

