/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.unity3d;

import android.text.TextUtils;
import cn.sharesdk.unity3d.ShareSDKLog;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ShareSDKThreadPool {
    private static ScheduledExecutorService singleExecutor = Executors.newSingleThreadScheduledExecutor();

    public static final <T extends SafeRunnable> void singleExecute(T runnable) {
        try {
            singleExecutor.execute(runnable);
        }
        catch (Throwable e) {
            ShareSDKLog.e("singleExecuteError", e);
        }
    }

    public static final <T extends SafeRunnable> void singleExecute(T runnable, long delayMillis) {
        try {
            singleExecutor.schedule(runnable, delayMillis, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            ShareSDKLog.e("singleExecuteError", e);
        }
    }

    public static abstract class SafeRunnable
    implements Runnable {
        @Override
        public final void run() {
            try {
                if (!TextUtils.isEmpty((CharSequence)this.threadName())) {
                    Thread.currentThread().setName(this.threadName());
                }
                this.safeRun();
            }
            catch (Throwable e) {
                try {
                    this.error(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ShareSDKLog.e("", e);
            }
        }

        public abstract void safeRun();

        public void error(Throwable e) {
        }

        public String threadName() {
            return "";
        }
    }
}

