/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.Uri;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SimulatorTool {
    private static SimulatorTool instance;
    private Context mContext;
    boolean isSimulator = false;
    private final String[] PKG_NAMES = new String[]{"com.mumu.launcher", "com.ami.duosupdater.ui", "com.ami.launchmetro", "com.ami.syncduosservices", "com.bluestacks.home", "com.bluestacks.windowsfilemanager", "com.bluestacks.settings", "com.bluestacks.bluestackslocationprovider", "com.bluestacks.appsettings", "com.bluestacks.bstfolder", "com.bluestacks.BstCommandProcessor", "com.bluestacks.s2p", "com.bluestacks.setup", "com.bluestacks.appmart", "com.kaopu001.tiantianserver", "com.kpzs.helpercenter", "com.kaopu001.tiantianime", "com.android.development_settings", "com.android.development", "com.android.customlocale2", "com.genymotion.superuser", "com.genymotion.clipboardproxy", "com.uc.xxzs.keyboard", "com.uc.xxzs", "com.blue.huang17.agent", "com.blue.huang17.launcher", "com.blue.huang17.ime", "com.microvirt.guide", "com.microvirt.market", "com.microvirt.memuime", "cn.itools.vm.launcher", "cn.itools.vm.proxy", "cn.itools.vm.softkeyboard", "cn.itools.avdmarket", "com.syd.IME", "com.bignox.app.store.hd", "com.bignox.launcher", "com.bignox.app.phone", "com.bignox.app.noxservice", "com.android.noxpush", "com.haimawan.push", "me.haima.helpcenter", "com.windroy.launcher", "com.windroy.superuser", "com.windroy.launcher", "com.windroy.ime", "com.android.flysilkworm", "com.android.emu.inputservice", "com.tiantian.ime", "com.microvirt.launcher", "me.le8.androidassist", "com.vphone.helper", "com.vphone.launcher", "eu.chainfire.supersu", "com.duoyi.giftcenter.giftcenter"};
    private String[] known_pipes = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe", "/dev/socket/genyd", "/dev/socket/baseband_genyd"};
    private final String[] emulatorFiles = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe", "/dev/socket/genyd", "/dev/socket/baseband_genyd", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/system/bin/failsafe/su", "/data/youwave_id", "/dev/vboxguest", "/dev/vboxuser", "/mnt/prebundledapps/bluestacks.prop.orig", "/mnt/prebundledapps/propfiles/ics.bluestacks.prop.note", "/mnt/prebundledapps/propfiles/ics.bluestacks.prop.s2", "/mnt/prebundledapps/propfiles/ics.bluestacks.prop.s3", "/mnt/sdcard/bstfolder/InputMapper/com.bluestacks.appmart.cfg", "/mnt/sdcard/buildroid-gapps-ics-20120317-signed.tgz", "/mnt/sdcard/windows/InputMapper/com.bluestacks.appmart.cfg", "/proc/irq/9/vboxguest", "/sys/bus/pci/drivers/vboxguest", "/sys/bus/pci/drivers/vboxguest/0000:00:04.0", "/sys/bus/pci/drivers/vboxguest/bind", "/sys/bus/pci/drivers/vboxguest/module", "/sys/bus/pci/drivers/vboxguest/new_id", "/sys/bus/pci/drivers/vboxguest/remove_id", "/sys/bus/pci/drivers/vboxguest/uevent", "/sys/bus/pci/drivers/vboxguest/unbind", "/sys/bus/platform/drivers/qemu_pipe", "/sys/bus/platform/drivers/qemu_trace", "/sys/class/bdi/vboxsf-c", "/sys/class/misc/vboxguest", "/sys/class/misc/vboxuser", "/sys/devices/virtual/bdi/vboxsf-c", "/sys/devices/virtual/misc/vboxguest", "/sys/devices/virtual/misc/vboxguest/dev", "/sys/devices/virtual/misc/vboxguest/power", "/sys/devices/virtual/misc/vboxguest/subsystem", "/sys/devices/virtual/misc/vboxguest/uevent", "/sys/devices/virtual/misc/vboxuser", "/sys/devices/virtual/misc/vboxuser/dev", "/sys/devices/virtual/misc/vboxuser/power", "/sys/devices/virtual/misc/vboxuser/subsystem", "/sys/devices/virtual/misc/vboxuser/uevent", "/sys/module/vboxguest", "/sys/module/vboxguest/coresize", "/sys/module/vboxguest/drivers", "/sys/module/vboxguest/drivers/pci:vboxguest", "/sys/module/vboxguest/holders", "/sys/module/vboxguest/holders/vboxsf", "/sys/module/vboxguest/initsize", "/sys/module/vboxguest/initstate", "/sys/module/vboxguest/notes", "/sys/module/vboxguest/notes/.note.gnu.build-id", "/sys/module/vboxguest/parameters", "/sys/module/vboxguest/parameters/log", "/sys/module/vboxguest/parameters/log_dest", "/sys/module/vboxguest/parameters/log_flags", "/sys/module/vboxguest/refcnt", "/sys/module/vboxguest/sections", "/sys/module/vboxguest/sections/.altinstructions", "/sys/module/vboxguest/sections/.altinstr_replacement", "/sys/module/vboxguest/sections/.bss", "/sys/module/vboxguest/sections/.data", "/sys/module/vboxguest/sections/.devinit.data", "/sys/module/vboxguest/sections/.exit.text", "/sys/module/vboxguest/sections/.fixup", "/sys/module/vboxguest/sections/.gnu.linkonce.this_module", "/sys/module/vboxguest/sections/.init.text", "/sys/module/vboxguest/sections/.note.gnu.build-id", "/sys/module/vboxguest/sections/.rodata", "/sys/module/vboxguest/sections/.rodata.str1.1", "/sys/module/vboxguest/sections/.smp_locks", "/sys/module/vboxguest/sections/.strtab", "/sys/module/vboxguest/sections/.symtab", "/sys/module/vboxguest/sections/.text", "/sys/module/vboxguest/sections/__ex_table", "/sys/module/vboxguest/sections/__ksymtab", "/sys/module/vboxguest/sections/__ksymtab_strings", "/sys/module/vboxguest/sections/__param", "/sys/module/vboxguest/srcversion", "/sys/module/vboxguest/taint", "/sys/module/vboxguest/uevent", "/sys/module/vboxguest/version", "/sys/module/vboxsf", "/sys/module/vboxsf/coresize", "/sys/module/vboxsf/holders", "/sys/module/vboxsf/initsize", "/sys/module/vboxsf/initstate", "/sys/module/vboxsf/notes", "/sys/module/vboxsf/notes/.note.gnu.build-id", "/sys/module/vboxsf/refcnt", "/sys/module/vboxsf/sections", "/sys/module/vboxsf/sections/.bss", "/sys/module/vboxsf/sections/.data", "/sys/module/vboxsf/sections/.exit.text", "/sys/module/vboxsf/sections/.gnu.linkonce.this_module", "/sys/module/vboxsf/sections/.init.text", "/sys/module/vboxsf/sections/.note.gnu.build-id", "/sys/module/vboxsf/sections/.rodata", "/sys/module/vboxsf/sections/.rodata.str1.1", "/sys/module/vboxsf/sections/.smp_locks", "/sys/module/vboxsf/sections/.strtab", "/sys/module/vboxsf/sections/.symtab", "/sys/module/vboxsf/sections/.text", "/sys/module/vboxsf/sections/__bug_table", "/sys/module/vboxsf/sections/__param", "/sys/module/vboxsf/srcversion", "/sys/module/vboxsf/taint", "/sys/module/vboxsf/uevent", "/sys/module/vboxsf/version", "/sys/module/vboxvideo", "/sys/module/vboxvideo/coresize", "/sys/module/vboxvideo/holders", "/sys/module/vboxvideo/initsize", "/sys/module/vboxvideo/initstate", "/sys/module/vboxvideo/notes", "/sys/module/vboxvideo/notes/.note.gnu.build-id", "/sys/module/vboxvideo/refcnt", "/sys/module/vboxvideo/sections", "/sys/module/vboxvideo/sections/.data", "/sys/module/vboxvideo/sections/.exit.text", "/sys/module/vboxvideo/sections/.gnu.linkonce.this_module", "/sys/module/vboxvideo/sections/.init.text", "/sys/module/vboxvideo/sections/.note.gnu.build-id", "/sys/module/vboxvideo/sections/.rodata.str1.1", "/sys/module/vboxvideo/sections/.strtab", "/sys/module/vboxvideo/sections/.symtab", "/sys/module/vboxvideo/sections/.text", "/sys/module/vboxvideo/srcversion", "/sys/module/vboxvideo/taint", "/sys/module/vboxvideo/uevent", "/sys/module/vboxvideo/version", "/system/app/bluestacksHome.apk", "/system/bin/androVM-prop", "/system/bin/androVM-vbox-sf", "/system/bin/androVM_setprop", "/system/bin/get_androVM_host", "/system/bin/mount.vboxsf", "/system/etc/init.androVM.sh", "/system/etc/init.buildroid.sh", "/system/lib/hw/audio.primary.vbox86.so", "/system/lib/hw/camera.vbox86.so", "/system/lib/hw/gps.vbox86.so", "/system/lib/hw/gralloc.vbox86.so", "/system/lib/hw/sensors.vbox86.so", "/system/lib/modules/3.0.8-android-x86+/extra/vboxguest", "/system/lib/modules/3.0.8-android-x86+/extra/vboxguest/vboxguest.ko", "/system/lib/modules/3.0.8-android-x86+/extra/vboxsf", "/system/lib/modules/3.0.8-android-x86+/extra/vboxsf/vboxsf.ko", "/system/lib/vboxguest.ko", "/system/lib/vboxsf.ko", "/system/lib/vboxvideo.ko", "/system/usr/idc/androVM_Virtual_Input.idc", "/system/usr/keylayout/androVM_Virtual_Input.kl", "/system/xbin/mount.vboxsf", "/ueventd.android_x86.rc", "/ueventd.vbox86.rc", "/ueventd.goldfish.rc", "/fstab.vbox86", "/init.vbox86.rc", "/init.goldfish.rc", "/sys/module/goldfish_audio", "/sys/module/goldfish_sync", "/data/app/com.bluestacks.appmart-1.apk", "/data/app/com.bluestacks.BstCommandProcessor-1.apk", "/data/app/com.bluestacks.help-1.apk", "/data/app/com.bluestacks.home-1.apk", "/data/app/com.bluestacks.s2p-1.apk", "/data/app/com.bluestacks.searchapp-1.apk", "/data/bluestacks.prop", "/data/data/com.androVM.vmconfig", "/data/data/com.bluestacks.accelerometerui", "/data/data/com.bluestacks.appfinder", "/data/data/com.bluestacks.appmart", "/data/data/com.bluestacks.appsettings", "/data/data/com.bluestacks.BstCommandProcessor", "/data/data/com.bluestacks.bstfolder", "/data/data/com.bluestacks.help", "/data/data/com.bluestacks.home", "/data/data/com.bluestacks.s2p", "/data/data/com.bluestacks.searchapp", "/data/data/com.bluestacks.settings", "/data/data/com.bluestacks.setup", "/data/data/com.bluestacks.spotlight", "/data/data/com.microvirt.download", "/data/data/com.microvirt.guide", "/data/data/com.microvirt.installer", "/data/data/com.microvirt.launcher", "/data/data/com.microvirt.market", "/data/data/com.microvirt.memuime", "/data/data/com.microvirt.tools", "/data/data/com.mumu.launcher", "/data/data/com.mumu.store", "/data/data/com.netease.mumu.cloner"};
    private final String TAG = "EmulatorDetector";
    private int rating = -1;

    private SimulatorTool() {
    }

    public static SimulatorTool instance() {
        if (instance == null) {
            instance = new SimulatorTool();
        }
        return instance;
    }

    public boolean simulator(Context context, int newtype) {
        this.mContext = context;
        try {
            this.isSimulator = this.judgePackageName(context) || this.isFlat(context) && this.isDialPhone(context) || this.checkPipesName() || this.isSenCfg(context) || this.checkIsNotRealPhone() || this.isEmulator() || this.isAdopt(context) ? true : this.checkPipes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.isSimulator;
    }

    public boolean isAdopt(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatusIntent = context.registerReceiver(null, intentFilter);
        int voltage = batteryStatusIntent.getIntExtra("voltage", 99999);
        int temperature = batteryStatusIntent.getIntExtra("temperature", 99999);
        return voltage == 0 && temperature == 0 || voltage == 10000 && temperature == 0;
    }

    public void AppProcessName(Context context) {
        List packages = context.getPackageManager().getInstalledPackages(0);
        for (int i = 0; i < packages.size(); ++i) {
            PackageInfo packageInfo = (PackageInfo)packages.get(i);
            String appName = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
            String packageName = packageInfo.packageName;
            String string = packageInfo.versionName;
        }
    }

    private String getSystemProperty(String name) throws Exception {
        Class<?> systemPropertyClazz = Class.forName("android.os.SystemProperties");
        return (String)systemPropertyClazz.getMethod("get", String.class).invoke(systemPropertyClazz, name);
    }

    public boolean checkEmulator(Context context) {
        try {
            boolean goldfish = this.getSystemProperty("ro.hardware").contains("goldfish");
            boolean emu = this.getSystemProperty("ro.kernel.qemu").length() > 0;
            boolean sdk = this.getSystemProperty("ro.product.model").equals("sdk");
            if (emu || goldfish || sdk) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Boolean notHasLightSensorManager(Context context) {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        Sensor sensor8 = sensorManager.getDefaultSensor(5);
        if (null == sensor8) {
            return true;
        }
        return false;
    }

    public boolean isFeatures(Context context) {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.toLowerCase().contains("vbox") || Build.FINGERPRINT.toLowerCase().contains("test-keys") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("MuMu") || Build.MODEL.contains("virtual") || Build.SERIAL.equalsIgnoreCase("android") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT) || ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName().toLowerCase().equals("android");
    }

    public boolean checkIsNotRealPhone() {
        String cpuInfo = this.readCpuInfo();
        return cpuInfo.contains("intel") || cpuInfo.contains("amd");
    }

    public String readCpuInfo() {
        String result = "";
        try {
            String[] args = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            ProcessBuilder cmd = new ProcessBuilder(args);
            Process process = cmd.start();
            StringBuffer sb = new StringBuffer();
            String readLine = "";
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
            while ((readLine = responseReader.readLine()) != null) {
                sb.append(readLine);
            }
            responseReader.close();
            result = sb.toString().toLowerCase();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public boolean isDialPhone(Context context) {
        String url = "tel:10086";
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)url));
        intent.setAction("android.intent.action.DIAL");
        boolean canCallPhone = intent.resolveActivity(context.getPackageManager()) != null;
        return !canCallPhone;
    }

    public boolean checkPipes() {
        boolean ischeckPipes = false;
        for (int i = 0; i < this.emulatorFiles.length; ++i) {
            String pipes = this.emulatorFiles[i];
            File qemu_socket = new File(pipes);
            if (!qemu_socket.exists()) continue;
            ischeckPipes = true;
            break;
        }
        return ischeckPipes;
    }

    public boolean isEmulator() {
        int newRating = 0;
        if (this.rating < 0) {
            if (Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("Andy") || Build.PRODUCT.contains("ttVM_Hdragon") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("Droid4X") || Build.PRODUCT.contains("nox") || Build.PRODUCT.contains("sdk_x86") || Build.PRODUCT.contains("sdk_google") || Build.PRODUCT.contains("vbox86p")) {
                ++newRating;
            }
            if (Build.MANUFACTURER.equals("unknown") || Build.MANUFACTURER.equals("Genymotion") || Build.MANUFACTURER.contains("Andy") || Build.MANUFACTURER.contains("MIT") || Build.MANUFACTURER.contains("nox") || Build.MANUFACTURER.contains("TiantianVM")) {
                ++newRating;
            }
            if (Build.BRAND.equals("generic") || Build.BRAND.equals("generic_x86") || Build.BRAND.equals("TTVM") || Build.BRAND.contains("Andy")) {
                ++newRating;
            }
            if (Build.DEVICE.contains("generic") || Build.DEVICE.contains("generic_x86") || Build.DEVICE.contains("Andy") || Build.DEVICE.contains("ttVM_Hdragon") || Build.DEVICE.contains("Droid4X") || Build.DEVICE.contains("nox") || Build.DEVICE.contains("generic_x86_64") || Build.DEVICE.contains("vbox86p")) {
                ++newRating;
            }
            if (Build.MODEL.equals("sdk") || Build.MODEL.equals("google_sdk") || Build.MODEL.contains("Droid4X") || Build.MODEL.contains("TiantianVM") || Build.MODEL.contains("Andy") || Build.MODEL.equals("Android SDK built for x86_64") || Build.MODEL.equals("Android SDK built for x86")) {
                ++newRating;
            }
            if (Build.HARDWARE.equals("goldfish") || Build.HARDWARE.equals("vbox86") || Build.HARDWARE.contains("nox") || Build.HARDWARE.contains("ttVM_x86")) {
                ++newRating;
            }
            if (Build.FINGERPRINT.contains("generic/sdk/generic") || Build.FINGERPRINT.contains("generic_x86/sdk_x86/generic_x86") || Build.FINGERPRINT.contains("Andy") || Build.FINGERPRINT.contains("ttVM_Hdragon") || Build.FINGERPRINT.contains("generic_x86_64") || Build.FINGERPRINT.contains("generic/google_sdk/generic") || Build.FINGERPRINT.contains("vbox86p") || Build.FINGERPRINT.contains("generic/vbox86p/vbox86p")) {
                ++newRating;
            }
            try {
                String opengl = GLES20.glGetString((int)7937);
                if (opengl != null && (opengl.contains("Bluestacks") || opengl.contains("Translator"))) {
                    newRating += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                File sharedFolder = new File(Environment.getExternalStorageDirectory().toString() + File.separatorChar + "windows" + File.separatorChar + "BstSharedFolder");
                if (sharedFolder.exists()) {
                    newRating += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.rating = newRating;
        }
        return this.rating > 3;
    }

    public String getDeviceListing() {
        return "Build.PRODUCT: " + Build.PRODUCT + "\n" + "Build.MANUFACTURER: " + Build.MANUFACTURER + "\n" + "Build.BRAND: " + Build.BRAND + "\n" + "Build.DEVICE: " + Build.DEVICE + "\n" + "Build.MODEL: " + Build.MODEL + "\n" + "Build.HARDWARE: " + Build.HARDWARE + "\n" + "Build.FINGERPRINT: " + Build.FINGERPRINT + "\n" + "Build.TAGS: " + Build.TAGS + "\n" + "GL_RENDERER: " + GLES20.glGetString((int)7937) + "\n" + "GL_VENDOR: " + GLES20.glGetString((int)7936) + "\n" + "GL_VERSION: " + GLES20.glGetString((int)7938) + "\n" + "GL_EXTENSIONS: " + GLES20.glGetString((int)7939) + "\n";
    }

    public boolean isFlat(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    public boolean checkPipesName() {
        String[] strArr;
        for (String file : strArr = new String[]{"/Android/data/com.bignox.app.store.hd", "/Android/data/com.bignox.app.store.hd/files", "/Android/data/com.bignox.app.store.hd/cache"}) {
            if (!new File(Environment.getExternalStorageDirectory(), file).exists()) continue;
            return true;
        }
        return false;
    }

    public boolean judgePackageName(Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("com.mumu.launcher");
        list.add("com.mumu.audio");
        list.add("com.microvirt.download");
        list.add("com.microvirt.guide");
        return this.isAppName(context, list);
    }

    @SuppressLint(value={"WrongConstant"})
    private boolean isAppName(Context context, List<String> list) {
        PackageManager packageManager = context.getPackageManager();
        List installedPackages = packageManager.getInstalledPackages(0);
        for (int i = 0; i < installedPackages.size(); ++i) {
            if (!list.contains(((PackageInfo)installedPackages.get((int)i)).packageName)) continue;
            return true;
        }
        for (String launchIntentForPackage : list) {
            Intent launchIntentForPackage2 = packageManager.getLaunchIntentForPackage(launchIntentForPackage);
            if (launchIntentForPackage2 == null || packageManager.queryIntentActivities(launchIntentForPackage2, 65536).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSenCfg(Context context) {
        return this.isSensor(context) == false && this.isCfg();
    }

    @SuppressLint(value={"WrongConstant"})
    public Boolean isSensor(Context context) {
        if (((SensorManager)context.getSystemService("sensor")).getDefaultSensor(5) == null) {
            return false;
        }
        return true;
    }

    private boolean isCfg() {
        String[] strArr;
        for (String file : strArr = new String[]{"/windows/InputMapper/com.bluepotiongames.eosm.cfg", "/windows/InputMapper/com.bluestonesoft.soularkglobal.cfg", "/DCIM/SharedFolder/bs_avatar.png"}) {
            if (!new File(Environment.getExternalStorageDirectory(), file).exists()) continue;
            return true;
        }
        return false;
    }

    public void toast(String toas, int newtype) {
        if (newtype != 0) {
            Log.e((String)"douyou", (String)(toas + "isSimulator===" + this.isSimulator + newtype));
        }
    }
}

