/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.net;

import android.text.TextUtils;
import com.sdk.douyou.Constant;
import com.sdk.douyou.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;

public class DouYouHttpUtil {
    public static String post(Map<String, String> map, String url_suffix) {
        String url = "https://api.aargame.com/" + url_suffix;
        String msg = "";
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(5000);
            if (map.containsKey("Authorization")) {
                if (map.get("Authorization") != null || map.get("Authorization").isEmpty()) {
                    conn.setRequestProperty("Authorization", map.get("Authorization"));
                }
                LogUtil.debug("Authorization : " + map.get("Authorization"));
                map.remove("Authorization");
            }
            conn.setRequestProperty("myua", Constant.UA);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.connect();
            String data = DouYouHttpUtil.getBody(map);
            LogUtil.debug("url \uff1a" + url + " -- " + "body : " + data);
            DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
            dos.write(data.getBytes());
            dos.flush();
            dos.close();
            if (conn.getResponseCode() == 200) {
                InputStream is = conn.getInputStream();
                ByteArrayOutputStream message = new ByteArrayOutputStream();
                int len = 0;
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    message.write(buffer, 0, len);
                }
                is.close();
                message.close();
                msg = new String(message.toByteArray());
                LogUtil.debug(msg);
                return msg;
            }
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public static String getBody(Map<String, String> map) {
        String body = "";
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(map);
        StringBuilder tempParams = new StringBuilder();
        try {
            for (Map.Entry entry : sortedMap.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) {
                    tempParams.append((String)entry.getKey() + "=" + (String)entry.getValue() + "&");
                    continue;
                }
                tempParams.append((String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8") + "&");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        tempParams.append("sign=" + DouYouHttpUtil.toMD5(tempParams.toString().substring(0, tempParams.toString().length() - 1)) + "&");
        body = tempParams.toString();
        body = body.substring(0, body.length() - 1);
        return body;
    }

    public static String get(Map<String, String> paramsMap, String url_suffix) {
        String msg = "";
        String token = "";
        if (paramsMap.containsKey("Authorization")) {
            if (paramsMap.get("Authorization") != null || paramsMap.get("Authorization").isEmpty()) {
                token = paramsMap.get("Authorization");
            }
            LogUtil.debug("Authorization : " + paramsMap.get("Authorization"));
            paramsMap.remove("Authorization");
        }
        try {
            String baseUrl = "https://api.aargame.com/" + url_suffix;
            StringBuilder tempParams = new StringBuilder();
            int pos = 0;
            for (String key : paramsMap.keySet()) {
                if (pos > 0) {
                    tempParams.append("&");
                }
                tempParams.append(String.format("%s=%s", key, URLEncoder.encode(paramsMap.get(key), "utf-8")));
                ++pos;
            }
            String requestUrl = baseUrl + "?" + tempParams.toString();
            LogUtil.debug(requestUrl);
            URL url = new URL(requestUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(5000);
            urlConn.setReadTimeout(5000);
            urlConn.setUseCaches(true);
            urlConn.setRequestMethod("GET");
            if (!token.isEmpty()) {
                urlConn.setRequestProperty("Authorization", token);
            }
            urlConn.setRequestProperty("myua", Constant.UA);
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.addRequestProperty("Connection", "Keep-Alive");
            urlConn.connect();
            if (urlConn.getResponseCode() == 200) {
                msg = DouYouHttpUtil.streamToString(urlConn.getInputStream());
                return msg;
            }
            urlConn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u7cfb\u7edf\u5f02\u5e38";
        }
        return msg;
    }

    public static String streamToString(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            baos.close();
            is.close();
            byte[] byteArray = baos.toByteArray();
            return new String(byteArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toMD5(String str) {
        str = str + "&key=" + Constant.BaleKey;
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            result = buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }
}

