/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.sdk.douyou.util.DYUIUtils;
import com.sdk.douyou.util.ResourceUtil;

public class NewsToastView
extends LinearLayout {
    private static NewsToastView instance;
    private static String toastString;
    private ImageView douyou_toast_util_iamge;
    private TextView douyou_toast_util_tv;
    private static WindowManager mWindowManager;
    private static WindowManager.LayoutParams mLayoutParams;
    private TimeCount mTimeCount;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    NewsToastView.this.removeNewsToastView();
                }
            }
        }
    };

    public NewsToastView(Activity activity) {
        this(activity, null);
    }

    public NewsToastView(Activity activity, AttributeSet attrs) {
        this(activity, attrs, 0);
    }

    public NewsToastView(Activity activity, AttributeSet attrs, int defStyleAttr) {
        super((Context)activity, attrs, defStyleAttr);
        this.mTimeCount = new TimeCount(4000L, 1000L);
        mWindowManager = (WindowManager)activity.getSystemService("window");
        mLayoutParams = new WindowManager.LayoutParams();
        NewsToastView.mLayoutParams.type = 2;
        NewsToastView.mLayoutParams.format = 1;
        NewsToastView.mLayoutParams.flags = 40;
        NewsToastView.mLayoutParams.gravity = 49;
        NewsToastView.mLayoutParams.width = -2;
        NewsToastView.mLayoutParams.height = -2;
        NewsToastView.mLayoutParams.x = 0;
        NewsToastView.mLayoutParams.y = DYUIUtils.dip2px((Context)activity, 20.0f);
        View layout = LayoutInflater.from((Context)activity).inflate(ResourceUtil.getLayoutId((Context)activity, "douyou_toast_util"), null);
        this.douyou_toast_util_iamge = (ImageView)layout.findViewById(ResourceUtil.getId((Context)activity, "douyou_toast_util_iamge"));
        this.douyou_toast_util_tv = (TextView)layout.findViewById(ResourceUtil.getId((Context)activity, "douyou_toast_util_tv"));
        this.douyou_toast_util_tv.setText((CharSequence)toastString);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(NewsToastView.mLayoutParams.width, NewsToastView.mLayoutParams.height);
        layout.setLayoutParams(params);
        this.addView(layout);
    }

    public static synchronized NewsToastView getInstance(Activity activity, String msg) {
        if (instance == null) {
            instance = new NewsToastView(activity);
            toastString = msg;
        }
        return instance;
    }

    public void showNewsToastView() {
        if (this.getParent() == null) {
            mWindowManager.addView((View)this, (ViewGroup.LayoutParams)mLayoutParams);
        } else {
            mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)mLayoutParams);
        }
        if (this.mTimeCount.isStart) {
            this.mTimeCount.cancel();
        }
        this.mTimeCount.start();
    }

    public void removeNewsToastView() {
        if (this.getParent() != null) {
            mWindowManager.removeViewImmediate((View)this);
        }
        mWindowManager = null;
        mLayoutParams = null;
        instance = null;
        if (this.mTimeCount.isStart) {
            this.mTimeCount.cancel();
        }
    }

    private int getHeight(Activity ctx) {
        Rect outRect = new Rect();
        ctx.getWindow().getDecorView().getWindowVisibleDisplayFrame(outRect);
        Log.e((String)"jxps", (String)("outRect.bottom-outRect.top : " + (outRect.bottom - outRect.top)));
        Log.e((String)"jxps", (String)("Height : " + mWindowManager.getDefaultDisplay().getHeight()));
        return outRect.bottom - outRect.top;
    }

    static {
        toastString = "\u4f60\u6709\u65b0\u7684\u6d88\u606f";
    }

    private class TimeCount
    extends CountDownTimer {
        boolean isStart;

        public TimeCount(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);
            this.isStart = false;
        }

        public void onFinish() {
            NewsToastView.this.mHandler.sendEmptyMessage(0);
            this.isStart = false;
        }

        public void onTick(long millisUntilFinished) {
            this.isStart = true;
        }
    }
}

