/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view.xlist;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.sdk.douyou.util.ResourceUtil;

public class XFooterView
extends LinearLayout {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_READY = 1;
    public static final int STATE_LOADING = 2;
    private final int ROTATE_ANIM_DURATION = 180;
    private Context activity;
    private View mLayout;
    private View mProgressBar;
    private TextView mHintView;
    private Animation mRotateUpAnim;
    private Animation mRotateDownAnim;
    private int mState = 0;

    public XFooterView(Context context) {
        super(context);
        this.initView(context);
    }

    public XFooterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.activity = context;
        this.mLayout = LayoutInflater.from((Context)context).inflate(ResourceUtil.getLayoutId(context, "vw_footer"), null);
        this.mLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.addView(this.mLayout);
        this.mProgressBar = this.mLayout.findViewById(ResourceUtil.getId(context, "footer_progressbar"));
        this.mHintView = (TextView)this.mLayout.findViewById(ResourceUtil.getId(context, "footer_hint_text"));
        this.mRotateUpAnim = new RotateAnimation(0.0f, 180.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateUpAnim.setDuration(180L);
        this.mRotateUpAnim.setFillAfter(true);
        this.mRotateDownAnim = new RotateAnimation(180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateDownAnim.setDuration(180L);
        this.mRotateDownAnim.setFillAfter(true);
    }

    public void setState(int state) {
        if (state == this.mState) {
            return;
        }
        if (state == 2) {
            this.mProgressBar.setVisibility(0);
            this.mHintView.setVisibility(4);
        } else {
            this.mHintView.setVisibility(0);
            this.mProgressBar.setVisibility(4);
        }
        switch (state) {
            case 0: {
                this.mHintView.setText(ResourceUtil.getStringId(this.activity, "footer_hint_load_normal"));
                break;
            }
            case 1: {
                if (this.mState == 1) break;
                this.mHintView.setText(ResourceUtil.getStringId(this.activity, "footer_hint_load_ready"));
                break;
            }
        }
        this.mState = state;
    }

    public void setBottomMargin(int margin) {
        if (margin < 0) {
            return;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mLayout.getLayoutParams();
        lp.bottomMargin = margin;
        this.mLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public int getBottomMargin() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mLayout.getLayoutParams();
        return lp.bottomMargin;
    }

    public void normal() {
        this.mHintView.setVisibility(0);
        this.mProgressBar.setVisibility(8);
    }

    public void loading() {
        this.mHintView.setVisibility(8);
        this.mProgressBar.setVisibility(0);
    }

    public void hide() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mLayout.getLayoutParams();
        lp.height = 0;
        this.mLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void show() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mLayout.getLayoutParams();
        lp.height = -2;
        this.mLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
    }
}

