/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view.xlist;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.Scroller;
import android.widget.TextView;
import com.sdk.douyou.util.ResourceUtil;
import com.sdk.douyou.util.view.xlist.XFooterView;
import com.sdk.douyou.util.view.xlist.XHeaderView;

public class XScrollView
extends ScrollView
implements AbsListView.OnScrollListener {
    private static final int SCROLL_BACK_HEADER = 0;
    private static final int SCROLL_BACK_FOOTER = 1;
    private static final int SCROLL_DURATION = 400;
    private static final int PULL_LOAD_MORE_DELTA = 50;
    private static final float OFFSET_RADIO = 1.8f;
    private float mLastY = -1.0f;
    private Context activity;
    private Scroller mScroller;
    private AbsListView.OnScrollListener mScrollListener;
    private int mScrollBack;
    private IXScrollViewListener mListener;
    private LinearLayout mLayout;
    private LinearLayout mContentLayout;
    private XHeaderView mHeader;
    private RelativeLayout mHeaderContent;
    private TextView mHeaderTime;
    private int mHeaderHeight;
    private XFooterView mFooterView;
    private boolean mEnablePullRefresh = true;
    private boolean mPullRefreshing = false;
    private boolean mEnablePullLoad = true;
    private boolean mEnableAutoLoad = false;
    private boolean mPullLoading = false;

    public XScrollView(Context context) {
        super(context);
        this.initWithContext(context);
    }

    public XScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWithContext(context);
    }

    public XScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initWithContext(context);
    }

    private void initWithContext(Context context) {
        this.activity = context;
        this.mLayout = (LinearLayout)View.inflate((Context)context, (int)ResourceUtil.getLayoutId(context, "vw_xscrollview_layout"), null);
        this.mContentLayout = (LinearLayout)this.mLayout.findViewById(ResourceUtil.getId(context, "content_layout"));
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        this.setOnScrollListener(this);
        this.mHeader = new XHeaderView(context);
        this.mHeaderContent = (RelativeLayout)this.mHeader.findViewById(ResourceUtil.getId(context, "header_content"));
        this.mHeaderTime = (TextView)this.mHeader.findViewById(ResourceUtil.getId(context, "header_hint_time"));
        LinearLayout headerLayout = (LinearLayout)this.mLayout.findViewById(ResourceUtil.getId(context, "header_layout"));
        headerLayout.addView((View)this.mHeader);
        this.mFooterView = new XFooterView(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.gravity = 17;
        LinearLayout footLayout = (LinearLayout)this.mLayout.findViewById(ResourceUtil.getId(context, "footer_layout"));
        footLayout.addView((View)this.mFooterView, (ViewGroup.LayoutParams)params);
        ViewTreeObserver observer = this.mHeader.getViewTreeObserver();
        if (null != observer) {
            observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @TargetApi(value=16)
                public void onGlobalLayout() {
                    XScrollView.this.mHeaderHeight = XScrollView.this.mHeaderContent.getHeight();
                    ViewTreeObserver observer = XScrollView.this.getViewTreeObserver();
                    if (null != observer) {
                        if (Build.VERSION.SDK_INT < 16) {
                            observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
        this.addView((View)this.mLayout);
    }

    public void setContentView(ViewGroup content) {
        if (this.mLayout == null) {
            return;
        }
        if (this.mContentLayout == null) {
            this.mContentLayout = (LinearLayout)this.mLayout.findViewById(ResourceUtil.getId(this.activity, "content_layout"));
        }
        if (this.mContentLayout.getChildCount() > 0) {
            this.mContentLayout.removeAllViews();
        }
        this.mContentLayout.addView((View)content);
    }

    public void setView(View content) {
        if (this.mLayout == null) {
            return;
        }
        if (this.mContentLayout == null) {
            this.mContentLayout = (LinearLayout)this.mLayout.findViewById(ResourceUtil.getId(this.activity, "content_layout"));
        }
        this.mContentLayout.addView(content);
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
        this.mHeaderContent.setVisibility(enable ? 0 : 4);
    }

    public void setPullLoadEnable(boolean enable) {
        this.mEnablePullLoad = enable;
        if (!this.mEnablePullLoad) {
            this.mFooterView.setBottomMargin(0);
            this.mFooterView.hide();
            this.mFooterView.setPadding(0, 0, 0, this.mFooterView.getHeight() * -1);
            this.mFooterView.setOnClickListener(null);
        } else {
            this.mPullLoading = false;
            this.mFooterView.setPadding(0, 0, 0, 0);
            this.mFooterView.show();
            this.mFooterView.setState(0);
            this.mFooterView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XScrollView.this.startLoadMore();
                }
            });
        }
    }

    public void setAutoLoadEnable(boolean enable) {
        this.mEnableAutoLoad = enable;
    }

    public void stopRefresh() {
        if (this.mPullRefreshing) {
            this.mPullRefreshing = false;
            this.resetHeaderHeight();
        }
    }

    public void stopLoadMore() {
        if (this.mPullLoading) {
            this.mPullLoading = false;
            this.mFooterView.setState(0);
        }
    }

    public void setRefreshTime(String time) {
        this.mHeaderTime.setText((CharSequence)time);
    }

    public void setIXScrollViewListener(IXScrollViewListener listener) {
        this.mListener = listener;
    }

    public void autoRefresh() {
        this.mHeader.setVisibleHeight(this.mHeaderHeight);
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeader.getVisibleHeight() > this.mHeaderHeight) {
                this.mHeader.setState(1);
            } else {
                this.mHeader.setState(0);
            }
        }
        this.mPullRefreshing = true;
        this.mHeader.setState(2);
        this.refresh();
    }

    private void invokeOnScrolling() {
        if (this.mScrollListener instanceof OnXScrollListener) {
            OnXScrollListener l = (OnXScrollListener)this.mScrollListener;
            l.onXScrolling((View)this);
        }
    }

    private void updateHeaderHeight(float delta) {
        this.mHeader.setVisibleHeight((int)delta + this.mHeader.getVisibleHeight());
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeader.getVisibleHeight() > this.mHeaderHeight) {
                this.mHeader.setState(1);
            } else {
                this.mHeader.setState(0);
            }
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                XScrollView.this.fullScroll(33);
            }
        });
    }

    private void resetHeaderHeight() {
        int height = this.mHeader.getVisibleHeight();
        if (height == 0) {
            return;
        }
        if (this.mPullRefreshing && height <= this.mHeaderHeight) {
            return;
        }
        int finalHeight = 0;
        if (this.mPullRefreshing && height > this.mHeaderHeight) {
            finalHeight = this.mHeaderHeight;
        }
        this.mScrollBack = 0;
        this.mScroller.startScroll(0, height, 0, finalHeight - height, 400);
        this.invalidate();
    }

    private void updateFooterHeight(float delta) {
        int height = this.mFooterView.getBottomMargin() + (int)delta;
        if (this.mEnablePullLoad && !this.mPullLoading) {
            if (height > 50) {
                this.mFooterView.setState(1);
            } else {
                this.mFooterView.setState(0);
            }
        }
        this.mFooterView.setBottomMargin(height);
        this.post(new Runnable(){

            @Override
            public void run() {
                XScrollView.this.fullScroll(130);
            }
        });
    }

    private void resetFooterHeight() {
        int bottomMargin = this.mFooterView.getBottomMargin();
        if (bottomMargin > 0) {
            this.mScrollBack = 1;
            this.mScroller.startScroll(0, bottomMargin, 0, -bottomMargin, 400);
            this.invalidate();
        }
    }

    private void startLoadMore() {
        if (!this.mPullLoading) {
            this.mPullLoading = true;
            this.mFooterView.setState(2);
            this.loadMore();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.isTop() && (this.mHeader.getVisibleHeight() > 0 || deltaY > 0.0f)) {
                    this.updateHeaderHeight(deltaY / 1.8f);
                    this.invokeOnScrolling();
                    break;
                }
                if (!this.isBottom() || this.mFooterView.getBottomMargin() <= 0 && !(deltaY < 0.0f)) break;
                this.updateFooterHeight(-deltaY / 1.8f);
                break;
            }
            default: {
                this.mLastY = -1.0f;
                this.resetHeaderOrBottom();
            }
        }
        return super.onTouchEvent(ev);
    }

    private void resetHeaderOrBottom() {
        if (this.isTop()) {
            if (this.mEnablePullRefresh && this.mHeader.getVisibleHeight() > this.mHeaderHeight) {
                this.mPullRefreshing = true;
                this.mHeader.setState(2);
                this.refresh();
            }
            this.resetHeaderHeight();
        } else if (this.isBottom()) {
            if (this.mEnablePullLoad && this.mFooterView.getBottomMargin() > 50) {
                this.startLoadMore();
            }
            this.resetFooterHeight();
        }
    }

    private boolean isTop() {
        return this.getScrollY() <= 0 || this.mHeader.getVisibleHeight() > this.mHeaderHeight || this.mContentLayout.getTop() > 0;
    }

    private boolean isBottom() {
        return Math.abs(this.getScrollY() + this.getHeight() - this.computeVerticalScrollRange()) <= 5 || this.getScrollY() > 0 && null != this.mFooterView && this.mFooterView.getBottomMargin() > 0;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScrollBack == 0) {
                this.mHeader.setVisibleHeight(this.mScroller.getCurrY());
            } else {
                this.mFooterView.setBottomMargin(this.mScroller.getCurrY());
            }
            this.postInvalidate();
            this.invokeOnScrolling();
        }
        super.computeScroll();
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mScrollListener = l;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        int diff;
        View view = this.getChildAt(this.getChildCount() - 1);
        if (null != view && (diff = view.getBottom() - (view.getHeight() + view.getScrollY())) == 0 && this.mEnableAutoLoad) {
            this.startLoadMore();
        }
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    private void refresh() {
        if (this.mEnablePullRefresh && null != this.mListener) {
            this.mListener.onRefresh();
        }
    }

    private void loadMore() {
        if (this.mEnablePullLoad && null != this.mListener) {
            this.mListener.onLoadMore();
        }
    }

    public static interface IXScrollViewListener {
        public void onRefresh();

        public void onLoadMore();
    }

    public static interface OnXScrollListener
    extends AbsListView.OnScrollListener {
        public void onXScrolling(View var1);
    }
}

