/*
 * Decompiled with CFR 0.152.
 */
package jxp.android.support.v4.media;

import android.os.SystemClock;
import android.view.KeyEvent;

public abstract class TransportPerformer {
    static final int AUDIOFOCUS_GAIN = 1;
    static final int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    static final int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    static final int AUDIOFOCUS_LOSS = -1;
    static final int AUDIOFOCUS_LOSS_TRANSIENT = -2;
    static final int AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK = -3;

    public abstract void onStart();

    public abstract void onPause();

    public abstract void onStop();

    public abstract long onGetDuration();

    public abstract long onGetCurrentPosition();

    public abstract void onSeekTo(long var1);

    public abstract boolean onIsPlaying();

    public int onGetBufferPercentage() {
        return 100;
    }

    public int onGetTransportControlFlags() {
        return 60;
    }

    public boolean onMediaButtonDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 126: {
                this.onStart();
                return true;
            }
            case 127: {
                this.onPause();
                return true;
            }
            case 86: {
                this.onStop();
                return true;
            }
            case 79: 
            case 85: {
                if (this.onIsPlaying()) {
                    this.onPause();
                    break;
                }
                this.onStart();
            }
        }
        return true;
    }

    public boolean onMediaButtonUp(int keyCode, KeyEvent event) {
        return true;
    }

    public void onAudioFocusChange(int focusChange) {
        int keyCode = 0;
        switch (focusChange) {
            case -1: {
                keyCode = 127;
            }
        }
        if (keyCode != 0) {
            long now = SystemClock.uptimeMillis();
            this.onMediaButtonDown(keyCode, new KeyEvent(now, now, 0, keyCode, 0));
            this.onMediaButtonUp(keyCode, new KeyEvent(now, now, 1, keyCode, 0));
        }
    }
}

