/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.activity;

import android.app.Activity;
import java.util.Stack;
import java.util.Vector;

public class ActivityStackManager {
    public static final String TAG = "ActivityStackManager";
    private static volatile ActivityStackManager sInstance;
    private Stack<Activity> mActivityStack;

    private ActivityStackManager() {
        Stack stack;
        Stack stack2 = stack;
        stack = new Stack();
        v1.mActivityStack = stack2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityStackManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<ActivityStackManager> clazz = ActivityStackManager.class;
        synchronized (ActivityStackManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ActivityStackManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void addActivity(Activity activity) {
        this.mActivityStack.add(activity);
    }

    public void removeActivity(Activity activity) {
        if (activity != null && this.mActivityStack.contains(activity)) {
            this.mActivityStack.remove(activity);
        }
    }

    public Activity getCurrentActivity() {
        Stack<Activity> stack = this.mActivityStack;
        if (stack != null && !stack.isEmpty()) {
            return (Activity)this.mActivityStack.lastElement();
        }
        return null;
    }

    public Activity getActivity(Class<?> clazz) {
        Object object = ((ActivityStackManager)object).mActivityStack;
        if (object != null) {
            object = ((Vector)object).iterator();
            while (object.hasNext()) {
                Activity activity = (Activity)object.next();
                if (!activity.getClass().equals(clazz)) continue;
                return activity;
            }
        }
        return null;
    }

    public void finishCurrentActivity() {
        ((Activity)this.mActivityStack.lastElement()).finish();
    }

    public void finishPreActivity() {
        Stack<Activity> stack = activityStackManager.mActivityStack;
        if (stack != null && stack.size() > 1) {
            Stack<Activity> stack2 = activityStackManager.mActivityStack;
            ActivityStackManager activityStackManager = (Activity)stack2.get(stack2.size() - 2);
            if (activityStackManager != null && !activityStackManager.isFinishing()) {
                activityStackManager.finish();
            }
        }
    }

    public void finishActivity(Activity activity) {
        if (activity != null && this.mActivityStack.contains(activity)) {
            this.mActivityStack.remove(activity);
            activity.finish();
        }
    }

    public void finishActivity(Class<?> clazz) {
        Stack<Activity> stack = this.mActivityStack;
        if (stack != null) {
            for (Activity activity : stack) {
                if (!activity.getClass().equals(clazz)) continue;
                this.finishActivity(activity);
            }
        }
    }

    public void finishAllActivity() {
        for (Activity activity : this.mActivityStack) {
            if (activity.isFinishing()) continue;
            activity.finish();
        }
        this.mActivityStack.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAboveActivities(Class clazz) {
        Activity activity = null;
        while (true) {
            Activity activity2;
            block7: {
                if (this.mActivityStack.size() <= 0) break;
                activity2 = this.mActivityStack.pop();
                if (activity2.getClass().equals(clazz)) break block7;
                activity2.finish();
                activity2 = activity;
            }
            activity = activity2;
        }
        if (activity == null) return;
        try {
            this.mActivityStack.add(activity);
        }
        catch (Exception exception) {}
        return;
    }

    public int getAliveActivities() {
        return this.mActivityStack.size();
    }
}

