/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.util.ResourceUtil;

public class DouYouRefreshListView
extends ListView
implements AbsListView.OnScrollListener {
    View HeaderView;
    View FooterView;
    int StarY;
    int headerHerght;
    int footerHeight;
    public static final int STAR_PULL_REFRESH = 0;
    public static final int STAR_RELESE_REFRESH = 1;
    public static final int STAR_REFRESING = 2;
    public static final int STAR_DOWN_REFRESH = 0;
    public static final int STAR_DOWN_RELESE_REFRESH = 1;
    public static final int STAR_LOADING = 2;
    private int mCurrState = 0;
    private int mCurrState2 = 0;
    TextView headerText;
    TextView footerText;
    ImageView pullImage;
    ImageView footerImage;
    ProgressBar progress;
    ProgressBar footerprogress;
    boolean ismath = false;
    boolean isCloseMoreLod = true;
    RotateAnimation rotateUp;
    RotateAnimation rotateDown;
    private onRefreshListener onRefreshListener;
    boolean isLoadingMore = false;

    public DouYouRefreshListView(Context context) {
        super(context);
        this.initHeader();
        this.initFooter();
    }

    public DouYouRefreshListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initHeader();
        this.initFooter();
    }

    public DouYouRefreshListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initHeader();
        this.initFooter();
    }

    private void initHeader() {
        this.HeaderView = View.inflate((Context)this.getContext(), (int)ResourceUtil.getLayoutId((Context)DouYou.getInstance().context, "douyou_refresh_list_headeview"), null);
        this.addHeaderView(this.HeaderView);
        this.headerText = (TextView)this.HeaderView.findViewById(ResourceUtil.getId((Context)DouYou.getInstance().context, "headerText"));
        this.pullImage = (ImageView)this.HeaderView.findViewById(ResourceUtil.getId((Context)DouYou.getInstance().context, "pullImage"));
        this.progress = (ProgressBar)this.HeaderView.findViewById(ResourceUtil.getId((Context)DouYou.getInstance().context, "progress"));
        this.HeaderView.measure(0, 0);
        this.headerHerght = this.HeaderView.getMeasuredHeight();
        this.initAnim();
        this.HeaderView.setPadding(0, -this.headerHerght, 0, 0);
    }

    private void initFooter() {
        this.FooterView = View.inflate((Context)this.getContext(), (int)ResourceUtil.getLayoutId((Context)DouYou.getInstance().context, "douyou_refresh_list_footerview"), null);
        this.addFooterView(this.FooterView);
        this.footerText = (TextView)this.FooterView.findViewById(ResourceUtil.getId((Context)DouYou.getInstance().context, "headerText"));
        this.footerImage = (ImageView)this.FooterView.findViewById(ResourceUtil.getId((Context)DouYou.getInstance().context, "pullImage"));
        this.footerprogress = (ProgressBar)this.FooterView.findViewById(ResourceUtil.getId((Context)DouYou.getInstance().context, "progress"));
        this.FooterView.measure(0, 0);
        this.footerHeight = this.FooterView.getMeasuredHeight();
        this.FooterView.setPadding(0, -this.footerHeight, 0, 0);
        this.setOnScrollListener(this);
    }

    public void isOpenMoreLoading(boolean isCloseMoreLoding) {
        this.isCloseMoreLod = isCloseMoreLoding;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                Log.e((String)"000000", (String)("ACTION_DOWN==" + ev.getRawY()));
                this.StarY = (int)ev.getRawY();
                break;
            }
            case 1: {
                Log.e((String)"000000", (String)("ACTION_UP==" + ev.getRawY()));
                this.StarY = -1;
                if (this.isLoadingMore) {
                    if (this.mCurrState2 == 1) {
                        this.mCurrState2 = 2;
                        this.getRefreshDownstate();
                        this.FooterView.setPadding(0, 0, 0, 0);
                    } else if (this.mCurrState2 == 0) {
                        this.FooterView.setPadding(0, 0, 0, -this.footerHeight);
                    }
                    this.isLoadingMore = false;
                    break;
                }
                if (this.mCurrState == 1) {
                    this.mCurrState = 2;
                    this.ReFreshState();
                    this.HeaderView.setPadding(0, 0, 0, 0);
                    break;
                }
                if (this.mCurrState != 0) break;
                this.HeaderView.setPadding(0, -this.headerHerght, 0, 0);
                break;
            }
            case 2: {
                int endY;
                int des;
                Log.e((String)"000000", (String)("ACTION_MOVE==" + ev.getRawY()));
                if (this.isLoadingMore) {
                    int endY2;
                    int des2;
                    if (this.StarY == -1) {
                        this.StarY = (int)ev.getRawY();
                    }
                    if ((des2 = Math.abs((endY2 = (int)ev.getRawY()) - this.StarY)) <= 10 || this.getLastVisiblePosition() != this.getCount() - 1) break;
                    int padding = des2 - this.footerHeight;
                    this.FooterView.setPadding(0, 0, 0, padding);
                    if (padding > 0 && this.mCurrState2 == 0) {
                        this.mCurrState2 = 1;
                        this.getRefreshDownstate();
                        break;
                    }
                    if (padding >= 0 || this.mCurrState2 == 0) break;
                    this.mCurrState2 = 2;
                    this.getRefreshDownstate();
                    break;
                }
                if (this.StarY == -1) {
                    this.StarY = (int)ev.getRawY();
                }
                if ((des = (endY = (int)ev.getRawY()) - this.StarY) <= 10 || this.getFirstVisiblePosition() != 0) break;
                int padding = des - this.headerHerght;
                this.HeaderView.setPadding(0, padding, 0, 0);
                if (padding > 0 && this.mCurrState == 0) {
                    this.mCurrState = 1;
                    this.ReFreshState();
                    break;
                }
                if (padding >= 0 || this.mCurrState == 0) break;
                this.mCurrState = 0;
                this.ReFreshState();
            }
        }
        return super.onTouchEvent(ev);
    }

    private void ReFreshState() {
        switch (this.mCurrState) {
            case 0: {
                this.headerText.setText((CharSequence)"\u4e0b\u62c9\u5237\u65b0");
                this.pullImage.setVisibility(0);
                this.progress.setVisibility(8);
                this.pullImage.startAnimation((Animation)this.rotateUp);
                break;
            }
            case 2: {
                this.headerText.setText((CharSequence)"\u6b63\u5728\u5237\u65b0");
                this.pullImage.setVisibility(8);
                this.progress.setVisibility(0);
                this.pullImage.clearAnimation();
                if (this.onRefreshListener == null) break;
                this.onRefreshListener.refresh();
                break;
            }
            case 1: {
                this.headerText.setText((CharSequence)"\u677e\u5f00\u5237\u65b0");
                this.pullImage.setVisibility(0);
                this.progress.setVisibility(8);
                this.pullImage.startAnimation((Animation)this.rotateDown);
            }
        }
    }

    private void getRefreshDownstate() {
        switch (this.mCurrState2) {
            case 0: {
                this.headerText.setText((CharSequence)"\u4e0a\u5566\u52a0\u8f7d\u66f4\u591a");
                this.pullImage.setVisibility(0);
                this.progress.setVisibility(8);
                this.pullImage.startAnimation((Animation)this.rotateUp);
                break;
            }
            case 2: {
                this.footerText.setText((CharSequence)"\u6b63\u5728\u52a0\u8f7d\u4e2d...");
                this.footerImage.setVisibility(8);
                this.footerprogress.setVisibility(0);
                this.footerImage.clearAnimation();
                if (this.onRefreshListener == null) break;
                this.onRefreshListener.loadingMore();
                break;
            }
            case 1: {
                this.footerText.setText((CharSequence)"\u677e\u5f00\u52a0\u8f7d\u66f4\u591a...");
                this.footerImage.setVisibility(0);
                this.footerprogress.setVisibility(8);
                this.footerImage.startAnimation((Animation)this.rotateDown);
            }
        }
    }

    private void initAnim() {
        this.rotateUp = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.rotateUp.setDuration(500L);
        this.rotateUp.setFillAfter(true);
        this.rotateDown = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.rotateDown.setDuration(500L);
        this.rotateDown.setFillAfter(true);
    }

    public void setOnRefreshComplete() {
        if (this.isLoadingMore) {
            this.mCurrState2 = 0;
            this.footerText.setText((CharSequence)"\u4e0a\u5566\u52a0\u8f7d\u66f4\u591a");
            this.footerImage.setVisibility(8);
            this.footerImage.setVisibility(8);
            this.FooterView.setPadding(0, 0, 0, -this.footerHeight);
            this.isLoadingMore = false;
        } else {
            this.mCurrState = 0;
            this.headerText.setText((CharSequence)"\u4e0b\u5566\u5237\u65b0");
            this.pullImage.setVisibility(8);
            this.progress.setVisibility(8);
            this.HeaderView.setPadding(0, -this.headerHerght, 0, 0);
        }
    }

    public void setonRefreshListener(onRefreshListener listener) {
        this.onRefreshListener = listener;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (!(scrollState != 0 && scrollState != 2 || this.getLastVisiblePosition() != this.getCount() - 1 || this.isLoadingMore)) {
            Log.e((String)"yyyy", (String)("gaodu=" + this.getHeight()));
            this.isLoadingMore = this.ismath;
            Log.e((String)"iii", (String)("isLoadingMore=" + this.isLoadingMore));
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        Log.e((String)"yyyy", (String)("gaodu222=" + this.getHeight()));
        this.ismath = totalItemCount > visibleItemCount ? this.isCloseMoreLod : false;
    }

    public static interface onRefreshListener {
        public void refresh();

        public void loadingMore();
    }
}

