/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.convert.hume.readapk.signaturev1;

import java.io.DataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class V1SchemeUtil {
    static final byte[] V1_MAGIC = new byte[]{108, 116, 108, 111, 118, 101, 122, 104};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readChannel(File file) {
        RandomAccessFile raf = null;
        String var7 = null;
        try {
            raf = new RandomAccessFile(file, "r");
            long index = raf.length();
            byte[] buffer = new byte[V1_MAGIC.length];
            raf.seek(index -= (long)V1_MAGIC.length);
            raf.readFully(buffer);
            if (!V1SchemeUtil.isV1MagicMatch(buffer)) {
                String string = "";
                return string;
            }
            raf.seek(index -= 2L);
            short length = V1SchemeUtil.readShort(raf);
            if (length <= 0) {
                String e = "";
                return e;
            }
            raf.seek(index -= (long)length);
            byte[] bytesComment = new byte[length];
            raf.readFully(bytesComment);
            var7 = new String(bytesComment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return var7;
    }

    private static short readShort(DataInput input) throws IOException {
        byte[] buf = new byte[2];
        input.readFully(buf);
        ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        return bb.getShort(0);
    }

    private static boolean isV1MagicMatch(byte[] buffer) {
        if (buffer.length != V1_MAGIC.length) {
            return false;
        }
        for (int i = 0; i < V1_MAGIC.length; ++i) {
            if (buffer[i] == V1_MAGIC[i]) continue;
            return false;
        }
        return true;
    }
}

