/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.log;

import android.util.Log;
import com.bytedance.applog.log.LogInfo;
import com.bytedance.applog.log.LoggerImpl;
import java.util.List;

public class NativeLoggerImpl
extends LoggerImpl {
    private String tag = "NativeLoggerImpl";

    public NativeLoggerImpl() {
    }

    public NativeLoggerImpl(String tag) {
        this.tag = tag;
    }

    @Override
    protected void process(int category, int level, List<String> tags, Throwable throwable, String message, Object ... args) {
        LogInfo log = LogInfo.builder().category(category).level(level).thread(Thread.currentThread().getName()).throwable(throwable).tags(this.getTags(tags)).message(this.format(message, args)).build();
        switch (log.getLevel()) {
            case 0: {
                Log.v((String)this.tag, (String)log.toMessage(), (Throwable)log.getThrowable());
                break;
            }
            case 2: {
                Log.i((String)this.tag, (String)log.toMessage(), (Throwable)log.getThrowable());
                break;
            }
            case 3: {
                Log.w((String)this.tag, (String)log.toMessage(), (Throwable)log.getThrowable());
                break;
            }
            case 4: 
            case 5: {
                Log.e((String)this.tag, (String)log.toMessage(), (Throwable)log.getThrowable());
                break;
            }
            default: {
                Log.d((String)this.tag, (String)log.toMessage(), (Throwable)log.getThrowable());
            }
        }
    }
}

