/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.convert.hume.readapk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import com.bytedance.applog.convert.hume.readapk.PayloadReader;
import com.bytedance.applog.convert.hume.readapk.signaturev1.V1SchemeUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HumeSDK {
    public static final String TAG = "HumeSDK";
    private static final int APK_TRACE_BLOCK_ID = 0x71777778;
    private static final int APK_OUTER_BLOCK_ID = -1721342362;
    private static final int APK_INNER_BLOCK_ID = 0x71777777;
    private static String[] mApkInfos = new String[3];
    private static volatile boolean mIsInit = false;

    public static String getChannel(Context context) {
        Map<String, String> map;
        if (!mIsInit) {
            HumeSDK.initApkInfo(context);
            mIsInit = true;
        }
        if ((map = HumeSDK.getMap(HumeSDK.getExtra(context))) != null && map.size() > 0) {
            return map.get("hume_channel_id");
        }
        return "";
    }

    public static String getExtra(Context context) {
        if (!mIsInit) {
            HumeSDK.initApkInfo(context);
            mIsInit = true;
        }
        if (!TextUtils.isEmpty((CharSequence)mApkInfos[0])) {
            return mApkInfos[0];
        }
        if (!TextUtils.isEmpty((CharSequence)mApkInfos[1])) {
            return mApkInfos[1];
        }
        return "";
    }

    private static Map<String, String> getTraceInfo(Context context) {
        HashMap map;
        if (!mIsInit) {
            HumeSDK.initApkInfo(context);
            mIsInit = true;
        }
        return (map = HumeSDK.getMap(mApkInfos[2])) == null ? new HashMap() : map;
    }

    private static void initApkInfo(Context context) {
        File apkFile;
        String[] infoArray;
        int[] blockIds = new int[]{-1721342362, 0x71777777, 0x71777778};
        String apkPath = HumeSDK.getApkPath(context);
        if (TextUtils.isEmpty((CharSequence)apkPath)) {
            mApkInfos = new String[]{"", "", ""};
        }
        String[] stringArray = mApkInfos = (infoArray = PayloadReader.getString(apkFile = new File(apkPath), blockIds)) != null ? infoArray : mApkInfos;
        if (mApkInfos.length >= 2 && TextUtils.isEmpty((CharSequence)mApkInfos[0]) && TextUtils.isEmpty((CharSequence)mApkInfos[1])) {
            String v1Str = V1SchemeUtil.readChannel(apkFile);
            String string = HumeSDK.mApkInfos[0] = v1Str == null ? "" : v1Str;
        }
        if (mApkInfos.length >= 3 && !TextUtils.isEmpty((CharSequence)mApkInfos[2])) {
            int traceLen = mApkInfos[2].length();
            HumeSDK.mApkInfos[2] = traceLen > 4 ? mApkInfos[2].substring(2, traceLen - 2) : "";
        }
    }

    private static String getApkPath(Context context) {
        String apkPath = null;
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            if (applicationInfo == null) {
                return null;
            }
            apkPath = applicationInfo.sourceDir;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return apkPath;
    }

    private static Map<String, String> getMap(String apkInfo) {
        if (TextUtils.isEmpty((CharSequence)apkInfo)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(apkInfo);
            Iterator keys = jsonObject.keys();
            HashMap<String, String> result = new HashMap<String, String>();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                result.put(key, jsonObject.getString(key));
            }
            return result;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

