/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.convert.hume.readapk;

import com.bytedance.applog.convert.hume.readapk.ApkUtil;
import com.bytedance.applog.convert.hume.readapk.SignatureNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Map;

public final class PayloadReader {
    private PayloadReader() {
    }

    public static String[] getString(File apkFile, int[] ids) {
        byte[][] bytes = PayloadReader.get(apkFile, ids);
        if (bytes == null) {
            return null;
        }
        String[] res = new String[ids.length];
        try {
            for (int i = 0; i < ids.length; ++i) {
                res[i] = bytes[i] != null ? new String(bytes[i], "UTF-8") : "";
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static byte[][] get(File apkFile, int[] ids) {
        Map<Integer, ByteBuffer> idValues = PayloadReader.getAll(apkFile);
        if (idValues == null || ids.length <= 0) {
            return null;
        }
        byte[][] bytes = new byte[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            ByteBuffer byteBuffer = idValues.get(ids[i]);
            if (byteBuffer == null) continue;
            bytes[i] = PayloadReader.getBytes(byteBuffer);
        }
        return bytes;
    }

    private static byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] array = byteBuffer.array();
        int arrayOffset = byteBuffer.arrayOffset();
        return Arrays.copyOfRange(array, arrayOffset + byteBuffer.position(), arrayOffset + byteBuffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, ByteBuffer> getAll(File apkFile) {
        Map<Integer, ByteBuffer> idValues = null;
        try {
            RandomAccessFile randomAccessFile = null;
            AbstractInterruptibleChannel fileChannel = null;
            try {
                randomAccessFile = new RandomAccessFile(apkFile, "r");
                fileChannel = randomAccessFile.getChannel();
                ByteBuffer apkSigningBlock2 = ApkUtil.findApkSigningBlock((FileChannel)fileChannel).getFirst();
                idValues = ApkUtil.findIdValues(apkSigningBlock2);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            // empty catch block
        }
        return idValues;
    }
}

