/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Process;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.bytedance.applog.ISensitiveInfoProvider;
import com.bytedance.applog.Level;
import com.bytedance.applog.log.LoggerImpl;
import com.bytedance.bdtracker.a;
import com.bytedance.bdtracker.g4;
import com.bytedance.bdtracker.l0;
import com.bytedance.bdtracker.p3;
import com.bytedance.bdtracker.r3;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SensitiveUtils {
    public static final List<String> a = Collections.singletonList("SensitiveUtils");
    public static final String CHANNEL_APP_KEY = "UMENG_APPKEY";
    public static final String KEY_MAC = "mac_address";
    public static final String KEY_MC = "mc";
    public static final String KEY_BUILD_SERIAL = "build_serial";
    public static final String KEY_ALIYUN_UUID = "aliyun_uuid";

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getDeviceId(final Context context) {
        g4 g42;
        if (context == null) {
            return null;
        }
        try {
            g42 = g4.a(context);
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{};
            LoggerImpl.global().error(a, "Get device id failed", throwable, objectArray);
            return null;
        }
        return g42.a("TelephonyManager.getDeviceId", new g4.a(){

            @Override
            public String a() {
                if (SensitiveUtils.hasReadPhoneStatePermission(object.context)) {
                    block5: {
                        Object object;
                        block4: {
                            LoggerImpl.global().debug(a, "[DeviceMeta&READ_PHONE_STATE] Try to get device id.", new Object[0]);
                            object = (TelephonyManager)object.context.getSystemService("phone");
                            if (object != null) break block4;
                            object = "";
                            break block5;
                        }
                        try {
                            object = object.getDeviceId();
                        }
                        catch (Throwable throwable) {
                            Object[] objectArray = new Object[]{};
                            LoggerImpl.global().error(a, "Get device id failed", throwable, objectArray);
                        }
                    }
                    return object;
                }
                return null;
            }
        });
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String[] getSimSerialNumbers(Context object) {
        block6: {
            if (object == null) {
                return new String[0];
            }
            g4 g42 = g4.a((Context)object);
            object = g42.a("SubscriptionInfo.getIccid", new g4.a((Context)object){
                public final /* synthetic */ Context a;
                {
                    this.a = context;
                }

                /*
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public String a() {
                    block12: {
                        var1_4 = null;
                        if (Build.VERSION.SDK_INT < 22) ** GOTO lbl21
                        if (!SensitiveUtils.hasReadPhoneStatePermission(this.a)) break block12;
                        v0 = SubscriptionManager.from((Context)this.a);
                        try {
                            LoggerImpl.global().debug(SensitiveUtils.a, "[DeviceMeta&READ_PHONE_STATE] Try to get active subscription info list.", new Object[0]);
                            this = v0.getActiveSubscriptionInfoList();
                            if (this == null) return null;
                            if (this.isEmpty()) {
                                return null;
                            }
                            var1_4 = new String[this.size()];
                            for (var2_5 = 0; var2_5 < this.size(); ++var2_5) {
                                var1_4[var2_5] = ((SubscriptionInfo)this.get(var2_5)).getIccId();
                            }
                        }
                        catch (Throwable var0_1) {
                            block13: {
                                LoggerImpl.global().error(SensitiveUtils.a, "Get iccid failed", var0_1, new Object[0]);
lbl21:
                                // 1 sources

                                var1_4 = new String[1];
                                if (!SensitiveUtils.hasReadPhoneStatePermission(this.a)) break block12;
                                LoggerImpl.global().debug(SensitiveUtils.a, "[DeviceMeta&READ_PHONE_STATE] Try to get sim serial number.", new Object[0]);
                                this = (TelephonyManager)this.a.getSystemService("phone");
                                var2_6 = 0;
                                if (this != null) break block13;
                                this = "";
                                ** GOTO lbl32
                            }
                            try {
                                this = this.getSimSerialNumber();
lbl32:
                                // 2 sources

                                var1_4[var2_6] = this;
                            }
                            catch (Throwable var0_2) {
                                try {
                                    LoggerImpl.global().error(SensitiveUtils.a, "Get sim serial number failed", var0_2, new Object[0]);
                                }
                                catch (Throwable var0_3) {
                                    var2_7 = new Object[]{};
                                    LoggerImpl.global().error(SensitiveUtils.a, "Get accId failed", var0_3, var2_7);
                                }
                            }
                        }
                    }
                    if (var1_4 == null) {
                        return null;
                    }
                    v1 = TextUtils.join((CharSequence)",", (Object[])var1_4);
                    return v1;
                }
            });
            if (TextUtils.isEmpty((CharSequence)object)) break block6;
            try {
                return ((String)object).split(",");
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[]{};
                LoggerImpl.global().error(a, "getSimSerialNumbers failed", throwable, objectArray);
            }
        }
        return new String[0];
    }

    public static String getMacAddress(ISensitiveInfoProvider iSensitiveInfoProvider, Context context) {
        if (iSensitiveInfoProvider != null) {
            return iSensitiveInfoProvider.getMac();
        }
        return SensitiveUtils.getMacAddressFromSystem(context);
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getMacAddressFromSystem(Context context) {
        String string;
        block8: {
            string = null;
            g4 g42 = g4.a(context);
            try {
                string = g42.a("NetworkInterface.getHardwareAddress", new g4.a(){

                    @Override
                    public String a() {
                        if (Build.VERSION.SDK_INT >= 23) {
                            Object object = NetworkInterface.getNetworkInterfaces();
                            while (object != null && object.hasMoreElements()) {
                                StringBuilder stringBuilder;
                                Object object2 = (NetworkInterface)object.nextElement();
                                if (!"wlan0".equals(((NetworkInterface)object2).getName())) continue;
                                LoggerImpl.global().debug(a, com.bytedance.bdtracker.a.a("[DeviceMeta] Try to get hardware address from ").append(((NetworkInterface)object2).getName()).append(".").toString(), new Object[0]);
                                byte[] byArray = ((NetworkInterface)object2).getHardwareAddress();
                                object2 = byArray;
                                if (byArray == null || ((Object)object2).length <= 0) continue;
                                object = stringBuilder;
                                stringBuilder = new StringBuilder();
                                for (Object object3 : object2) {
                                    Object[] objectArray = new Object[1];
                                    Object[] objectArray2 = objectArray;
                                    objectArray[0] = (byte)object3;
                                    ((StringBuilder)object).append(String.format("%02X:", objectArray2));
                                }
                                if (((StringBuilder)object).length() > 0) {
                                    Object object4 = object;
                                    ((StringBuilder)object4).deleteCharAt(((StringBuilder)object4).length() - 1);
                                }
                                return ((StringBuilder)object).toString();
                            }
                        }
                        return "";
                    }
                });
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[]{};
                LoggerImpl.global().error(a, "Get HardwareAddress failed", throwable, objectArray);
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                context = (WifiManager)context.getSystemService("wifi");
                if (context == null) break block8;
                if (context.getConnectionInfo() == null) break block8;
                try {
                    string = context.getConnectionInfo().getMacAddress();
                }
                catch (Throwable throwable) {
                    Object[] objectArray = new Object[]{};
                    LoggerImpl.global().error(a, "Get MacAddress failed", throwable, objectArray);
                }
            }
        }
        return string;
    }

    @SuppressLint(value={"MissingPermission"})
    public static JSONArray getMultiImeiFromSystem(Context object) {
        Object[] objectArray;
        block9: {
            Object[] objectArray2;
            block8: {
                JSONArray jSONArray;
                g4 g42;
                try {
                    g42 = g4.a(object);
                }
                catch (Throwable throwable) {
                    objectArray = new Object[]{};
                    LoggerImpl.global().error(a, "Failed to get meid 0", throwable, objectArray);
                    return null;
                }
                object = g42.a("TelephonyManager.getMultiImei", new g4.a((Context)object){
                    public final /* synthetic */ Context a;
                    {
                        this.a = context;
                    }

                    @Override
                    public String a() {
                        block11: {
                            JSONArray jSONArray;
                            if (Build.VERSION.SDK_INT < 26 || !SensitiveUtils.hasReadPhoneStatePermission(this.a)) break block11;
                            d d6 = this;
                            LoggerImpl.global().debug(a, "[DeviceMeta&READ_PHONE_STATE] Try to get imei and meid info", new Object[0]);
                            int n6 = SubscriptionManager.from((Context)d6.a).getActiveSubscriptionInfoCount();
                            JSONArray jSONArray2 = jSONArray;
                            jSONArray = new JSONArray();
                            TelephonyManager telephonyManager = (TelephonyManager)d6.a.getSystemService("phone");
                            for (int i6 = 0; i6 < n6; ++i6) {
                                String string;
                                if (telephonyManager == null) {
                                    string = "";
                                } else {
                                    string = telephonyManager.getMeid(i6);
                                }
                                try {
                                    jSONArray2.put((Object)SensitiveUtils.a(string, i6, "meid"));
                                }
                                catch (Throwable throwable) {}
                                if (telephonyManager == null) {
                                    string = "";
                                } else {
                                    string = telephonyManager.getImei(i6);
                                }
                                try {
                                    jSONArray2.put((Object)SensitiveUtils.a(string, i6, "imei"));
                                }
                                catch (Throwable throwable) {}
                            }
                            return jSONArray2.toString();
                        }
                        return null;
                    }
                });
                if (!TextUtils.isEmpty((CharSequence)object)) break block8;
                object = jSONArray;
                jSONArray = new JSONArray();
                objectArray = object;
                break block9;
            }
            objectArray = objectArray2;
            objectArray2 = new JSONArray((String)object);
        }
        return objectArray;
    }

    public static JSONArray getMultiImeiFallback(Context context) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray2();
        jSONArray2.put((Object)SensitiveUtils.a(SensitiveUtils.a(context, 0), 0, "unknown"));
        jSONArray.put((Object)SensitiveUtils.a(SensitiveUtils.a(context, 1), 1, "unknown"));
        return jSONArray;
    }

    public static boolean validMultiImei(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                return SensitiveUtils.validMultiImei(new JSONArray(string));
            }
            catch (JSONException jSONException) {
                Object[] objectArray = new Object[]{};
                LoggerImpl.global().error(a, "JSON handle failed", (Throwable)jSONException, objectArray);
            }
        }
        return false;
    }

    public static boolean validMultiImei(@Nullable JSONArray jSONArray) {
        int n6;
        boolean bl = false;
        if (jSONArray != null && (n6 = jSONArray.length()) > 0) {
            for (int i6 = 0; i6 < n6; ++i6) {
                JSONObject jSONObject = jSONArray.optJSONObject(i6);
                if (jSONObject == null || TextUtils.isEmpty((CharSequence)jSONObject.optString("id"))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static JSONObject a(String string, int n6, String string2) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            JSONObject jSONObject3 = jSONObject2;
            jSONObject3.put("id", (Object)string);
            jSONObject3.put("slot_index", n6);
            jSONObject3.put("type", (Object)string2);
        }
        return jSONObject2;
    }

    public static Class[] a(String string) {
        Class<?>[] classArray = null;
        Method[] methodArray = TelephonyManager.class.getDeclaredMethods();
        int n6 = methodArray.length;
        for (int i6 = 0; i6 < n6; ++i6) {
            String string2 = string;
            Method method = methodArray[i6];
            if (!string2.equals(method.getName())) continue;
            classArray = method.getParameterTypes();
            if (classArray.length < 1) continue;
            try {
                LoggerImpl.global().debug(a, "params length:" + classArray.length, new Object[0]);
                break;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                LoggerImpl.global().error(a, "TelephonyManager reflect method:{} failed", (Throwable)exception, objectArray2);
                break;
            }
        }
        return classArray;
    }

    @Nullable
    public static String a(Context object, int n6) {
        if (SensitiveUtils.hasReadPhoneStatePermission((Context)object)) {
            Object object2;
            block7: {
                Context context = object;
                LoggerImpl.global().debug(a, "[READ_PHONE_STATE] Try to get device id.", new Object[0]);
                object = "getDeviceId";
                object2 = null;
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager == null) break block7;
                if (Build.VERSION.SDK_INT < 21) break block7;
                Object object3 = object;
                object = telephonyManager.getClass().getMethod((String)object3, SensitiveUtils.a((String)object3));
                if (n6 < 0) break block7;
                Object object4 = object;
                TelephonyManager telephonyManager2 = telephonyManager;
                Object[] objectArray = new Object[1];
                try {
                    objectArray[0] = n6;
                    object2 = ((Method)object4).invoke((Object)telephonyManager2, objectArray);
                }
                catch (Throwable throwable) {
                    Object[] objectArray2 = new Object[]{};
                    LoggerImpl.global().error(a, "Read phone info failed.", throwable, objectArray2);
                }
            }
            return (String)object2;
        }
        return null;
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getSerialNumber(final Context context) {
        if (context == null) {
            return null;
        }
        String string = null;
        g4 g42 = g4.a(context);
        try {
            string = g42.a("Build.getSerial", new g4.a(){

                @Override
                public String a() {
                    if (Build.VERSION.SDK_INT >= 26 && context.getApplicationInfo().targetSdkVersion >= 26 && SensitiveUtils.hasReadPhoneStatePermission(context)) {
                        LoggerImpl.global().debug(a, "[DeviceMeta&READ_PHONE_STATE] Try to get build serial.", new Object[0]);
                        return Build.getSerial();
                    }
                    return "";
                }
            });
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{};
            LoggerImpl.global().error(a, "Build getSerial failed.", throwable, objectArray);
        }
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.equals((CharSequence)string, (CharSequence)"unknown")) {
            string = Build.SERIAL;
        }
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.equals((CharSequence)string, (CharSequence)"unknown")) {
            return string;
        }
        return "";
    }

    public static void appendSensitiveParams(r3 object, JSONObject jSONObject, Map<String, String> map, boolean bl, Level object2) {
        if (object2 == Level.L0) {
            String string;
            if (bl) {
                String string2 = ((r3)object).a(jSONObject, KEY_MC, null, String.class);
                object2 = ((r3)object).a(jSONObject, "udid", null, String.class);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    map.put(KEY_MAC, string2);
                }
                if (l0.b.a((String)object2)) {
                    map.put("uuid", (String)object2);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(string = ((r3)object).a(jSONObject, KEY_ALIYUN_UUID, null, String.class)))) {
                map.put(KEY_ALIYUN_UUID, string);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(object = ((r3)object).a(jSONObject, KEY_BUILD_SERIAL, null, String.class)))) {
            map.put(KEY_BUILD_SERIAL, (String)object);
        }
    }

    public static void addSensitiveParamsForUrlQuery(r3 r32, StringBuilder objectArray, JSONObject object) {
        p3.a((StringBuilder)objectArray, KEY_BUILD_SERIAL, r32.a((JSONObject)object, KEY_BUILD_SERIAL, null, String.class));
        r32 = r32.a((JSONObject)object, "sim_serial_number", null, JSONArray.class);
        if (r32 != null && r32.length() > 0) {
            StringBuilder stringBuilder;
            object = stringBuilder;
            stringBuilder = new StringBuilder(((JSONObject)r32.get(0)).optString("sim_serial_number"));
            int n6 = 1;
            while (true) {
                if (n6 >= r32.length()) break;
                Object object2 = object;
                String string = ((JSONObject)r32.get(n6)).optString("sim_serial_number");
                ((StringBuilder)object2).append(",").append(string);
                ++n6;
            }
            try {
                p3.a((StringBuilder)objectArray, "sim_serial_number", ((StringBuilder)object).toString());
            }
            catch (JSONException jSONException) {
                objectArray = new Object[]{};
                LoggerImpl.global().error(a, "failed to get sim_serial_number", (Throwable)jSONException, objectArray);
            }
        }
    }

    public static boolean hasReadPhoneStatePermission(Context context) {
        if (Build.VERSION.SDK_INT > 28) {
            return SensitiveUtils.hasPermission(context, "android.permission.READ_PRECISE_PHONE_STATE");
        }
        return SensitiveUtils.hasPermission(context, "android.permission.READ_PHONE_STATE");
    }

    public static boolean hasPermission(Context context, String objectArray) {
        if (objectArray == null) {
            return false;
        }
        try {
            return context.checkPermission((String)objectArray, Process.myPid(), Process.myUid()) == 0;
        }
        catch (Throwable throwable) {
            objectArray = new Object[]{};
            LoggerImpl.global().error(a, "check has permission failed.", throwable, objectArray);
            return false;
        }
    }
}

