/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.bridge;

import com.tds.common.bridge.IBridgeService;
import com.tds.common.bridge.annotation.BridgeService;
import com.tds.common.bridge.exception.EngineBridgeException;
import com.tds.common.bridge.exception.EngineBridgeExceptionStatus;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum BridgeHolder {
    INSTANCE;

    private Map<Class<? extends IBridgeService>, IBridgeService> serviceMap = new ConcurrentHashMap<Class<? extends IBridgeService>, IBridgeService>();

    public void register(Class<? extends IBridgeService> clz, IBridgeService service) {
        this.serviceMap.put(clz, service);
    }

    public Map.Entry<Class<? extends IBridgeService>, IBridgeService> getBridgeService(String service) {
        for (Map.Entry<Class<? extends IBridgeService>, IBridgeService> entry : this.serviceMap.entrySet()) {
            BridgeService bridgeService = entry.getKey().getAnnotation(BridgeService.class);
            if (bridgeService == null || !service.equals(bridgeService.value())) continue;
            return entry;
        }
        throw new EngineBridgeException(EngineBridgeExceptionStatus.COMMAND_SERVICE_ERROR.getMessage());
    }
}

