/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.browser;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tds.common.browser.WebFileCache;
import com.tds.common.io.IoUtil;
import com.tds.common.net.util.HttpUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class CachedWebView
extends WebView {
    public static final int PRELOAD_STATE_UNDEFINED = 0;
    public static final int PRELOAD_STATE_STARTED = 1;
    public static final int PRELOAD_STATE_COMPLETED = 2;
    public static final int PRELOAD_STATE_ERROR = 3;
    private int preloadState = 0;
    private static final String CACHE_FILE_SYMBOL = "useSdkFileCache";
    private static final String CACHE_USE_ENABLE = "1";
    private PreLoadStateListener preLoadStateListener;
    private String preloadUrl = "";
    CachedWebViewClientDelegate webViewClientDelegate;
    CachedWebChromeClientDelegate webChromeClientDelegate;

    public void registerPreLoadListener(PreLoadStateListener preLoadStateListener) {
        this.preLoadStateListener = preLoadStateListener;
    }

    public void unRegisterPreLoadListener() {
        this.preLoadStateListener = null;
    }

    public CachedWebView(Context context) {
        super(context);
        this.init();
    }

    public CachedWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CachedWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public CachedWebView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void preload(String url) {
        this.loadUrl(url);
        this.changePreloadState(1);
        this.preloadUrl = url;
    }

    private void changePreloadState(int state) {
        this.preloadState = state;
        if (this.preLoadStateListener != null) {
            this.preLoadStateListener.onPreloadStateChanged(state);
        }
    }

    public void loadUrl(String url) {
        if (this.preloadState == 1 || this.preloadState == 2) {
            return;
        }
        super.loadUrl(url);
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        if (this.preloadState == 1 || this.preloadState == 2) {
            return;
        }
        super.loadUrl(url, additionalHttpHeaders);
    }

    public void setWebViewClientDelegate(CachedWebViewClientDelegate webViewClientDelegate) {
        this.webViewClientDelegate = webViewClientDelegate;
    }

    public void setWebChromeClientDelegate(CachedWebChromeClientDelegate webChromeClientDelegate) {
        this.webChromeClientDelegate = webChromeClientDelegate;
    }

    private void init() {
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        this.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                String url = view.getOriginalUrl();
                if (url != null && url.equals(CachedWebView.this.preloadUrl)) {
                    CachedWebView.this.changePreloadState(3);
                }
                if (CachedWebView.this.webViewClientDelegate != null) {
                    CachedWebView.this.webViewClientDelegate.onReceivedError(view, errorCode, description, failingUrl);
                }
            }

            @TargetApi(value=26)
            public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
                if (!detail.didCrash()) {
                    if (view != null) {
                        ViewGroup webViewContainer = (ViewGroup)view.getParent();
                        if (webViewContainer != null && webViewContainer.getChildCount() > 0) {
                            webViewContainer.removeView((View)view);
                        }
                        view.destroy();
                    }
                    return true;
                }
                return false;
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                boolean result;
                if (CachedWebView.this.webViewClientDelegate != null && (result = CachedWebView.this.webViewClientDelegate.shouldOverrideUrlLoading(url))) {
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                WebResourceResponse result;
                if (CachedWebView.this.webViewClientDelegate != null && (result = CachedWebView.this.webViewClientDelegate.shouldInterceptRequest(view, request)) != null) {
                    return result;
                }
                WebResourceResponse response = CachedWebView.this.checkSdkCacheFileRequest(view, request);
                if (response != null) {
                    return response;
                }
                return super.shouldInterceptRequest(view, request);
            }
        });
        this.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                String url;
                super.onProgressChanged(view, newProgress);
                if (view != null && newProgress == 100 && (url = view.getOriginalUrl()) != null && url.equals(CachedWebView.this.preloadUrl)) {
                    CachedWebView.this.changePreloadState(2);
                }
            }
        });
    }

    private WebResourceResponse checkSdkCacheFileRequest(WebView view, WebResourceRequest request) {
        if (request == null || view == null) {
            return null;
        }
        if (HttpUtil.HTTP_METHOD_GET.equals(request.getMethod()) && request.getUrl() != null && CACHE_USE_ENABLE.equals(request.getUrl().getQueryParameter(CACHE_FILE_SYMBOL))) {
            WebFileCache cache = WebFileCache.getInstance(view.getContext());
            try {
                if (cache != null) {
                    final String uriStr = request.getUrl().toString();
                    File file = cache.get(uriStr);
                    if (file == null || !file.exists()) {
                        cache.put(uriStr, new WebFileCache.Writer(){

                            @Override
                            public boolean write(File file) throws IOException {
                                IoUtil.copy(new URL(uriStr).openStream(), file);
                                return true;
                            }
                        });
                        file = cache.get(uriStr);
                    }
                    BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                    FileNameMap fileNameMap = URLConnection.getFileNameMap();
                    String fileName = uriStr.substring(uriStr.lastIndexOf("/") + 1, uriStr.lastIndexOf("?"));
                    String mimeType = fileNameMap.getContentTypeFor(fileName);
                    HashMap<String, String> responseHeader = new HashMap<String, String>();
                    responseHeader.put("Access-Control-Allow-Origin", "*");
                    return new WebResourceResponse(mimeType, "utf-8", 200, "success", responseHeader, (InputStream)inputStream);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static interface CachedWebChromeClientDelegate {
        public void openFileChooser(ValueCallback<Uri> var1, String var2, String var3);

        public boolean onShowFileChooser(WebView var1, ValueCallback<Uri[]> var2, WebChromeClient.FileChooserParams var3);
    }

    public static interface CachedWebViewClientDelegate {
        public void onPageLoadingCompleted();

        public void onReceivedTitle(String var1);

        public void showErrorView();

        public boolean shouldOverrideUrlLoading(String var1);

        public WebResourceResponse shouldInterceptRequest(WebView var1, WebResourceRequest var2);

        public void onReceivedError(WebView var1, int var2, String var3, String var4);
    }

    public static interface PreLoadStateListener {
        public void onPreloadStateChanged(int var1);
    }
}

