/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.UUID;

public enum GUIDHelper {
    INSTANCE;

    private static final String TAG;
    private static final String GUID_KEY = "GUID";
    private SharedPreferences mSp;

    public void init(Context context) {
        if (this.mSp != null) {
            return;
        }
        this.mSp = context.getApplicationContext().getSharedPreferences(TAG, 0);
    }

    public boolean initialized() {
        return this.mSp != null;
    }

    public String getUID() {
        String constructorUID = "";
        try {
            String guid = this.mSp.getString(GUID_KEY, "");
            if (!TextUtils.isEmpty((CharSequence)guid)) {
                return guid;
            }
            constructorUID = UUID.randomUUID().toString();
            this.saveGUIDToSP(constructorUID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructorUID;
    }

    private void saveGUIDToSP(String uid) {
        if (this.mSp != null) {
            this.mSp.edit().putString(GUID_KEY, uid).apply();
        }
    }

    static {
        TAG = GUIDHelper.class.getSimpleName();
    }
}

