/*
 * Decompiled with CFR 0.152.
 */
package tds.androidx.recyclerview.widget;

import android.util.SparseArray;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.List;
import tds.androidx.annotation.NonNull;
import tds.androidx.recyclerview.widget.NestedAdapterWrapper;

interface ViewTypeStorage {
    @NonNull
    public NestedAdapterWrapper getWrapperForGlobalType(int var1);

    @NonNull
    public ViewTypeLookup createViewTypeWrapper(@NonNull NestedAdapterWrapper var1);

    public static class IsolatedViewTypeStorage
    implements ViewTypeStorage {
        SparseArray<NestedAdapterWrapper> mGlobalTypeToWrapper = new SparseArray();
        int mNextViewType = 0;

        int obtainViewType(NestedAdapterWrapper wrapper) {
            int nextId = this.mNextViewType++;
            this.mGlobalTypeToWrapper.put(nextId, (Object)wrapper);
            return nextId;
        }

        @Override
        @NonNull
        public NestedAdapterWrapper getWrapperForGlobalType(int globalViewType) {
            NestedAdapterWrapper wrapper = (NestedAdapterWrapper)this.mGlobalTypeToWrapper.get(globalViewType);
            if (wrapper == null) {
                throw new IllegalArgumentException("Cannot find the wrapper for global view type " + globalViewType);
            }
            return wrapper;
        }

        @Override
        @NonNull
        public ViewTypeLookup createViewTypeWrapper(@NonNull NestedAdapterWrapper wrapper) {
            return new WrapperViewTypeLookup(wrapper);
        }

        void removeWrapper(@NonNull NestedAdapterWrapper wrapper) {
            for (int i = this.mGlobalTypeToWrapper.size() - 1; i >= 0; --i) {
                NestedAdapterWrapper existingWrapper = (NestedAdapterWrapper)this.mGlobalTypeToWrapper.valueAt(i);
                if (existingWrapper != wrapper) continue;
                this.mGlobalTypeToWrapper.removeAt(i);
            }
        }

        class WrapperViewTypeLookup
        implements ViewTypeLookup {
            private SparseIntArray mLocalToGlobalMapping = new SparseIntArray(1);
            private SparseIntArray mGlobalToLocalMapping = new SparseIntArray(1);
            final NestedAdapterWrapper mWrapper;

            WrapperViewTypeLookup(NestedAdapterWrapper wrapper) {
                this.mWrapper = wrapper;
            }

            @Override
            public int localToGlobal(int localType) {
                int index = this.mLocalToGlobalMapping.indexOfKey(localType);
                if (index > -1) {
                    return this.mLocalToGlobalMapping.valueAt(index);
                }
                int globalType = IsolatedViewTypeStorage.this.obtainViewType(this.mWrapper);
                this.mLocalToGlobalMapping.put(localType, globalType);
                this.mGlobalToLocalMapping.put(globalType, localType);
                return globalType;
            }

            @Override
            public int globalToLocal(int globalType) {
                int index = this.mGlobalToLocalMapping.indexOfKey(globalType);
                if (index < 0) {
                    throw new IllegalStateException("requested global type " + globalType + " does not belong to the adapter:" + this.mWrapper.adapter);
                }
                return this.mGlobalToLocalMapping.valueAt(index);
            }

            @Override
            public void dispose() {
                IsolatedViewTypeStorage.this.removeWrapper(this.mWrapper);
            }
        }
    }

    public static class SharedIdRangeViewTypeStorage
    implements ViewTypeStorage {
        SparseArray<List<NestedAdapterWrapper>> mGlobalTypeToWrapper = new SparseArray();

        @Override
        @NonNull
        public NestedAdapterWrapper getWrapperForGlobalType(int globalViewType) {
            List nestedAdapterWrappers = (List)this.mGlobalTypeToWrapper.get(globalViewType);
            if (nestedAdapterWrappers == null || nestedAdapterWrappers.isEmpty()) {
                throw new IllegalArgumentException("Cannot find the wrapper for global view type " + globalViewType);
            }
            return (NestedAdapterWrapper)nestedAdapterWrappers.get(0);
        }

        @Override
        @NonNull
        public ViewTypeLookup createViewTypeWrapper(@NonNull NestedAdapterWrapper wrapper) {
            return new WrapperViewTypeLookup(wrapper);
        }

        void removeWrapper(@NonNull NestedAdapterWrapper wrapper) {
            for (int i = this.mGlobalTypeToWrapper.size() - 1; i >= 0; --i) {
                List wrappers = (List)this.mGlobalTypeToWrapper.valueAt(i);
                if (!wrappers.remove(wrapper) || !wrappers.isEmpty()) continue;
                this.mGlobalTypeToWrapper.removeAt(i);
            }
        }

        class WrapperViewTypeLookup
        implements ViewTypeLookup {
            final NestedAdapterWrapper mWrapper;

            WrapperViewTypeLookup(NestedAdapterWrapper wrapper) {
                this.mWrapper = wrapper;
            }

            @Override
            public int localToGlobal(int localType) {
                ArrayList<NestedAdapterWrapper> wrappers = (ArrayList<NestedAdapterWrapper>)SharedIdRangeViewTypeStorage.this.mGlobalTypeToWrapper.get(localType);
                if (wrappers == null) {
                    wrappers = new ArrayList<NestedAdapterWrapper>();
                    SharedIdRangeViewTypeStorage.this.mGlobalTypeToWrapper.put(localType, wrappers);
                }
                if (!wrappers.contains(this.mWrapper)) {
                    wrappers.add(this.mWrapper);
                }
                return localType;
            }

            @Override
            public int globalToLocal(int globalType) {
                return globalType;
            }

            @Override
            public void dispose() {
                SharedIdRangeViewTypeStorage.this.removeWrapper(this.mWrapper);
            }
        }
    }

    public static interface ViewTypeLookup {
        public int localToGlobal(int var1);

        public int globalToLocal(int var1);

        public void dispose();
    }
}

