/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Xml;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;

public class WebUtils {
    public static final String APP_CACAHE_DIRNAME = "/webcache";

    public static WebSettings setWebSettings(WebView webView) {
        int n = Build.VERSION.SDK_INT;
        if (n > 10 && n < 17) {
            WebView webView2 = webView;
            webView2.removeJavascriptInterface("searchBoxJavaBridge_");
            webView2.removeJavascriptInterface("accessibility");
            webView2.removeJavascriptInterface("accessibilityTraversal");
        }
        WebView webView3 = webView;
        webView3.setHorizontalScrollBarEnabled(false);
        webView3.setVerticalScrollBarEnabled(false);
        webView3.setScrollbarFadingEnabled(false);
        WebSettings webSettings = webView3.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setAppCacheMaxSize(26188800L);
        webSettings.setTextZoom(100);
        if (n < 18) {
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        if (n >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        if (n >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(webView, true);
            webSettings.setMixedContentMode(0);
        }
        WebSettings webSettings2 = webSettings;
        webSettings2.setJavaScriptCanOpenWindowsAutomatically(false);
        webSettings2.setSupportMultipleWindows(false);
        webSettings2.setCacheMode(-1);
        webSettings2.setAllowFileAccess(false);
        if (n >= 16) {
            WebSettings webSettings3 = webSettings;
            webSettings3.setAllowFileAccessFromFileURLs(false);
            webSettings3.setAllowUniversalAccessFromFileURLs(false);
        }
        WebSettings webSettings4 = webSettings;
        webSettings4.setDatabaseEnabled(true);
        webSettings4.setAppCacheEnabled(true);
        webSettings4.setAppCachePath(webView.getContext().getFilesDir().getAbsolutePath() + APP_CACAHE_DIRNAME);
        webSettings4.setUseWideViewPort(true);
        webSettings4.setLoadWithOverviewMode(true);
        webSettings4.setSupportZoom(false);
        webSettings4.setBuiltInZoomControls(false);
        webSettings4.setNeedInitialFocus(false);
        webSettings4.setDefaultTextEncodingName(String.valueOf(Xml.Encoding.UTF_8));
        return webSettings4;
    }

    public static void clearDataAndCache(WebView webView) {
        if (webView == null) {
            return;
        }
        WebView webView2 = webView;
        webView2.clearCache(true);
        webView2.clearFormData();
        webView2.clearHistory();
    }

    public static void openWeb(Context context, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2.startsWith("http://") || string2.startsWith("https://"))) {
            string3 = string2;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string3));
        context.startActivity(intent);
    }
}

