/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.bridge.command;

import com.tds.common.bridge.BridgeCallback;
import com.tds.common.bridge.BridgeHolder;
import com.tds.common.bridge.IBridgeService;
import com.tds.common.bridge.annotation.BridgeMethod;
import com.tds.common.bridge.command.Command;
import com.tds.common.bridge.command.ICommandTask;
import com.tds.common.bridge.exception.EngineBridgeException;
import com.tds.common.bridge.exception.EngineBridgeExceptionStatus;
import com.tds.common.bridge.utils.BridgeJsonHelper;
import com.tds.common.bridge.utils.BridgeReflect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CommandTaskImpl
implements ICommandTask {
    @Override
    public void execute(Command command, BridgeCallback callback) {
        BridgeReflect.checkCommand(command);
        Object result = this.invoke(command, callback);
        if (result != null && command.callback) {
            callback.onResult(BridgeJsonHelper.object2JsonString(result));
        }
    }

    private Object invoke(Command command, BridgeCallback callback) {
        IBridgeService targetInstance = BridgeHolder.INSTANCE.getBridgeService(command.service).getValue();
        Method targetMethod = null;
        Object[] targetArgs = null;
        try {
            Method[] methods;
            Class<? extends IBridgeService> serviceClz = BridgeReflect.getRegisterService(command);
            for (Method method : methods = serviceClz.getMethods()) {
                Object[] args;
                BridgeMethod bridgeMethod = method.getAnnotation(BridgeMethod.class);
                if (bridgeMethod == null || !command.method.equals(bridgeMethod.value()) || (args = BridgeReflect.constructorCommandArgs(method, command, callback)).length != method.getParameterTypes().length) continue;
                targetMethod = method;
                targetArgs = args;
            }
            if (targetArgs == null || targetInstance == null) {
                throw new EngineBridgeException(EngineBridgeExceptionStatus.COMMAND_ARGS_ERROR.getMessage());
            }
            return targetMethod.invoke((Object)targetInstance, targetArgs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            String expandMessage = e.getCause() != null ? e.getCause().getMessage() : "";
            throw new EngineBridgeException(EngineBridgeExceptionStatus.COMMAND_ARGS_ERROR.getExpandMessage(expandMessage));
        }
    }
}

