/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.entities;

public class TapPaymentConfig {
    private final String regionId;
    private final String language;
    private final String wxAuthorizedDomainName;

    public String getRegionId() {
        return this.regionId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getWxAuthorizedDomainName() {
        return this.wxAuthorizedDomainName;
    }

    private TapPaymentConfig(Builder builder) {
        this.regionId = builder.regionId;
        this.language = builder.language;
        this.wxAuthorizedDomainName = builder.wxAuthorizedDomainName;
    }

    public String toString() {
        return "TapPaymentConfig{regionId='" + this.regionId + '\'' + ", language='" + this.language + '\'' + ", wxAuthorizedDomainName='" + this.wxAuthorizedDomainName + '\'' + '}';
    }

    public static class Builder {
        private String regionId;
        private String language = "";
        private String wxAuthorizedDomainName;

        public Builder withRegionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        public Builder withLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder withWXAuthorizedDomainName(String authorizedDomainName) {
            this.wxAuthorizedDomainName = authorizedDomainName;
            return this;
        }

        public TapPaymentConfig build() {
            return new TapPaymentConfig(this);
        }
    }
}

