/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.io;

import android.text.TextUtils;
import com.tds.common.log.Logger;
import com.tds.common.log.TdsBaseException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class IoUtil {
    private static final String TAG = IoUtil.class.getSimpleName();
    private static final Logger LOG = Logger.get("common_log");
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = IoUtil.readString(in);
        }
        catch (Exception e) {
            String string2;
            try {
                LOG.w(TAG, new TdsBaseException(e));
                string2 = null;
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(in);
                throw throwable;
            }
            IoUtil.closeQuietly(in);
            return string2;
        }
        IoUtil.closeQuietly(in);
        return string;
    }

    public static String readString(InputStream in) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        return out.toString();
    }

    public static void move(File src, File dest) {
        if (!src.renameTo(dest) && IoUtil.copy(src, dest)) {
            IoUtil.deleteFile(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean bl;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(src);
            IoUtil.copy((InputStream)fin, dest);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                LOG.w(TAG, new TdsBaseException(e));
                bl2 = false;
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(fin);
                throw throwable;
            }
            IoUtil.closeQuietly(fin);
            return bl2;
        }
        IoUtil.closeQuietly(fin);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ZipFile zipFile, ZipEntry zipEntry, File dest) {
        InputStream is = null;
        try {
            is = zipFile.getInputStream(zipEntry);
            IoUtil.copy(is, dest);
        }
        catch (IOException e) {
            LOG.w(TAG, new TdsBaseException(e));
        }
        finally {
            IoUtil.closeQuietly(is);
        }
    }

    public static void copy(InputStream is, File dest) throws IOException {
        IoUtil.copy(is, dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, File dest, boolean append) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(dest, append);
            IoUtil.copy(is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(os);
            throw throwable;
        }
        IoUtil.closeQuietly(os);
    }

    public static void copy(File src, OutputStream os) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(src);
            IoUtil.copy((InputStream)is, os);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(is);
            throw throwable;
        }
        IoUtil.closeQuietly(is);
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[8192];
        int count = 0;
        while ((count = is.read(buf)) > 0) {
            os.write(buf, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String s) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(s.getBytes());
        }
        catch (Exception e) {
            try {
                LOG.w(TAG, new TdsBaseException(e));
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(out);
                throw throwable;
            }
            IoUtil.closeQuietly(out);
        }
        IoUtil.closeQuietly(out);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.w(TAG, new TdsBaseException(e));
            }
        }
    }

    public static void closeQuietly(ZipFile closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.w(TAG, new TdsBaseException(e));
            }
        }
    }

    public static boolean mkdirs(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return IoUtil.mkdirs(new File(path));
    }

    public static boolean mkdirs(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        return dir.mkdirs();
    }

    public static boolean deleteDir(File dir) {
        File[] allContents = dir.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                IoUtil.deleteDir(file);
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String path) {
        return IoUtil.deleteFile(new File(path));
    }

    public static boolean deleteFile(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        return true;
    }
}

