/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net;

import android.text.TextUtils;
import com.tds.common.net.error.ErrorHandler;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class TDSNetInterceptor {
    private HashMap<String, ErrorHandler> errorHandlerList;

    private TDSNetInterceptor() {
    }

    public static TDSNetInterceptor getInstance() {
        return Holder.INSTANCE;
    }

    public static void registerNetInterceptor(String from, ErrorHandler handler) {
        if (!TextUtils.isEmpty((CharSequence)from) && handler != null) {
            TDSNetInterceptor.getErrorHandlerList().put(from, handler);
        }
    }

    public static void unRegisterNetInterceptor(String from) {
        TDSNetInterceptor.getErrorHandlerList().remove(from);
    }

    public static void interceptWithContent(int statusCode, String message, String responseBody) {
        if (TDSNetInterceptor.getErrorHandlerList().size() > 0) {
            for (ErrorHandler handler : TDSNetInterceptor.getErrorHandlerList().values()) {
                handler.invoke(statusCode, message, responseBody);
            }
        }
    }

    private static HashMap<String, ErrorHandler> getErrorHandlerList() {
        if (TDSNetInterceptor.getInstance().errorHandlerList == null) {
            TDSNetInterceptor.getInstance().errorHandlerList = new HashMap();
        }
        return TDSNetInterceptor.getInstance().errorHandlerList;
    }

    public static void checkAuthErrorAccessDenied(String jsonString, CheckAuthCallback callback) {
        TDSNetInterceptor.checkAuthError(jsonString, callback, "access_denied");
    }

    public static void checkAuthError(String jsonString, CheckAuthCallback callback, String ... errorList) {
        block4: {
            try {
                JSONObject dataObject;
                JSONObject object = new JSONObject(jsonString);
                if (object.optBoolean("success", false) || (dataObject = object.optJSONObject("data")) == null) break block4;
                String error = dataObject.getString("error");
                for (String tagError : errorList) {
                    if (!TextUtils.equals((CharSequence)tagError.toLowerCase(), (CharSequence)error.toLowerCase())) continue;
                    if (callback != null) {
                        callback.onAuthError(dataObject.toString());
                    }
                    break;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface CheckAuthCallback {
        public void onAuthError(String var1);
    }

    private static class Holder {
        private static final TDSNetInterceptor INSTANCE = new TDSNetInterceptor();

        private Holder() {
        }
    }
}

