/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.oauth.models;

import android.os.Build;
import com.tds.common.entities.AccessToken;
import com.tds.common.entities.TapConfig;
import com.tds.common.net.ResponseBean;
import com.tds.common.net.Skynet;
import com.tds.common.net.TdsApiClient;
import com.tds.common.net.json.TypeRef;
import com.tds.common.oauth.AuthorizeResultCallBack;
import com.tds.common.oauth.RegionType;
import com.tds.common.oauth.models.AuthorizeResponse;
import com.tds.common.oauth.utils.RegionUtil;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tds.common.reactor.schedulers.Schedulers;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizeFlow {
    public static void exchangeTokenByCode(TapConfig tapConfig, String code, String codeVerifier, final String state, final AuthorizeResultCallBack loginResultCallBack) {
        TdsApiClient client = Skynet.getInstance().getTdsApiClient("tap_common_open_api");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", tapConfig.clientId);
        params.put("grant_type", "authorization_code");
        params.put("secret_type", "hmac-sha-1");
        params.put("code", code);
        params.put("redirect_uri", "tapoauth://authorize");
        params.put("code_verifier", codeVerifier);
        params.put("version", "3.16.5");
        params.put("platform", "android");
        JSONObject info = new JSONObject();
        try {
            info.put("device_id", (Object)(Build.MANUFACTURER + " " + Build.MODEL));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("info", info.toString());
        RegionType regionType = RegionUtil.getRegionType(tapConfig.regionType);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", "TapTapAndroidSDK/3.16.5 " + System.getProperty("http.agent"));
        JSONObject emptyJSONObject = new JSONObject();
        client.postAsync(new TypeRef<ResponseBean<AccessToken>>(){}, regionType.tokenUrl(), params, headers, emptyJSONObject).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<ResponseBean<AccessToken>>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                AuthorizeResponse response = new AuthorizeResponse(null, state, e.getMessage(), null, false);
                if (null != loginResultCallBack) {
                    loginResultCallBack.onAuthorizeResult(response);
                }
            }

            @Override
            public void onNext(ResponseBean<AccessToken> data) {
                if (data.success) {
                    AuthorizeResponse response = new AuthorizeResponse(null, state, null, (AccessToken)data.data, false);
                    if (null != loginResultCallBack) {
                        loginResultCallBack.onAuthorizeResult(response);
                    }
                } else {
                    AuthorizeResponse response = new AuthorizeResponse(null, state, "result is null", null, false);
                    loginResultCallBack.onAuthorizeResult(response);
                }
            }
        });
    }
}

