/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.permission;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.tds.common.permission.FragmentDelegate;
import com.tds.common.permission.PermissionConfig;
import com.tds.common.permission.PermissionDialog;
import com.tds.common.permission.PermissionDialogCallback;
import com.tds.common.permission.RequestPermissionCallback;
import com.tds.common.permission.TdsPermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class FragmentDelegateImpl
implements FragmentDelegate,
PermissionDialogCallback {
    public static final int REQUEST_PERMISSION_CODE = 1;
    public static final int FORWARD_TO_SETTING = 2;
    public static final int REQUEST_PERMISSION_FROM_SETTING = 3;
    private Set<String> mPermissions = new HashSet<String>();
    private Set<String> mGrantedPermissions = new HashSet<String>();
    private Set<String> mDeniedPermissions = new HashSet<String>();
    private Set<String> mPermanentDeniedPermissions = new HashSet<String>();
    private Set<String> forwardPermissions = new HashSet<String>();
    private RequestPermissionCallback mCallback;
    private PermissionConfig mConfig;
    private Fragment mFragment;
    private boolean forwardSetting = false;

    @Override
    public void bind(Fragment context) {
        this.mFragment = context;
    }

    @Override
    public void requestPermission(final Set<String> permissions, final RequestPermissionCallback callback, final PermissionConfig config) {
        this.mCallback = callback;
        this.mPermissions.clear();
        this.mGrantedPermissions.clear();
        this.mDeniedPermissions.clear();
        if (Build.VERSION.SDK_INT >= 23) {
            for (String permission : permissions) {
                if (!TdsPermission.checkPermission(this.mFragment.getContext(), permission)) {
                    this.mGrantedPermissions.remove(permission);
                    this.mDeniedPermissions.add(permission);
                    continue;
                }
                this.mGrantedPermissions.add(permission);
                this.mDeniedPermissions.remove(permission);
            }
        }
        if (this.mDeniedPermissions.isEmpty()) {
            callback.onResult(true, new ArrayList<String>(permissions), new ArrayList<String>());
        } else {
            PermissionDialog.newInstance(config.intentTitle, config.intentReason, config.intentCancelText, config.intentConfirmText, new PermissionDialogCallback(){

                @Override
                public void onConfirm() {
                    FragmentDelegateImpl.this.requestPermission(permissions, callback, config, 1);
                }

                @Override
                public void onClose() {
                    FragmentDelegateImpl.this.onClose();
                }
            }).show(this.mFragment.getChildFragmentManager(), PermissionDialog.TAG);
        }
    }

    private void requestPermission(Set<String> permissions, RequestPermissionCallback callback, PermissionConfig config, int requestCode) {
        this.mPermissions = permissions;
        this.mCallback = callback;
        this.mConfig = config;
        boolean bl = this.forwardSetting = !TextUtils.isEmpty((CharSequence)this.mConfig.tipTitle) && !TextUtils.isEmpty((CharSequence)this.mConfig.tipReason);
        if (Build.VERSION.SDK_INT >= 23) {
            this.mFragment.requestPermissions(this.mPermissions.toArray(new String[0]), requestCode);
        } else {
            callback.onResult(true, new ArrayList<String>(permissions), new ArrayList<String>());
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 1 || requestCode == 3) {
            this.handlerRequestPermission(permissions, grantResults, requestCode);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 2) {
            this.requestPermission(this.forwardPermissions, this.mCallback, this.mConfig, 3);
        }
    }

    private void handlerRequestPermission(String[] permissions, int[] grantResults, int requestCode) {
        boolean allGranted;
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (grantResults[i] == 0) {
                this.mGrantedPermissions.add(permission);
                this.mDeniedPermissions.remove(permission);
                this.mPermanentDeniedPermissions.remove(permission);
                continue;
            }
            boolean shouldShowRationale = this.mFragment.shouldShowRequestPermissionRationale(permission);
            if (shouldShowRationale) {
                this.mDeniedPermissions.add(permission);
                continue;
            }
            this.mPermanentDeniedPermissions.add(permission);
            this.mDeniedPermissions.remove(permission);
        }
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        deniedPermissions.addAll(this.mPermanentDeniedPermissions);
        deniedPermissions.addAll(this.mDeniedPermissions);
        for (String permission : deniedPermissions) {
            if (!TdsPermission.checkPermission((Context)this.mFragment.getActivity(), permission)) continue;
            this.mDeniedPermissions.remove(permission);
            this.mGrantedPermissions.add(permission);
        }
        boolean bl = allGranted = this.mGrantedPermissions.size() >= this.mPermissions.size() && this.mDeniedPermissions.size() <= 0;
        if (allGranted) {
            if (this.mCallback != null) {
                this.mCallback.onResult(true, new ArrayList<String>(this.mGrantedPermissions), new ArrayList<String>(this.mDeniedPermissions));
            }
        } else {
            if (this.mPermanentDeniedPermissions.size() <= 0) {
                if (this.mCallback != null) {
                    this.mCallback.onResult(false, new ArrayList<String>(this.mGrantedPermissions), new ArrayList<String>(this.mDeniedPermissions));
                }
                return;
            }
            this.forwardPermissions.clear();
            this.forwardPermissions.addAll(this.mPermanentDeniedPermissions);
            if (requestCode == 1) {
                if (this.forwardSetting) {
                    this.showForwardSetting();
                } else {
                    this.onConfirm();
                }
            } else if (requestCode == 3) {
                this.mCallback.onResult(false, new ArrayList<String>(this.mGrantedPermissions), new ArrayList<String>(this.mDeniedPermissions));
            }
        }
    }

    private void showForwardSetting() {
        PermissionDialog.newInstance(this.mConfig.tipTitle, this.mConfig.tipReason, this.mConfig.tipCancelText, this.mConfig.tipConfirmText, this).show(this.mFragment.getChildFragmentManager(), PermissionDialog.TAG);
    }

    @Override
    public void onConfirm() {
        Activity activity = this.mFragment.getActivity();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)activity.getPackageName(), null);
        intent.setData(uri);
        if (this.mFragment != null) {
            this.mFragment.startActivityForResult(intent, 2);
        }
    }

    @Override
    public void onClose() {
        this.mCallback.onResult(false, new ArrayList<String>(this.mGrantedPermissions), new ArrayList<String>(this.mDeniedPermissions));
    }
}

