/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.transformer;

import com.tds.common.reactor.Observable;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.exceptions.FlowException;
import com.tds.common.reactor.transformer.FlowArbiter;
import com.tds.common.reactor.transformer.FlowCall;
import com.tds.common.reactor.transformer.FlowCallback;

public class FlowEnqueueOnSubscribe<T>
implements Observable.OnSubscribe<FlowArbiter.FlowResult<T>> {
    private final FlowCall<T> flowCall;

    public FlowEnqueueOnSubscribe(FlowCall<T> flowCall) {
        this.flowCall = flowCall;
    }

    @Override
    public void call(Subscriber<? super FlowArbiter.FlowResult<T>> subscriber) {
        FlowCall<T> call = this.flowCall.clone();
        final FlowArbiter<T> arbiter = new FlowArbiter<T>(call, subscriber);
        subscriber.setProducer(arbiter);
        call.enqueue(new FlowCallback<T>(){

            @Override
            public void onSuccess(FlowArbiter.FlowResult<T> result) {
                arbiter.emitResponse(result);
            }

            @Override
            public void onError(int code, String message) {
                arbiter.emitError(new FlowException(code, message));
            }
        });
    }
}

