/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.tracker.model;

import android.text.TextUtils;
import com.tds.common.tracker.model.BaseTrackModel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class ActionModel
implements BaseTrackModel {
    public static final int ACTION_CLICK = 0;
    public static final int ACTION_LIKE = 1;
    public static final int ACTION_COMMENT = 2;
    public static final int ACTION_COLLECT = 3;
    public static final int ACTION_IMPRESSION = 4;
    public static final String PARAM_NAME_CLICK = "click";
    public static final String PARAM_NAME_LIKE = "like";
    public static final String PARAM_NAME_COMMENT = "comment";
    public static final String PARAM_NAME_COLLECT = "collect";
    public static final String PARAM_NAME_IMPRESSION = "impression";
    private String targetViewName = "";
    private int actionType = -1;

    public ActionModel clickWithViewName(String viewName) {
        this.targetViewName = viewName;
        this.actionType = 0;
        return this;
    }

    public ActionModel likeWithViewName(String viewName) {
        this.targetViewName = viewName;
        this.actionType = 1;
        return this;
    }

    public ActionModel commentWithViewName(String viewName) {
        this.targetViewName = viewName;
        this.actionType = 2;
        return this;
    }

    public ActionModel collectWithViewName(String viewName) {
        this.targetViewName = viewName;
        this.actionType = 3;
        return this;
    }

    public ActionModel impressionWithViewName(String viewName) {
        this.targetViewName = viewName;
        this.actionType = 4;
        return this;
    }

    @Override
    public Map<String, String> convert() {
        HashMap<String, String> actionsMap = new HashMap<String, String>();
        String key = "";
        switch (this.actionType) {
            case 0: {
                key = PARAM_NAME_CLICK;
                break;
            }
            case 1: {
                key = PARAM_NAME_LIKE;
                break;
            }
            case 2: {
                key = PARAM_NAME_COMMENT;
                break;
            }
            case 3: {
                key = PARAM_NAME_COLLECT;
                break;
            }
            case 4: {
                key = PARAM_NAME_IMPRESSION;
                break;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)this.targetViewName)) {
            actionsMap.put(key, this.targetViewName);
        }
        return actionsMap;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

